/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.templateLanguages.DataLanguageBlockWrapper;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlock;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlockFactory;
import com.intellij.formatting.templateLanguages.TemplateLanguageFormattingModelBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.velocity.editorActions.VtlCommenter;
import com.intellij.velocity.psi.formatter.VtlBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VtlFormattingModelBuilder
extends TemplateLanguageFormattingModelBuilder {
    public TemplateLanguageBlock createTemplateLanguageBlock(@NotNull ASTNode node, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable List<DataLanguageBlockWrapper> foreignChildren, @NotNull CodeStyleSettings codeStyleSettings) {
        PsiElement psi;
        if (node == null) {
            VtlFormattingModelBuilder.$$$reportNull$$$0(0);
        }
        if (codeStyleSettings == null) {
            VtlFormattingModelBuilder.$$$reportNull$$$0(1);
        }
        if ((psi = node.getPsi()) instanceof PsiComment && new VtlCommenter().isDocumentationComment((PsiComment)psi)) {
            return new VtlDocCommentBlock(codeStyleSettings, node, foreignChildren, this);
        }
        return new VtlBlock((TemplateLanguageBlockFactory)this, codeStyleSettings, node, foreignChildren, wrap);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "node";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "codeStyleSettings";
                break;
            }
        }
        objectArray[1] = "com/intellij/velocity/psi/formatter/VtlFormattingModelBuilder";
        objectArray[2] = "createTemplateLanguageBlock";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class VtlDocCommentBlock
    extends VtlBlock {
        VtlDocCommentBlock(CodeStyleSettings codeStyleSettings, ASTNode node, List<DataLanguageBlockWrapper> foreignChildren, VtlFormattingModelBuilder factory) {
            super((TemplateLanguageBlockFactory)factory, codeStyleSettings, node, foreignChildren, null);
        }

        protected List<Block> buildChildren() {
            ArrayList<Block> blocks = new ArrayList<Block>();
            int lineStart = 0;
            String text = this.myNode.getText();
            while (true) {
                int end;
                int nextEol;
                String line = text.substring(lineStart, (nextEol = text.indexOf(10, lineStart)) < 0 ? text.length() : nextEol);
                int start = CharArrayUtil.shiftForward((CharSequence)text, (int)lineStart, (String)" \t");
                if (start < (end = CharArrayUtil.shiftBackward((CharSequence)text, (int)(lineStart + line.length() - 1), (String)" \t") + 1)) {
                    blocks.add((Block)new VtlDocLineBlock(this.myNode, start, end));
                }
                if (nextEol < 0) break;
                lineStart = nextEol + 1;
            }
            return blocks;
        }

        public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
            if (child2 == null) {
                VtlDocCommentBlock.$$$reportNull$$$0(0);
            }
            return child1 == null ? null : Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)true, (int)10);
        }

        public boolean isLeaf() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/velocity/psi/formatter/VtlFormattingModelBuilder$VtlDocCommentBlock", "getSpacing"));
        }
    }

    private static class VtlDocLineBlock
    extends AbstractBlock {
        private final int myStart;
        private final int myEnd;
        private final int myCommentStart;

        VtlDocLineBlock(ASTNode node, int start, int end) {
            super(node, null, null);
            this.myStart = start;
            this.myEnd = end;
            this.myCommentStart = this.myNode.getTextRange().getStartOffset();
        }

        boolean isFirstDocLine() {
            return this.myStart == 0;
        }

        @NotNull
        public TextRange getTextRange() {
            TextRange textRange = new TextRange(this.myStart, this.myEnd).shiftRight(this.myCommentStart);
            if (textRange == null) {
                VtlDocLineBlock.$$$reportNull$$$0(0);
            }
            return textRange;
        }

        protected List<Block> buildChildren() {
            return Collections.emptyList();
        }

        public Spacing getSpacing(Block child1, @NotNull Block child2) {
            if (child2 == null) {
                VtlDocLineBlock.$$$reportNull$$$0(1);
            }
            return null;
        }

        public Indent getIndent() {
            return this.isFirstDocLine() ? null : Indent.getSpaceIndent((int)1);
        }

        public boolean isLeaf() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/velocity/psi/formatter/VtlFormattingModelBuilder$VtlDocLineBlock";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextRange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/velocity/psi/formatter/VtlFormattingModelBuilder$VtlDocLineBlock";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getSpacing";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

