/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.inspections.wellformedness;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.inspections.VtlInspectionBase;
import com.intellij.velocity.psi.PsiUtil;
import com.intellij.velocity.psi.VtlParameterDeclaration;
import com.intellij.velocity.psi.directives.VtlAssignment;
import com.intellij.velocity.psi.reference.VtlReferenceExpression;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VtlInterpolationsInspection
extends VtlInspectionBase {
    @Override
    protected void registerProblems(PsiElement element, ProblemsHolder holder) {
        VtlReferenceExpression wouldBeVariableDeclared;
        if (element instanceof VtlParameterDeclaration) {
            PsiElement wouldBeFormalNotationStart = element.getFirstChild();
            if (PsiUtil.isFormalNotationStart(wouldBeFormalNotationStart)) {
                PsiElement errorElement = wouldBeFormalNotationStart.getNextSibling();
                if (errorElement.getTextRange().isEmpty()) {
                    errorElement = wouldBeFormalNotationStart;
                }
                VtlInterpolationsInspection.registerFormalNotationProblem(errorElement, holder);
            }
        } else if (element instanceof VtlAssignment && (wouldBeVariableDeclared = ((VtlAssignment)element).getAssignedVariableElement(null)) != null && PsiUtil.isFormalNotationStart(wouldBeVariableDeclared.getPrevSibling())) {
            VtlInterpolationsInspection.registerFormalNotationProblem(wouldBeVariableDeclared, holder);
        }
    }

    private static void registerFormalNotationProblem(PsiElement element, ProblemsHolder holder) {
        holder.registerProblem(element, VelocityBundle.message("vtl.formal.notation.is.not.allowed", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            VtlInterpolationsInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "VtlInterpolationsInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/inspections/wellformedness/VtlInterpolationsInspection", "getDefaultLevel"));
    }
}

