/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity;

import com.intellij.codeInsight.folding.CodeFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.velocity.VtlReferenceContributor;
import com.intellij.velocity.psi.VtlMacro;
import com.intellij.velocity.psi.directives.VtlDirective;
import com.intellij.velocity.psi.files.VtlFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VtlFoldingBuilder
implements FoldingBuilder,
DumbAware {
    public FoldingDescriptor @NotNull [] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        PsiElement element;
        if (node == null) {
            VtlFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (document == null) {
            VtlFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (!((element = node.getPsi()) instanceof VtlFile)) {
            if (FoldingDescriptor.EMPTY == null) {
                VtlFoldingBuilder.$$$reportNull$$$0(2);
            }
            return FoldingDescriptor.EMPTY;
        }
        ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>();
        PsiElement firstChild = element.getFirstChild();
        if (firstChild != null && FormatterUtil.containsWhiteSpacesOnly((ASTNode)firstChild.getNode())) {
            firstChild = firstChild.getNextSibling();
        }
        if (firstChild instanceof PsiComment && !VtlReferenceContributor.isSpecialComment((PsiComment)firstChild)) {
            descriptors.add(new FoldingDescriptor(firstChild.getNode(), firstChild.getTextRange()));
        }
        for (VtlDirective composite : ((VtlFile)element).getDirectiveChildren()) {
            VtlFoldingBuilder.addFoldingDescriptors(descriptors, composite);
        }
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(FoldingDescriptor.EMPTY);
        if (foldingDescriptorArray == null) {
            VtlFoldingBuilder.$$$reportNull$$$0(3);
        }
        return foldingDescriptorArray;
    }

    private static void addFoldingDescriptors(List<FoldingDescriptor> descriptors, VtlDirective composite) {
        int start = composite.getFoldingStartOffset();
        int end = composite.getFoldingEndOffset();
        ASTNode node = composite.getNode();
        if (start + 1 >= end || node == null) {
            return;
        }
        descriptors.add(new FoldingDescriptor(node, new TextRange(start, end)));
        for (VtlDirective child : composite.getDirectiveChildren()) {
            VtlFoldingBuilder.addFoldingDescriptors(descriptors, child);
        }
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        PsiElement psi;
        if (node == null) {
            VtlFoldingBuilder.$$$reportNull$$$0(4);
        }
        if ((psi = node.getPsi()) instanceof VtlMacro) {
            return "(" + ((VtlMacro)psi).getName() + ")...";
        }
        if (psi instanceof PsiComment) {
            return "#*...*#";
        }
        return "...";
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            VtlFoldingBuilder.$$$reportNull$$$0(5);
        }
        if (node instanceof PsiComment) {
            return CodeFoldingSettings.getInstance().COLLAPSE_FILE_HEADER;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/velocity/VtlFoldingBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/velocity/VtlFoldingBuilder";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

