/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.utils;

import com.intellij.facet.FacetTypeId;
import com.intellij.jam.JamService;
import com.intellij.javaee.ejb.NewEjbRoleHolder;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.model.EnterpriseBean;
import com.intellij.javaee.ejb.model.Interceptor;
import com.intellij.javaee.ejb.model.annotations.ejb.EnvironmentGroupImpl;
import com.intellij.javaee.ejb.model.common.EnvironmentGroup;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.ejb.role.EjbClassRoleImpl;
import com.intellij.javaee.ejb.role.EjbMethodRole;
import com.intellij.javaee.model.JavaeeReference;
import com.intellij.javaee.util.JavaeeCachesUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OldEjbRolesUtil {
    private static final JavaeeCachesUtil.CachedValueProviderProvider<Map<PsiMember, JavaeeReference[]>, PsiElement> INJECTED_REFERENCE_PROVIDER_PROVIDER = new JavaeeCachesUtil.CachedValueProviderProvider<Map<PsiMember, JavaeeReference[]>, PsiElement>(){

        public CachedValueProvider<Map<PsiMember, JavaeeReference[]>> createProvider(PsiElement psiElement) {
            return () -> {
                EnvironmentGroup environment;
                PsiClass containingClass = (PsiClass)psiElement;
                EjbClassRole[] classRoles = OldEjbRolesUtil.getEjbRoles(containingClass);
                if (classRoles.length == 0) {
                    environment = (EnvironmentGroup)JamService.getJamService((Project)containingClass.getProject()).getJamElement(EnvironmentGroupImpl.JAVAEE_ENVIRONMENT_KEY, (PsiElement)containingClass);
                    if (environment == null) {
                        return new CachedValueProvider.Result(Collections.emptyMap(), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                    }
                } else {
                    environment = null;
                }
                HashMap map = new HashMap();
                HashSet<Object> dependencyItemsList = new HashSet<Object>();
                Processor processor = reference -> {
                    for (GenericValue genericValue : reference.getTargetMembers()) {
                        PsiMember key = (PsiMember)genericValue.getValue();
                        if (key == null) continue;
                        HashSet<JavaeeReference> set = (HashSet<JavaeeReference>)map.get(key);
                        if (set == null) {
                            set = new HashSet<JavaeeReference>();
                            map.put(key, set);
                        }
                        set.add((JavaeeReference)reference);
                    }
                    return true;
                };
                if (environment != null) {
                    ContainerUtil.process((List)environment.getEjbReferences(), (Processor)processor);
                    ContainerUtil.process((List)environment.getResources(), (Processor)processor);
                }
                for (EjbClassRole classRole : classRoles) {
                    Interceptor environmentGroup;
                    if (classRole.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_INTERCEPTOR_CLASS) {
                        environmentGroup = classRole.getInterceptor();
                    } else {
                        if (classRole.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS) continue;
                        environmentGroup = classRole.getEnterpriseBean();
                    }
                    assert (environmentGroup != null);
                    ModificationTracker ejbFacetTracker = classRole.getFacet().getModificationTracker();
                    dependencyItemsList.add(ejbFacetTracker);
                    ContainerUtil.process((List)environmentGroup.getEjbReferences(), (Processor)processor);
                    ContainerUtil.process((List)environmentGroup.getResources(), (Processor)processor);
                }
                HashMap<PsiMember, JavaeeReference[]> result = new HashMap<PsiMember, JavaeeReference[]>();
                for (PsiMember psiMember : map.keySet()) {
                    Collection references = (Collection)map.get(psiMember);
                    result.put(psiMember, references.toArray(JavaeeReference.EMPTY_ARRAY));
                }
                dependencyItemsList.add(PsiModificationTracker.MODIFICATION_COUNT);
                Object[] dependencyItems = dependencyItemsList.toArray();
                return new CachedValueProvider.Result(result, dependencyItems);
            };
        }
    };
    private static final JavaeeCachesUtil.CachedValueProviderProvider<EjbMethodRole[], PsiElement> METHOD_ROLE_PROVIDER_PROVIDER = new JavaeeCachesUtil.CachedValueProviderProvider<EjbMethodRole[], PsiElement>(){

        public CachedValueProvider<EjbMethodRole[]> createProvider(PsiElement psiElement) {
            return () -> {
                PsiMethod method = (PsiMethod)psiElement;
                PsiClass containingClass = method.getContainingClass();
                EjbClassRole[] classRoles = OldEjbRolesUtil.getEjbRoles(containingClass);
                if (classRoles.length == 0) {
                    return new CachedValueProvider.Result((Object)EjbMethodRole.EMPTY_ARRAY, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                }
                ArrayList<EjbMethodRole> rolesList = new ArrayList<EjbMethodRole>(classRoles.length);
                HashSet<Object> dependencyItemsList = new HashSet<Object>();
                for (EjbClassRole classRole : classRoles) {
                    EjbMethodRole methodRole = classRole.getMethodRole(method);
                    if (methodRole != null) {
                        rolesList.add(methodRole);
                    }
                    EnterpriseBean ejb = classRole.getEnterpriseBean();
                    Interceptor interceptor = classRole.getInterceptor();
                    assert (ejb != null || interceptor != null);
                    EjbFacet ejbFacet = classRole.getFacet();
                    dependencyItemsList.add(ejbFacet.getModificationTracker());
                }
                dependencyItemsList.add(PsiModificationTracker.MODIFICATION_COUNT);
                EjbMethodRole[] roles = rolesList.size() == 0 ? EjbMethodRole.EMPTY_ARRAY : rolesList.toArray(EjbMethodRole.EMPTY_ARRAY);
                Object[] dependencyItems = dependencyItemsList.toArray();
                return new CachedValueProvider.Result((Object)roles, dependencyItems);
            };
        }
    };

    private OldEjbRolesUtil() {
    }

    @Deprecated
    @Nullable
    public static EjbMethodRole getEjbRole(PsiMethod method) {
        EjbMethodRole[] methodRoles = OldEjbRolesUtil.getEjbRoles(method);
        if (methodRoles.length == 0) {
            return null;
        }
        return methodRoles[0];
    }

    @Deprecated
    @Nullable
    public static EjbClassRole getEjbRole(PsiClass psiClass) {
        EjbClassRole[] classRoles = OldEjbRolesUtil.getEjbRoles(psiClass);
        if (classRoles.length == 0) {
            return null;
        }
        return classRoles[0];
    }

    public static EjbMethodRole @NotNull [] getEjbRoles(PsiMethod method) {
        EjbMethodRole[] methodRoles = (EjbMethodRole[])JavaeeCachesUtil.getJavaeeValue((PsiElement)method, METHOD_ROLE_PROVIDER_PROVIDER, (FacetTypeId)EjbFacet.ID);
        EjbMethodRole[] ejbMethodRoleArray = methodRoles != null ? methodRoles : EjbMethodRole.EMPTY_ARRAY;
        if (ejbMethodRoleArray == null) {
            OldEjbRolesUtil.$$$reportNull$$$0(0);
        }
        return ejbMethodRoleArray;
    }

    public static EjbClassRole @NotNull [] getEjbRoles(PsiClass psiClass) {
        NewEjbRoleHolder roleHolder;
        if (psiClass != null && (roleHolder = NewEjbRoleHolder.getInstance(psiClass.getProject())) != null) {
            EjbClassRole[] ejbClassRoleArray = roleHolder.getMergedRoles(psiClass);
            if (ejbClassRoleArray == null) {
                OldEjbRolesUtil.$$$reportNull$$$0(1);
            }
            return ejbClassRoleArray;
        }
        if (EjbClassRoleImpl.EMPTY_ARRAY == null) {
            OldEjbRolesUtil.$$$reportNull$$$0(2);
        }
        return EjbClassRoleImpl.EMPTY_ARRAY;
    }

    public static JavaeeReference @NotNull [] getInjectedReferences(PsiMember psiMember) {
        PsiClass containingClass = psiMember instanceof PsiClass ? (PsiClass)psiMember : psiMember.getContainingClass();
        Map injectedReferencesMap = (Map)JavaeeCachesUtil.getJavaeeValue((UserDataHolder)containingClass, (PsiManager)psiMember.getManager(), INJECTED_REFERENCE_PROVIDER_PROVIDER);
        JavaeeReference[] injectedReferences = injectedReferencesMap == null ? null : (JavaeeReference[])injectedReferencesMap.get(psiMember);
        JavaeeReference[] javaeeReferenceArray = injectedReferences != null ? injectedReferences : JavaeeReference.EMPTY_ARRAY;
        if (javaeeReferenceArray == null) {
            OldEjbRolesUtil.$$$reportNull$$$0(3);
        }
        return javaeeReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/javaee/ejb/utils/OldEjbRolesUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEjbRoles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedReferences";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

