/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.utils;

import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.ejb.role.EjbImplMethodRole;
import com.intellij.javaee.ejb.role.EjbMethodRole;
import com.intellij.javaee.ejb.utils.EjbUtil;
import com.intellij.javaee.ejb.utils.OldEjbRolesUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;

public class EjbSuperMethodSearcher
implements QueryExecutor<MethodSignatureBackedByPsiMethod, SuperMethodsSearch.SearchParameters> {
    public boolean execute(@NotNull SuperMethodsSearch.SearchParameters queryParameters, @NotNull Processor<? super MethodSignatureBackedByPsiMethod> consumer) {
        EjbMethodRole[] roles;
        if (queryParameters == null) {
            EjbSuperMethodSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            EjbSuperMethodSearcher.$$$reportNull$$$0(1);
        }
        if (queryParameters.isJlsOnly()) {
            return true;
        }
        PsiMethod derivedMethod = queryParameters.getMethod();
        if (DumbService.getInstance((Project)((Project)ReadAction.compute(() -> derivedMethod.getProject()))).isDumb()) {
            return true;
        }
        PsiClass containingClass = (PsiClass)ReadAction.compute(() -> derivedMethod.getContainingClass());
        if (!EjbUtil.isTopLevelClass(containingClass, EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS, OldEjbRolesUtil.getEjbRoles(containingClass))) {
            return true;
        }
        for (EjbMethodRole role : roles = OldEjbRolesUtil.getEjbRoles(derivedMethod)) {
            PsiMethod[] psiMethods;
            if (!(role instanceof EjbImplMethodRole)) continue;
            for (PsiMethod psiMethod : psiMethods = ((EjbImplMethodRole)role).findAllDeclarations()) {
                if (psiMethod.equals(derivedMethod) || consumer.process((Object)MethodSignatureBackedByPsiMethod.create((PsiMethod)psiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY))) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/javaee/ejb/utils/EjbSuperMethodSearcher";
        objectArray[2] = "execute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

