/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.utils;

import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.common.CommonModelManager;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.ejb.CmrFieldUpdater;
import com.intellij.javaee.ejb.model.EntityBean;
import com.intellij.javaee.ejb.model.xml.CmrField;
import com.intellij.javaee.ejb.model.xml.EjbRelation;
import com.intellij.javaee.ejb.model.xml.EjbRelationshipRole;
import com.intellij.javaee.ejb.utils.EjbUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class EjbRelationUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.ejb.utils.EjbRelationUtil");

    @Nullable
    public static EntityBean findEntityBeanByName(EjbRelationshipRole role) {
        return (EntityBean)role.getRelationshipRoleSource().getEntityBean().getValue();
    }

    private static Collection<PsiMethod> getAccessors(EjbRelationshipRole role, boolean isGetter) {
        PsiType type;
        CmrField cmrField;
        String name;
        EntityBean sourceEjb = EjbRelationUtil.findEntityBeanByName(role);
        if (sourceEjb != null && !StringUtil.isEmpty((String)(name = (String)(cmrField = role.getCmrField()).getCmrFieldName().getValue())) && (type = EjbUtil.findType((com.intellij.javaee.ejb.model.CmrField)cmrField)) != null) {
            return EjbRelationUtil.getAccessors(sourceEjb, name, type, isGetter);
        }
        return Collections.emptySet();
    }

    private static void updateRelationshipRole(EjbRelationshipRole role, EjbRelationshipRole dataHolder, boolean getter, boolean setter) {
        com.intellij.javaee.ejb.model.xml.EntityBean sourceEjb;
        Collection<PsiMethod> getterMethods = EjbRelationUtil.getAccessors(role, true);
        Collection<PsiMethod> setterMethods = EjbRelationUtil.getAccessors(role, false);
        CmrField oldField = role.getCmrField();
        CmrField newField = dataHolder.getCmrField();
        String newFieldName = (String)newField.getCmrFieldName().getValue();
        if (StringUtil.isEmpty((String)newFieldName)) {
            EjbRelationUtil.deleteAll(getterMethods);
            EjbRelationUtil.deleteAll(setterMethods);
            return;
        }
        if (!StringUtil.isEmpty((String)newFieldName)) {
            EjbRelationUtil.renameAccessors(getterMethods, setterMethods, newFieldName);
        }
        PsiType oldType = EjbUtil.findType((com.intellij.javaee.ejb.model.CmrField)oldField);
        PsiType newType = EjbUtil.findType((com.intellij.javaee.ejb.model.CmrField)newField);
        EntityBean oldEjb = EjbRelationUtil.findEntityBeanByName(role);
        if (oldEjb != null) {
            EntityBean ejb;
            PsiClass oldLocal = (PsiClass)oldEjb.getLocal().getValue();
            PsiClass oldEjbClass = (PsiClass)oldEjb.getEjbClass().getValue();
            if (!Comparing.equal((Object)oldType, (Object)newType)) {
                EjbRelationUtil.changeParameter(setterMethods, oldLocal, newType);
                EjbRelationUtil.changeReturnType(getterMethods, oldLocal, newType);
                EjbRelationUtil.changeParameter(setterMethods, oldEjbClass, newType);
                EjbRelationUtil.changeReturnType(getterMethods, oldEjbClass, newType);
            }
            if ((ejb = EjbRelationUtil.findEntityBeanByName(dataHolder)) != null && ejb != oldEjb) {
                PsiClass newEjbClass = (PsiClass)ejb.getEjbClass().getValue();
                PsiClass newLocal = (PsiClass)ejb.getLocal().getValue();
                EjbRelationUtil.moveMethod(getterMethods, oldEjbClass, newEjbClass);
                EjbRelationUtil.moveMethod(getterMethods, oldLocal, newLocal);
                EjbRelationUtil.moveMethod(setterMethods, oldLocal, newLocal);
                EjbRelationUtil.moveMethod(setterMethods, oldEjbClass, newEjbClass);
            }
        }
        if ((sourceEjb = (com.intellij.javaee.ejb.model.xml.EntityBean)CommonModelManager.getInstance().getDomElement((CommonModelElement)EjbUtil.getEntityBean((com.intellij.javaee.ejb.model.CmrField)newField))) == null) {
            return;
        }
        try {
            CmrFieldUpdater updater = new CmrFieldUpdater(newField);
            updater.updateGetter((PsiClass)sourceEjb.getEjbClass().getValue(), false, getter);
            updater.updateGetter((PsiClass)sourceEjb.getLocal().getValue(), false, getter);
            updater.updateSetter((PsiClass)sourceEjb.getEjbClass().getValue(), false, setter);
            updater.updateSetter((PsiClass)sourceEjb.getLocal().getValue(), false, setter);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public static void updateRelation(EjbRelation relation, EjbRelation dataHolder, boolean getter1, boolean setter1, boolean getter2, boolean setter2) {
        EjbRelationUtil.updateRelationshipRole(relation.getEjbRelationshipRole1(), dataHolder.getEjbRelationshipRole1(), getter1, setter1);
        EjbRelationUtil.updateRelationshipRole(relation.getEjbRelationshipRole2(), dataHolder.getEjbRelationshipRole2(), getter2, setter2);
        relation.copyFrom((DomElement)dataHolder);
    }

    private static void deleteAll(Collection<? extends PsiMethod> methodsMap) {
        for (PsiMethod psiMethod : methodsMap) {
            try {
                psiMethod.delete();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        methodsMap.clear();
    }

    private static void moveMethod(Collection<? extends PsiMethod> getters, PsiClass oldClass, PsiClass newClass) {
        EjbRelationUtil.changeMethod(oldClass, getters, (Consumer<? super PsiMethod>)((Consumer)method -> {
            try {
                if (newClass != null) {
                    newClass.add((PsiElement)method);
                }
                method.delete();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }));
    }

    private static void changeParameter(Collection<? extends PsiMethod> setters, PsiClass oldClass, PsiType newType) {
        if (newType != null) {
            EjbRelationUtil.changeMethod(oldClass, setters, (Consumer<? super PsiMethod>)((Consumer)method -> {
                PsiParameter[] parameters = method.getParameterList().getParameters();
                if (parameters.length == 1) {
                    PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory();
                    try {
                        PsiElement replaced = Objects.requireNonNull(parameters[0].getTypeElement()).replace((PsiElement)elementFactory.createTypeElement(newType));
                        JavaCodeStyleManager.getInstance((Project)method.getProject()).shortenClassReferences(replaced);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }));
        }
    }

    private static void changeMethod(PsiClass containingClass, Collection<? extends PsiMethod> setters, Consumer<? super PsiMethod> consumer) {
        if (containingClass != null) {
            for (PsiMethod psiMethod : setters) {
                if (!containingClass.equals(psiMethod.getContainingClass())) continue;
                consumer.consume((Object)psiMethod);
                return;
            }
        }
    }

    private static void changeReturnType(Collection<? extends PsiMethod> getters, PsiClass oldClass, PsiType newType) {
        if (newType != null) {
            EjbRelationUtil.changeMethod(oldClass, getters, (Consumer<? super PsiMethod>)((Consumer)method -> {
                PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory();
                try {
                    PsiElement replaced = Objects.requireNonNull(method.getReturnTypeElement()).replace((PsiElement)elementFactory.createTypeElement(newType));
                    JavaCodeStyleManager.getInstance((Project)method.getProject()).shortenClassReferences(replaced);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }));
        }
    }

    private static void renameAccessors(Collection<? extends PsiMethod> getters, Collection<? extends PsiMethod> setters, String newValue) {
        try {
            for (PsiMethod psiMethod : getters) {
                psiMethod.setName(JavaeeUtil.suggestGetterName((String)newValue));
            }
            for (PsiMethod psiMethod : setters) {
                psiMethod.setName(JavaeeUtil.suggestSetterName((String)newValue));
            }
        }
        catch (IncorrectOperationException ex) {
            LOG.error((Throwable)ex);
        }
    }

    public static Collection<PsiMethod> getSetters(com.intellij.javaee.ejb.model.CmrField field) {
        return EjbRelationUtil.getAccessors(EjbUtil.getEntityBean(field), (String)field.getCmrFieldName().getValue(), EjbUtil.findType(field), false);
    }

    public static Collection<PsiMethod> getGetters(com.intellij.javaee.ejb.model.CmrField field) {
        return EjbRelationUtil.getAccessors(EjbUtil.getEntityBean(field), (String)field.getCmrFieldName().getValue(), EjbUtil.findType(field), true);
    }

    private static Collection<PsiMethod> getAccessors(EntityBean sourceEjb, String name, PsiType type, boolean isGetter) {
        if (name == null || sourceEjb == null) {
            return Collections.emptySet();
        }
        HashSet<PsiMethod> result = new HashSet<PsiMethod>();
        PsiMethod method = EjbRelationUtil.findAccessor((PsiClass)sourceEjb.getEjbClass().getValue(), isGetter, name, type);
        if (method != null) {
            result.add(method);
        }
        if ((method = EjbRelationUtil.findAccessor((PsiClass)sourceEjb.getLocal().getValue(), isGetter, name, type)) != null) {
            result.add(method);
        }
        return result;
    }

    private static PsiMethod findAccessor(PsiClass ejbClass, boolean isGetter, String name, PsiType type) {
        return isGetter ? EjbUtil.findGetter(ejbClass, name, type, false) : EjbUtil.findSetter(ejbClass, name, type, false);
    }
}

