/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.role;

import com.intellij.javaee.ejb.model.EjbCommonModelUtil;
import com.intellij.javaee.ejb.model.EjbWithHome;
import com.intellij.javaee.ejb.model.EnterpriseBean;
import com.intellij.javaee.ejb.model.EntityBean;
import com.intellij.javaee.ejb.model.MessageDrivenBean;
import com.intellij.javaee.ejb.model.common.enums.PersistenceType;
import com.intellij.javaee.ejb.resources.EjbBundle;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbImplMethodRole;
import com.intellij.javaee.ejb.role.EjbMethodRoleEnum;
import com.intellij.javaee.ejb.role.EjbMethodRoleImpl;
import com.intellij.javaee.ejb.utils.EjbUtil;
import com.intellij.javaee.model.JavaeeModelElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.GenericValue;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public class EjbImplMethodRoleImpl
extends EjbMethodRoleImpl
implements EjbImplMethodRole {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.j2ee.ejb.role.EjbImplMethodRole");
    private MethodSignature[] myDeclarations;
    @NonNls
    protected static final String EJB_PREFIX = "ejb";
    @NonNls
    protected static final String EJB_HOME_PREFIX = "ejbHome";
    @NonNls
    protected static final String FIND_PREFIX = "find";
    @NonNls
    protected static final String EJB_CREATE_PREFIX = "ejbCreate";
    @NonNls
    protected static final String EJB_POSTCREATE_PREFIX = "ejbPostCreate";

    public EjbImplMethodRoleImpl(PsiMethod method, EjbClassRole bean, EjbMethodRoleEnum type) {
        super(method, bean, type);
    }

    public PsiMethod[] findDeclarationsInEjb() {
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        EnterpriseBean ejb = this.getEnterpriseBean();
        if (!(this.getEnterpriseBean() instanceof EjbWithHome)) {
            return PsiMethod.EMPTY_ARRAY;
        }
        EjbWithHome elementWithHome = (EjbWithHome)ejb;
        MethodSignature[] suggestedDeclarations = this.suggestDeclarationPrototypes();
        if (suggestedDeclarations.length == 2) {
            switch (this.getType()) {
                case EJB_METHOD_ROLE_BUSINESS_METHOD_IMPL: 
                case EJB_METHOD_ROLE_CMP_SETTER_IMPL: 
                case EJB_METHOD_ROLE_CMP_GETTER_IMPL: 
                case EJB_METHOD_ROLE_CMR_SETTER_IMPL: 
                case EJB_METHOD_ROLE_CMR_GETTER_IMPL: {
                    for (PsiClass psiClass : EjbUtil.getComponentInterfaces(ejb, false)) {
                        EjbImplMethodRoleImpl.findDeclarationIn(psiClass, suggestedDeclarations[0], result);
                    }
                    for (PsiClass psiClass : EjbUtil.getComponentInterfaces(ejb, true)) {
                        EjbImplMethodRoleImpl.findDeclarationIn(psiClass, suggestedDeclarations[1], result);
                    }
                    break;
                }
                case EJB_METHOD_ROLE_CREATE_IMPL: 
                case EJB_METHOD_ROLE_POST_CREATE_IMPL: {
                    EjbImplMethodRoleImpl.findDeclarationIn((PsiClass)elementWithHome.getLocalHome().getValue(), suggestedDeclarations[0], result);
                    EjbImplMethodRoleImpl.findDeclarationIn((PsiClass)elementWithHome.getHome().getValue(), suggestedDeclarations[1], result);
                    break;
                }
                case EJB_METHOD_ROLE_FINDER_IMPL: 
                case EJB_METHOD_ROLE_HOME_BUSINESS_METHOD_IMPL: {
                    EjbImplMethodRoleImpl.findDeclarationIn((PsiClass)elementWithHome.getLocalHome().getValue(), suggestedDeclarations[0], result);
                    EjbImplMethodRoleImpl.findDeclarationIn((PsiClass)elementWithHome.getHome().getValue(), suggestedDeclarations[1], result);
                }
            }
        }
        return result.toArray(PsiMethod.EMPTY_ARRAY);
    }

    public PsiMethod[] findAllDeclarations() {
        return EjbUtil.findEjbDeclarations(this.getMethod());
    }

    public PsiMethod[] suggestDeclarations() {
        PsiMethod[] declarations = null;
        if (this.getMethod().getBody() != null || ";".equals(this.getMethod().getLastChild().getText())) {
            try {
                switch (this.getType()) {
                    case EJB_METHOD_ROLE_BUSINESS_METHOD_IMPL: 
                    case EJB_METHOD_ROLE_CMP_SETTER_IMPL: 
                    case EJB_METHOD_ROLE_CMP_GETTER_IMPL: 
                    case EJB_METHOD_ROLE_CMR_SETTER_IMPL: 
                    case EJB_METHOD_ROLE_CMR_GETTER_IMPL: {
                        declarations = this.suggestBusinessDeclarations();
                        break;
                    }
                    case EJB_METHOD_ROLE_CREATE_IMPL: 
                    case EJB_METHOD_ROLE_POST_CREATE_IMPL: {
                        declarations = this.suggestCreateDeclarations();
                        break;
                    }
                    case EJB_METHOD_ROLE_FINDER_IMPL: 
                    case EJB_METHOD_ROLE_HOME_BUSINESS_METHOD_IMPL: {
                        declarations = this.suggestHomeDeclarations();
                    }
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        return declarations;
    }

    private MethodSignature[] suggestDeclarationPrototypes() {
        if (this.myDeclarations == null) {
            PsiElement lastChild;
            if (this.getMethod().getBody() != null || (lastChild = this.getMethod().getLastChild()) != null && ";".equals(lastChild.getText())) {
                switch (this.getType()) {
                    case EJB_METHOD_ROLE_BUSINESS_METHOD_IMPL: 
                    case EJB_METHOD_ROLE_CMP_SETTER_IMPL: 
                    case EJB_METHOD_ROLE_CMP_GETTER_IMPL: 
                    case EJB_METHOD_ROLE_CMR_SETTER_IMPL: 
                    case EJB_METHOD_ROLE_CMR_GETTER_IMPL: {
                        this.myDeclarations = this.suggestBusinessDeclarationPrototypes();
                        break;
                    }
                    case EJB_METHOD_ROLE_CREATE_IMPL: 
                    case EJB_METHOD_ROLE_POST_CREATE_IMPL: {
                        this.myDeclarations = this.suggestCreateDeclarationPrototypes();
                        break;
                    }
                    case EJB_METHOD_ROLE_FINDER_IMPL: 
                    case EJB_METHOD_ROLE_HOME_BUSINESS_METHOD_IMPL: {
                        this.myDeclarations = this.suggestHomeDeclarationPrototypes();
                    }
                }
            }
            if (this.myDeclarations == null) {
                this.myDeclarations = MethodSignature.EMPTY_ARRAY;
            }
        }
        return this.myDeclarations;
    }

    private PsiMethod[] suggestHomeDeclarations() throws IncorrectOperationException {
        String methodName = this.getMethod().getName();
        LOG.assertTrue(methodName.startsWith(EJB_PREFIX), (Object)methodName);
        LOG.assertTrue(Character.isUpperCase(methodName.charAt(3)), (Object)methodName);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.getMethod().getProject()).getElementFactory();
        if (methodName.startsWith(EJB_HOME_PREFIX)) {
            String newName = StringUtil.decapitalize((String)methodName.substring(EJB_HOME_PREFIX.length()));
            if (StringUtil.isEmpty((String)newName)) {
                return null;
            }
            PsiMethod localCreateMethod = (PsiMethod)this.getMethod().copy();
            localCreateMethod.getNameIdentifier().replace((PsiElement)JavaPsiFacade.getInstance((Project)this.getMethod().getProject()).getElementFactory().createIdentifier(newName));
            PsiUtil.removeException((PsiMethod)localCreateMethod, (String)"java.rmi.RemoteException");
            PsiMethod remoteCreateMethod = (PsiMethod)localCreateMethod.copy();
            PsiUtil.addException((PsiMethod)remoteCreateMethod, (String)"java.rmi.RemoteException");
            return new PsiMethod[]{localCreateMethod, remoteCreateMethod};
        }
        String newName = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(EJB_PREFIX.length() + 1);
        PsiMethod localCreateMethod = (PsiMethod)this.getMethod().copy();
        localCreateMethod.getNameIdentifier().replace((PsiElement)JavaPsiFacade.getInstance((Project)this.getMethod().getProject()).getElementFactory().createIdentifier(newName));
        if (newName.startsWith(FIND_PREFIX)) {
            PsiUtil.addException((PsiMethod)localCreateMethod, (String)"javax.ejb.FinderException");
        }
        PsiUtil.removeException((PsiMethod)localCreateMethod, (String)"java.rmi.RemoteException");
        PsiMethod remoteCreateMethod = (PsiMethod)localCreateMethod.copy();
        PsiUtil.addException((PsiMethod)remoteCreateMethod, (String)"java.rmi.RemoteException");
        EntityBean entityBean = (EntityBean)this.getEnterpriseBean();
        PsiClass pkClass = (PsiClass)entityBean.getPrimKeyClass().getValue();
        PsiType returnType = localCreateMethod.getReturnType();
        if (pkClass != null && returnType != null && returnType.equalsToText(pkClass.getQualifiedName())) {
            PsiClass remoteInterface;
            PsiClassType remoteInterfaceType;
            PsiClassType localInterfaceType;
            PsiClass localInterface = (PsiClass)entityBean.getLocal().getValue();
            PsiClassType psiClassType = localInterfaceType = localInterface == null ? null : factory.createType(localInterface);
            if (localInterfaceType != null) {
                localCreateMethod.getReturnTypeElement().replace((PsiElement)factory.createTypeElement((PsiType)localInterfaceType));
            }
            PsiClassType psiClassType2 = remoteInterfaceType = (remoteInterface = (PsiClass)entityBean.getRemote().getValue()) == null ? null : factory.createType(remoteInterface);
            if (remoteInterfaceType != null) {
                remoteCreateMethod.getReturnTypeElement().replace((PsiElement)factory.createTypeElement((PsiType)remoteInterfaceType));
            }
        }
        return new PsiMethod[]{localCreateMethod, remoteCreateMethod};
    }

    private MethodSignature[] suggestHomeDeclarationPrototypes() {
        String newName;
        String methodName = this.getMethod().getName();
        LOG.assertTrue(methodName.startsWith(EJB_PREFIX), (Object)methodName);
        LOG.assertTrue(Character.isUpperCase(methodName.charAt(3)), (Object)methodName);
        if (methodName.startsWith(EJB_HOME_PREFIX)) {
            if (methodName.equals(EJB_HOME_PREFIX)) {
                return null;
            }
            newName = Character.toLowerCase(methodName.charAt(EJB_HOME_PREFIX.length())) + methodName.substring(EJB_HOME_PREFIX.length() + 1);
        } else {
            newName = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(EJB_PREFIX.length() + 1);
        }
        MethodSignature declaration = MethodSignatureUtil.createMethodSignature((String)newName, (PsiParameterList)this.getMethod().getParameterList(), null, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        return new MethodSignature[]{declaration, declaration};
    }

    private static void findDeclarationIn(PsiClass remoteClass, MethodSignature method, List<PsiMethod> result) {
        PsiMethod m;
        if (remoteClass != null && method != null && (m = MethodSignatureUtil.findMethodBySignature((PsiClass)remoteClass, (MethodSignature)method, (boolean)true)) != null) {
            result.add(m);
        }
    }

    private PsiMethod[] suggestBusinessDeclarations() throws IncorrectOperationException {
        PsiMethod localCreateMethod = (PsiMethod)this.getMethod().copy();
        PsiUtil.removeException((PsiMethod)localCreateMethod, (String)"java.rmi.RemoteException");
        PsiMethod remoteCreateMethod = (PsiMethod)localCreateMethod.copy();
        PsiUtil.addException((PsiMethod)remoteCreateMethod, (String)"java.rmi.RemoteException");
        return new PsiMethod[]{localCreateMethod, remoteCreateMethod};
    }

    private MethodSignature[] suggestBusinessDeclarationPrototypes() {
        MethodSignature declaration = MethodSignatureUtil.createMethodSignature((String)this.getMethod().getName(), (PsiParameterList)this.getMethod().getParameterList(), null, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        return new MethodSignature[]{declaration, declaration};
    }

    private PsiMethod[] suggestCreateDeclarations() throws IncorrectOperationException {
        PsiMethod method = this.getMethod();
        String methodName = method.getName();
        LOG.assertTrue(methodName.startsWith(EJB_CREATE_PREFIX) || methodName.startsWith(EJB_POSTCREATE_PREFIX));
        @NonNls String newName = "create" + methodName.substring((methodName.startsWith(EJB_CREATE_PREFIX) ? EJB_CREATE_PREFIX : EJB_POSTCREATE_PREFIX).length());
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory();
        return new PsiMethod[]{this.createNewLocalCreateMethod(factory, newName, method), this.createNewRemoteCreateMethod(this.createNewLocalCreateMethod(factory, newName, method), factory)};
    }

    private PsiMethod createNewRemoteCreateMethod(PsiMethod localCreateMethod, PsiElementFactory factory) throws IncorrectOperationException {
        PsiMethod remoteCreateMethod = (PsiMethod)localCreateMethod.copy();
        PsiType remoteInterfaceType = this.getRemoteInterfaceType(factory);
        if (remoteInterfaceType != null) {
            remoteCreateMethod.getReturnTypeElement().replace((PsiElement)factory.createTypeElement(remoteInterfaceType));
        }
        PsiUtil.addException((PsiMethod)remoteCreateMethod, (String)"java.rmi.RemoteException");
        return remoteCreateMethod;
    }

    private PsiType getRemoteInterfaceType(PsiElementFactory factory) {
        if (this.getEnterpriseBean() instanceof EjbWithHome) {
            PsiClass remoteInterface = (PsiClass)((EjbWithHome)this.getEnterpriseBean()).getRemote().getValue();
            return remoteInterface == null ? null : factory.createType(remoteInterface);
        }
        return null;
    }

    private PsiMethod createNewLocalCreateMethod(PsiElementFactory factory, String newName, PsiMethod method) throws IncorrectOperationException {
        PsiType localInterfaceType = this.getLocalInterfaceType(factory);
        PsiMethod localCreateMethod = factory.createMethod(newName, localInterfaceType);
        localCreateMethod.getParameterList().replace((PsiElement)method.getParameterList());
        PsiUtil.setModifierProperty((PsiModifierListOwner)localCreateMethod, (String)"public", (boolean)true);
        if (localCreateMethod.getBody() != null) {
            localCreateMethod.getBody().delete();
        }
        PsiUtil.addException((PsiMethod)localCreateMethod, (String)"javax.ejb.CreateException");
        PsiUtil.removeException((PsiMethod)localCreateMethod, (String)"java.rmi.RemoteException");
        return localCreateMethod;
    }

    private PsiType getLocalInterfaceType(PsiElementFactory factory) {
        if (this.getEnterpriseBean() instanceof EjbWithHome) {
            PsiClass localInterface = (PsiClass)((EjbWithHome)this.getEnterpriseBean()).getLocal().getValue();
            return localInterface == null ? PsiType.VOID : factory.createType(localInterface);
        }
        return PsiType.VOID;
    }

    private MethodSignature[] suggestCreateDeclarationPrototypes() {
        PsiMethod method = this.getMethod();
        String methodName = method.getName();
        LOG.assertTrue(methodName.startsWith(EJB_CREATE_PREFIX) || methodName.startsWith(EJB_POSTCREATE_PREFIX));
        @NonNls String newName = "create" + methodName.substring((methodName.startsWith(EJB_CREATE_PREFIX) ? EJB_CREATE_PREFIX : EJB_POSTCREATE_PREFIX).length());
        return new MethodSignature[]{MethodSignatureUtil.createMethodSignature((String)newName, (PsiParameterList)this.getMethod().getParameterList(), null, (PsiSubstitutor)PsiSubstitutor.EMPTY), MethodSignatureUtil.createMethodSignature((String)newName, (PsiParameterList)this.getMethod().getParameterList(), null, (PsiSubstitutor)PsiSubstitutor.EMPTY)};
    }

    @Override
    public String getTitle() {
        String desc;
        switch (this.getType()) {
            case EJB_METHOD_ROLE_HOME_BUSINESS_METHOD_IMPL: {
                desc = EjbBundle.message((String)"method.role.home.business.method.implementation", (Object[])new Object[0]);
                break;
            }
            case EJB_METHOD_ROLE_FINDER_IMPL: {
                desc = EjbBundle.message((String)"method.role.finder.method.implementation", (Object[])new Object[0]);
                break;
            }
            case EJB_METHOD_ROLE_SELECTOR_IMPL: {
                desc = EjbBundle.message((String)"method.role.selector.method.implementation", (Object[])new Object[0]);
                break;
            }
            case EJB_METHOD_ROLE_CREATE_IMPL: {
                desc = EjbBundle.message((String)"method.role.create.method.implementation", (Object[])new Object[0]);
                break;
            }
            case EJB_METHOD_ROLE_POST_CREATE_IMPL: {
                desc = EjbBundle.message((String)"method.role.post.create.method.implementation", (Object[])new Object[0]);
                break;
            }
            case EJB_METHOD_ROLE_BUSINESS_METHOD_IMPL: {
                desc = EjbBundle.message((String)"method.role.business.method.implementation", (Object[])new Object[0]);
                break;
            }
            case EJB_METHOD_ROLE_CMP_GETTER_IMPL: {
                desc = EjbBundle.message((String)"method.role.cmp.field.getter.implementation", (Object[])new Object[0]);
                break;
            }
            case EJB_METHOD_ROLE_CMP_SETTER_IMPL: {
                desc = EjbBundle.message((String)"method.role.cmp.field.setter.implementation", (Object[])new Object[0]);
                break;
            }
            case EJB_METHOD_ROLE_CMR_GETTER_IMPL: {
                desc = EjbBundle.message((String)"method.role.cmr.field.getter.implementation", (Object[])new Object[0]);
                break;
            }
            case EJB_METHOD_ROLE_CMR_SETTER_IMPL: {
                desc = EjbBundle.message((String)"method.role.cmr.field.setter.implementation", (Object[])new Object[0]);
                break;
            }
            default: {
                desc = EjbBundle.message((String)"method.role.method.implementation", (Object[])new Object[0]);
            }
        }
        return desc;
    }

    private boolean isImplementationRequired() {
        EnterpriseBean ejb = this.getEnterpriseBean();
        switch (this.getType()) {
            case EJB_METHOD_ROLE_SELECTOR_IMPL: {
                return true;
            }
            case EJB_METHOD_ROLE_FINDER_IMPL: {
                return ((EntityBean)ejb).getPersistenceType().getValue() == PersistenceType.BEAN;
            }
            case EJB_METHOD_ROLE_CREATE_IMPL: 
            case EJB_METHOD_ROLE_POST_CREATE_IMPL: {
                return !(ejb instanceof MessageDrivenBean);
            }
            case EJB_METHOD_ROLE_CMP_SETTER_IMPL: 
            case EJB_METHOD_ROLE_CMP_GETTER_IMPL: 
            case EJB_METHOD_ROLE_CMR_SETTER_IMPL: 
            case EJB_METHOD_ROLE_CMR_GETTER_IMPL: {
                return !EjbUtil.isEjbVersion1x((JavaeeModelElement)ejb);
            }
            case EJB_METHOD_ROLE_BUSINESS_METHOD_IMPL: 
            case EJB_METHOD_ROLE_HOME_BUSINESS_METHOD_IMPL: {
                return true;
            }
        }
        return false;
    }

    public int numberOfDeclarationsRequired() {
        if (!(this.getEnterpriseBean() instanceof EjbWithHome)) {
            return 0;
        }
        EjbWithHome elementWithHome = (EjbWithHome)this.getEnterpriseBean();
        switch (this.getType()) {
            case EJB_METHOD_ROLE_CREATE_IMPL: 
            case EJB_METHOD_ROLE_POST_CREATE_IMPL: 
            case EJB_METHOD_ROLE_FINDER_IMPL: 
            case EJB_METHOD_ROLE_HOME_BUSINESS_METHOD_IMPL: {
                return EjbImplMethodRoleImpl.exists2Int((GenericValue<PsiClass>)elementWithHome.getLocalHome()) + EjbImplMethodRoleImpl.exists2Int((GenericValue<PsiClass>)elementWithHome.getHome());
            }
            case EJB_METHOD_ROLE_BUSINESS_METHOD_IMPL: {
                return EjbCommonModelUtil.getEjbClasses((EnterpriseBean)elementWithHome, (boolean)false, (boolean)false, (boolean)true).size();
            }
            case EJB_METHOD_ROLE_CMP_SETTER_IMPL: 
            case EJB_METHOD_ROLE_CMP_GETTER_IMPL: 
            case EJB_METHOD_ROLE_CMR_SETTER_IMPL: 
            case EJB_METHOD_ROLE_CMR_GETTER_IMPL: {
                return 0;
            }
        }
        return 0;
    }

    private static int exists2Int(GenericValue<PsiClass> genericValue) {
        return genericValue.getValue() != null ? 1 : 0;
    }

    @Override
    protected boolean checkPairingMethods() {
        if (!super.checkPairingMethods()) {
            return false;
        }
        if (!this.isImplementationRequired()) {
            return false;
        }
        int n = this.numberOfDeclarationsRequired();
        if (n != 0) {
            int current = this.findDeclarationsInEjb().length;
            return current > 0 && current <= n;
        }
        return true;
    }
}

