/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.providers;

import com.intellij.codeInsight.daemon.GutterName;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.javaee.ejb.model.EjbAnnotationConstants;
import com.intellij.javaee.ejb.providers.EjbConfigLineMarkerProvider;
import com.intellij.javaee.ejb.resources.EjbBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiModifierList;
import icons.JavaUltimateIcons;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

final class EjbAnnotationsLineMarkerProvider
extends LineMarkerProviderDescriptor {
    EjbAnnotationsLineMarkerProvider() {
    }

    @GutterName
    @NotNull
    public String getName() {
        String string = EjbBundle.message((String)"ejb.annotations.gutter.name", (Object[])new Object[0]);
        if (string == null) {
            EjbAnnotationsLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = JavaUltimateIcons.Javaee.EjbModule;
        if (icon == null) {
            EjbAnnotationsLineMarkerProvider.$$$reportNull$$$0(1);
        }
        return icon;
    }

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            EjbAnnotationsLineMarkerProvider.$$$reportNull$$$0(2);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        if (elements == null) {
            EjbAnnotationsLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (result == null) {
            EjbAnnotationsLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if (elements.isEmpty()) {
            return;
        }
        Project project = elements.get(0).getProject();
        if (EjbConfigLineMarkerProvider.getToolWindow(project) == null) {
            return;
        }
        for (PsiElement psiElement : elements) {
            Module module;
            PsiElement parent;
            PsiElement grandParent;
            if (!(psiElement instanceof PsiIdentifier) || !((grandParent = (parent = psiElement.getParent()) != null ? parent.getParent() : null) instanceof PsiAnnotation) || (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement)) != null && !EjbConfigLineMarkerProvider.isEjbFacetAvailable(module)) continue;
            EjbAnnotationsLineMarkerProvider.annotatePsiAnnotation(project, result, (PsiAnnotation)grandParent, psiElement);
        }
    }

    private static void annotatePsiAnnotation(@NotNull Project project, Collection<? super LineMarkerInfo<?>> result, @NotNull PsiAnnotation annotation, @NotNull PsiElement identifier) {
        if (project == null) {
            EjbAnnotationsLineMarkerProvider.$$$reportNull$$$0(5);
        }
        if (annotation == null) {
            EjbAnnotationsLineMarkerProvider.$$$reportNull$$$0(6);
        }
        if (identifier == null) {
            EjbAnnotationsLineMarkerProvider.$$$reportNull$$$0(7);
        }
        if (!(annotation.getOwner() instanceof PsiModifierList)) {
            return;
        }
        PsiModifierList modifierList = (PsiModifierList)annotation.getOwner();
        if (!(modifierList.getParent() instanceof PsiClass)) {
            return;
        }
        PsiClass owner = (PsiClass)modifierList.getParent();
        if (owner.isAnnotationType() || owner.isEnum() || owner.isRecord() || owner.isInterface()) {
            return;
        }
        if (EjbAnnotationsLineMarkerProvider.isEjbAnnotation(annotation.getQualifiedName())) {
            result.add(EjbConfigLineMarkerProvider.createLineMarker(identifier, project));
        }
    }

    private static boolean isEjbAnnotation(String qualifiedName) {
        return EjbAnnotationConstants.MANAGED_BEAN_ANNO.isFqn(qualifiedName) || EjbAnnotationConstants.STATEFUL_ANNO.isFqn(qualifiedName) || EjbAnnotationConstants.STATELESS_ANNO.isFqn(qualifiedName) || EjbAnnotationConstants.SINGLETON_ANNO.isFqn(qualifiedName) || EjbAnnotationConstants.MESSAGE_DRIVEN_ANNO.isFqn(qualifiedName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/providers/EjbAnnotationsLineMarkerProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/providers/EjbAnnotationsLineMarkerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "annotatePsiAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

