/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.module.view.ejb.permissions;

import com.intellij.javaee.ejb.model.EnterpriseBean;
import com.intellij.javaee.ejb.model.xml.AssemblyDescriptor;
import com.intellij.javaee.ejb.model.xml.ContainerTransaction;
import com.intellij.javaee.ejb.model.xml.ExcludeList;
import com.intellij.javaee.ejb.model.xml.Method;
import com.intellij.javaee.ejb.model.xml.MethodPermission;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.util.CommonProcessors;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class MethodContainerHelper {
    protected abstract void processMethods(Processor<? super Method> var1);

    @NotNull
    private List<Method> collectAttributes(Condition<? super Method> condition) {
        ArrayList<Method> result = new ArrayList<Method>();
        this.processMethods((Processor<? super Method>)new FilteringProcessor(condition, (Processor)new CommonProcessors.CollectProcessor(result)));
        ArrayList<Method> arrayList = result;
        if (arrayList == null) {
            MethodContainerHelper.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @NotNull
    public final List<Method> getEjbAttributes(EnterpriseBean ejb) {
        return this.collectAttributes((Condition<? super Method>)((Condition)attr -> Objects.equals(ejb.getEjbName().getValue(), attr.getEnterpriseBean().getStringValue()) && attr.getMethodIntf().getValue() == null && "*".equals(attr.getMethod().getStringValue())));
    }

    protected boolean set(boolean set, String role) {
        return set;
    }

    public static boolean containsRoleWithName(MethodPermission permission, String role) {
        List roleNames = permission.getRoleNames();
        if (roleNames.isEmpty()) {
            return role == null;
        }
        for (GenericDomValue roleName : roleNames) {
            if (!Comparing.strEqual((String)roleName.getStringValue(), (String)role)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/module/view/ejb/permissions/MethodContainerHelper", "collectAttributes"));
    }

    public static class ContainerTransactionHelper
    extends MethodContainerHelper {
        private final AssemblyDescriptor myAssemblyDescriptor;

        public ContainerTransactionHelper(AssemblyDescriptor assemblyDescriptor) {
            this.myAssemblyDescriptor = assemblyDescriptor;
        }

        @Override
        protected void processMethods(Processor<? super Method> processor) {
            for (ContainerTransaction permission : this.myAssemblyDescriptor.getContainerTransactions()) {
                for (Method method : permission.getMethods()) {
                    processor.process((Object)method);
                }
            }
        }

        @Override
        protected boolean set(boolean set, String role) {
            return set && !Comparing.strEqual((String)role, null);
        }
    }

    public static class MethodPermissionHelper
    extends MethodContainerHelper {
        private final AssemblyDescriptor myAssemblyDescriptor;

        public MethodPermissionHelper(AssemblyDescriptor assemblyDescriptor) {
            this.myAssemblyDescriptor = assemblyDescriptor;
        }

        @Override
        protected void processMethods(Processor<? super Method> processor) {
            for (MethodPermission permission : this.myAssemblyDescriptor.getMethodPermissions()) {
                for (Method method : permission.getMethods()) {
                    processor.process((Object)method);
                }
            }
        }
    }

    public static class ExcludeListHelper
    extends MethodContainerHelper {
        private final ExcludeList myExcludeList;

        public ExcludeListHelper(ExcludeList excludeList) {
            this.myExcludeList = excludeList;
        }

        @Override
        protected void processMethods(Processor<? super Method> processor) {
            for (Method method : this.myExcludeList.getMethods()) {
                processor.process((Object)method);
            }
        }
    }
}

