/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.module.view.ejb.moduleLevel;

import com.intellij.CommonBundle;
import com.intellij.javaee.ui.DialogCommittableTab;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.util.xml.ui.CommitablePanelUserActivityListener;
import com.intellij.util.xml.ui.Committable;
import com.intellij.util.xml.ui.CompositeCommittable;
import com.intellij.util.xml.ui.DomUIFactory;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public abstract class JavaeeEditDialog
extends DialogWrapper
implements Disposable {
    private final UserActivityWatcher myUserActivityWatcher = DomUIFactory.getDomUIFactory().createEditorAwareUserActivityWatcher();
    private final CommitablePanelUserActivityListener myUserActivityListener;
    private DialogCommittableTab[] myTabs;
    private TabbedPaneWrapper myTabbedPane;
    private final Project myProject;
    private final CompositeCommittable myCompositeCommittable = new CompositeCommittable();

    public JavaeeEditDialog(Project project) {
        super(project, false);
        this.myProject = project;
        Disposer.register((Disposable)this.myDisposable, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)this.myCompositeCommittable);
        this.myUserActivityListener = new CommitablePanelUserActivityListener(project){

            protected void applyChanges() {
                for (DialogCommittableTab tab : JavaeeEditDialog.this.myTabs) {
                    this.commit((Committable)tab);
                }
            }
        };
    }

    public void dispose() {
        super.dispose();
    }

    protected abstract DialogCommittableTab[] createTabs();

    @Nullable
    protected final JComponent createCenterPanel() {
        JComponent component;
        for (DialogCommittableTab tab : this.myTabs = this.createTabs()) {
            this.myCompositeCommittable.addComponent((Committable)tab);
        }
        if (this.myTabs.length == 1) {
            component = this.myTabs[0].getComponent();
        } else {
            this.myTabbedPane = new TabbedPaneWrapper(this.myDisposable);
            for (DialogCommittableTab page : this.myTabs) {
                JavaeeEditDialog.addPage(this.myTabbedPane, page.getTabName(), page.getPanel().getComponent());
            }
            this.myTabbedPane.setSelectedIndex(0);
            this.myTabbedPane.addChangeListener(new ChangeListener(){
                int index = 0;

                @Override
                public void stateChanged(ChangeEvent e) {
                    JavaeeEditDialog.this.myTabs[this.index].commit();
                    this.index = JavaeeEditDialog.this.myTabbedPane.getSelectedIndex();
                    JavaeeEditDialog.this.myTabs[this.index].reset();
                }
            });
            component = this.myTabbedPane.getComponent();
        }
        this.myUserActivityWatcher.register((Component)component);
        this.myUserActivityWatcher.addUserActivityListener((UserActivityListener)this.myUserActivityListener, (Disposable)this);
        this.myTabs[0].reset();
        return component;
    }

    private static void addPage(TabbedPaneWrapper pane, @Nls String tabName, JComponent component) {
        component.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pane.addTab(tabName, component);
    }

    protected void doOKAction() {
        for (DialogCommittableTab tab : this.myTabs) {
            if (tab.getErrorMessage() == null) continue;
            if (this.myTabbedPane != null) {
                this.myTabbedPane.setSelectedComponent(tab.getComponent());
            }
            Messages.showErrorDialog((String)tab.getErrorMessage(), (String)CommonBundle.getErrorTitle());
            return;
        }
        WriteCommandAction.writeCommandAction((Project)this.myProject).run(() -> {
            for (DialogCommittableTab tab : this.myTabs) {
                tab.closeNotify();
            }
        });
        super.doOKAction();
    }
}

