/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.module.view.ejb.ejbLevel;

import com.intellij.DynamicBundle;
import com.intellij.jam.view.tree.JamNodeDescriptor;
import com.intellij.javaee.constants.JavaeeAnnotationConstants;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.model.EjbCommonModelUtil;
import com.intellij.javaee.ejb.model.EnterpriseBean;
import com.intellij.javaee.ejb.model.InterceptorBinding;
import com.intellij.javaee.ejb.model.xml.AssemblyDescriptor;
import com.intellij.javaee.ejb.model.xml.EjbJar;
import com.intellij.javaee.ejb.model.xml.MethodParams;
import com.intellij.javaee.ejb.module.view.ejb.businessTree.EjbBusinessTreeModuleNodeDescriptor;
import com.intellij.javaee.ejb.resources.EjbBundle;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.ejb.utils.OldEjbRolesUtil;
import com.intellij.javaee.module.view.nodes.J2EEModuleParameters;
import com.intellij.javaee.ui.jam.view.treetable.JamTreeTableView;
import com.intellij.javaee.util.AnnotationTextUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairProcessor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

public class InterceptorBindingsPanel
implements Disposable {
    private JPanel myPanel;
    private JPanel myTreePanel;
    private JCheckBox myDefaultInterceptor;
    private final EjbFacet myEjbFacet;
    private final Project myProject;
    private final EjbBusinessTreeView myTreeView;
    private final HashMap<PsiMember, String> targetMembers;
    private boolean isDefaultInterceptor;
    private final String myInterceptorClass;

    public InterceptorBindingsPanel(Project project, EjbFacet ejbFacet, String interceptorClass) {
        this.$$$setupUI$$$();
        this.targetMembers = new HashMap();
        this.isDefaultInterceptor = false;
        this.myInterceptorClass = interceptorClass;
        this.myEjbFacet = ejbFacet;
        this.myProject = project;
        this.initInterceptorBindings();
        this.myTreeView = new EjbBusinessTreeView(this.myProject, ejbFacet, this.targetMembers);
        Disposer.register((Disposable)this, (Disposable)this.myTreeView);
        this.setupControls();
        this.refreshControls();
    }

    private void initInterceptorBindings() {
        this.targetMembers.clear();
        this.processInterceptorBindings((PairProcessor<InterceptorBinding, String>)((PairProcessor)(s, t) -> {
            if (s.getTargetMember() != null) {
                this.targetMembers.put(s.getTargetMember(), (String)t);
            } else if ("*".equals(s.getEjbName())) {
                this.isDefaultInterceptor = true;
            }
            return true;
        }));
    }

    private void processInterceptorBindings(PairProcessor<InterceptorBinding, String> processor) {
        PsiClass aClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(this.myInterceptorClass, GlobalSearchScope.moduleScope((Module)this.myEjbFacet.getModule()));
        for (EjbClassRole role : OldEjbRolesUtil.getEjbRoles(aClass)) {
            if (role.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_INTERCEPTOR_CLASS) continue;
            role.getInterceptor().processInterceptorBindings(binding -> {
                PsiMember member = binding.getTargetMember();
                if (binding.getEjbName() == null) {
                    if (member != null) {
                        for (EjbClassRole memberRole : OldEjbRolesUtil.getEjbRoles(member instanceof PsiClass ? (PsiClass)member : member.getContainingClass())) {
                            if (memberRole.getEnterpriseBean() == null || processor.process(binding, (Object)((String)memberRole.getEnterpriseBean().getEjbName().getValue()))) continue;
                            return false;
                        }
                    }
                } else if (!processor.process(binding, (Object)binding.getEjbName())) {
                    return false;
                }
                return true;
            });
        }
    }

    private void refreshControls() {
        this.updateOKAction();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTreeView.getTreeTableView();
    }

    public void dispose() {
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    private void setupControls() {
        this.myDefaultInterceptor.setSelected(this.isDefaultInterceptor);
        this.myDefaultInterceptor.setEnabled(this.myEjbFacet.getXmlRoot() != null);
        this.myTreePanel.setLayout(new BorderLayout());
        this.myTreePanel.add((Component)this.myTreeView.getComponent(), "Center");
        this.myPanel.doLayout();
    }

    protected void updateOKAction() {
    }

    public boolean isOKActionEnabled() {
        return true;
    }

    public boolean isDataValid() {
        return this.isOKActionEnabled();
    }

    public void applyInterceptorBindings() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        HashMap<PsiMember, String> newTargetElements = new HashMap<PsiMember, String>(this.targetMembers);
        ArrayList bindingsToRemove = new ArrayList();
        this.processInterceptorBindings((PairProcessor<InterceptorBinding, String>)((PairProcessor)(s, t) -> {
            PsiMember member = s.getTargetMember();
            if (member != null) {
                String boundEjbName = this.targetMembers.get(member);
                if (!t.equals(boundEjbName)) {
                    bindingsToRemove.add(s);
                } else {
                    newTargetElements.remove(member);
                }
            } else if ("*".equals(s.getEjbName()) && !this.myDefaultInterceptor.isSelected()) {
                bindingsToRemove.add(s);
            }
            return true;
        }));
        HashSet<Object> allPsiElements = new HashSet<Object>();
        EjbJar ejbJar = this.myEjbFacet.getXmlRoot();
        if (ejbJar != null) {
            allPsiElements.add(ejbJar.getXmlTag());
        }
        allPsiElements.addAll(this.targetMembers.keySet());
        for (InterceptorBinding binding : bindingsToRemove) {
            if (binding.getTargetMember() == null) continue;
            allPsiElements.add(binding.getTargetMember());
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)this.myProject, allPsiElements)) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)this.myProject).withName(EjbBundle.message((String)"command.apply.interceptor.bindings.command", (Object[])new Object[0])).run(() -> this.updateInterceptorBindings(bindingsToRemove, newTargetElements));
    }

    private void updateInterceptorBindings(ArrayList<InterceptorBinding> bindingsToRemove, HashMap<PsiMember, String> newTargetElements) throws IncorrectOperationException {
        for (InterceptorBinding binding : bindingsToRemove) {
            binding.delete();
        }
        if (this.myEjbFacet.getXmlRoot() != null) {
            boolean addDefault = this.myDefaultInterceptor.isSelected() && !this.isDefaultInterceptor;
            InterceptorBindingsPanel.createInterceptorXmlMetadata(this.myEjbFacet.getXmlRoot(), this.myInterceptorClass, newTargetElements, addDefault);
        }
        InterceptorBindingsPanel.createInterceptorAnnotations(this.myInterceptorClass, newTargetElements);
    }

    public static void createInterceptorXmlMetadata(EjbJar ejbJar, String interceptorClassName, Map<PsiMember, String> memberToEjbNameMap, boolean addDefault) {
        AssemblyDescriptor assemblyDescriptor = ejbJar.getAssemblyDescriptor();
        if (addDefault) {
            com.intellij.javaee.ejb.model.xml.InterceptorBinding binding = assemblyDescriptor.addInterceptorBinding();
            binding.addInterceptorClass().setStringValue(interceptorClassName);
            binding.getEnterpriseBean().setStringValue("*");
        }
        for (Map.Entry<PsiMember, String> entry : memberToEjbNameMap.entrySet()) {
            String ejbName = entry.getValue();
            PsiMember member = entry.getKey();
            com.intellij.javaee.ejb.model.xml.InterceptorBinding binding = assemblyDescriptor.addInterceptorBinding();
            binding.addInterceptorClass().setStringValue(interceptorClassName);
            binding.getEnterpriseBean().setStringValue(ejbName);
            if (!(member instanceof PsiMethod)) continue;
            PsiMethod psiMethod = (PsiMethod)member;
            binding.getMethod().getMethod().setValue((Object)psiMethod);
            MethodParams methodParams = binding.getMethod().getMethodParams();
            for (PsiParameter psiParameter : psiMethod.getParameterList().getParameters()) {
                methodParams.addMethodParam().setValue((Object)psiParameter.getType());
            }
        }
    }

    public static void createInterceptorAnnotations(String interceptorClassName, Map<PsiMember, String> memberToEjbNameMap) throws IncorrectOperationException {
        for (Map.Entry<PsiMember, String> entry : memberToEjbNameMap.entrySet()) {
            PsiMember member = entry.getKey();
            InterceptorBindingsPanel.createInterceptorAnnotation(member, interceptorClassName);
        }
    }

    public static void createInterceptorAnnotation(PsiMember member, String interceptorClassName) throws IncorrectOperationException {
        String anno = JavaeeAnnotationConstants.INTERCEPTORS_ANNO.fqn((PsiElement)member);
        PsiAnnotation curAnnotation = member.getModifierList().findAnnotation(anno);
        String text = AnnotationTextUtil.createAnnotationText((PsiElement)member, (String)anno, (boolean)true, (PsiAnnotation)curAnnotation, (String[])new String[]{"value", AnnotationTextUtil.createStringArrayInitializer(Collections.singletonList(interceptorClassName), (String[])new String[]{null, ".class"}), null});
        PsiAnnotation psiNewAnnotation = JavaPsiFacade.getInstance((Project)member.getProject()).getElementFactory().createAnnotationFromText(text, (PsiElement)member);
        PsiElement element = curAnnotation != null ? curAnnotation.replace((PsiElement)psiNewAnnotation) : member.getModifierList().addAfter((PsiElement)psiNewAnnotation, null);
        JavaCodeStyleManager.getInstance((Project)member.getProject()).shortenClassReferences(element);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTreePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/EjbBundle", InterceptorBindingsPanel.class).getString("border.interceptor.binding"), (int)0, (int)0, null, null));
        this.myDefaultInterceptor = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/EjbBundle", InterceptorBindingsPanel.class).getString("checkbox.default.interceptor"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static class EjbBusinessTreeView
    extends JamTreeTableView {
        private final EjbFacet myEjbFacet;
        private final Map<PsiMember, String> myTargetMembers;

        public EjbBusinessTreeView(Project project, EjbFacet ejbFacet, Map<PsiMember, String> targetMembers) {
            super(project, (JamNodeDescriptor)new EjbBusinessTreeModuleNodeDescriptor(ejbFacet, new J2EEModuleParameters(true), false));
            this.myEjbFacet = ejbFacet;
            this.myTargetMembers = targetMembers;
            this.getTreeTableView().setShowVerticalLines(true);
            this.getTreeTableView().setIntercellSpacing((Dimension)JBUI.size((int)1, (int)0));
            this.init();
            new TreeTableSpeedSearch((TreeTable)this.getTreeTableView());
        }

        protected boolean isShowTree() {
            return !EjbCommonModelUtil.getAllEjbs((Project)this.getProject(), null, (EjbFacet)this.myEjbFacet).isEmpty();
        }

        @NotNull
        protected String getEmptyPaneText() {
            String string = EjbBundle.message((String)"message.text.no.ejbs.in.this.module.no.interceptors", (Object[])new Object[0]);
            if (string == null) {
                EjbBusinessTreeView.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected ColumnInfo[] createColumnInfos() {
            return new ColumnInfo[]{new TreeColumnInfo(EjbBundle.message((String)"column.name.ejb.business.tree.name", (Object[])new Object[0])), new ColumnInfo<JamNodeDescriptor, Boolean>(EjbBundle.message((String)"column.name.ejb.business.tree.intercept", (Object[])new Object[0])){

                public boolean isCellEditable(JamNodeDescriptor o) {
                    Object element = o.getJamElement();
                    return element instanceof PsiElement;
                }

                public TableCellEditor getEditor(JamNodeDescriptor o) {
                    Object element = o.getJamElement();
                    return element instanceof PsiElement ? new BooleanTableCellEditor() : null;
                }

                public TableCellRenderer getRenderer(JamNodeDescriptor o) {
                    Object element = o.getJamElement();
                    return element instanceof PsiElement ? new BooleanTableCellRenderer() : null;
                }

                public void setValue(JamNodeDescriptor o, Boolean aValue) {
                    String ejbName = this.getEjbNameForNodeDescriptor(o);
                    Object element = o.getJamElement();
                    assert (element instanceof PsiMember);
                    PsiMember member = (PsiMember)element;
                    if (Boolean.TRUE.equals(aValue)) {
                        myTargetMembers.put(member, ejbName);
                    } else {
                        myTargetMembers.remove(member);
                    }
                }

                public Boolean valueOf(JamNodeDescriptor o) {
                    Object element = o.getJamElement();
                    if (element instanceof EnterpriseBean) {
                        return null;
                    }
                    assert (element instanceof PsiMember);
                    PsiMember member = (PsiMember)element;
                    return myTargetMembers.containsKey(member);
                }

                private String getEjbNameForNodeDescriptor(JamNodeDescriptor node) {
                    for (JamNodeDescriptor curNode = node; curNode != null; curNode = (JamNodeDescriptor)curNode.getParentDescriptor()) {
                        Object element = curNode.getJamElement();
                        if (!(element instanceof EnterpriseBean)) continue;
                        EnterpriseBean ejb = (EnterpriseBean)element;
                        return (String)ejb.getEjbName().getValue();
                    }
                    assert (false);
                    return null;
                }
            }};
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/module/view/ejb/ejbLevel/InterceptorBindingsPanel$EjbBusinessTreeView", "getEmptyPaneText"));
        }
    }
}

