/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.module.view.ejb.ejbLevel;

import com.intellij.javaee.ejb.EjbModuleUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.model.EjbDescriptorVersion;
import com.intellij.javaee.ejb.model.common.enums.CmpVersion;
import com.intellij.javaee.ejb.model.common.enums.PersistenceType;
import com.intellij.javaee.ejb.model.common.enums.SessionType;
import com.intellij.javaee.ejb.model.xml.EjbBase;
import com.intellij.javaee.ejb.model.xml.EjbWithHome;
import com.intellij.javaee.ejb.model.xml.EntityBean;
import com.intellij.javaee.ejb.model.xml.MessageDrivenBean;
import com.intellij.javaee.ejb.model.xml.SessionBean;
import com.intellij.javaee.ejb.module.view.ejb.ejbLevel.EjbClassesPropertiesPanel;
import com.intellij.javaee.ejb.resources.EjbBundle;
import com.intellij.javaee.ejb.utils.EjbDataHolder;
import com.intellij.javaee.ejb.utils.EjbType;
import com.intellij.javaee.ejb.utils.EjbUtil;
import com.intellij.javaee.model.JavaeeModelElement;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class EjbClassesPropertiesDialog
extends DialogWrapper {
    private final EjbClassesPropertiesPanel myClassesPropertiesPanel;
    private final EjbDataHolder myEjbInfo;
    private final EjbBase myEjb;
    private final Module myModule;
    private static final ClassInfoGetter<EjbBase, PsiClass> EJB_CLASS_INFO_GETTER = new ClassInfoGetter<EjbBase, PsiClass>(){

        @Override
        public boolean isEntity(EjbBase info) {
            return info instanceof EntityBean;
        }

        @Override
        public boolean isSession(EjbBase info) {
            return info instanceof SessionBean;
        }

        @Override
        public boolean isMessage(EjbBase info) {
            return info instanceof MessageDrivenBean;
        }

        @Override
        @Nullable
        public PersistenceType getPersistenceType(EjbBase info) {
            return (PersistenceType)((EntityBean)info).getPersistenceType().getValue();
        }

        @Override
        @Nullable
        public CmpVersion getCmpVersion(EjbBase info) {
            return (CmpVersion)((EntityBean)info).getCmpVersion().getValue();
        }

        @Override
        @Nullable
        public SessionType getSessionType(EjbBase info) {
            return (SessionType)((SessionBean)info).getSessionType().getValue();
        }

        @Override
        public boolean isGenerateLocal(EjbBase info) {
            return true;
        }

        @Override
        public boolean isGenerateRemote(EjbBase info) {
            return true;
        }

        @Override
        public EjbFacet getFacet(EjbBase ejbBase) {
            return EjbModuleUtil.getEjbFacet((JavaeeModelElement)ejbBase);
        }

        @Override
        @Nullable
        public PsiClass getMainClass(EjbBase info) {
            return (PsiClass)info.getEjbClass().getValue();
        }

        @Override
        @Nullable
        public PsiClass getLocalHomeInterface(EjbBase info) {
            return (PsiClass)((EjbWithHome)info).getLocalHome().getValue();
        }

        @Override
        public PsiClass getLocalInterface(EjbBase info) {
            return (PsiClass)((EjbWithHome)info).getLocal().getValue();
        }

        @Override
        public PsiClass getRemoteHomeInterface(EjbBase info) {
            return (PsiClass)((EjbWithHome)info).getHome().getValue();
        }

        @Override
        public PsiClass getRemoteInterface(EjbBase info) {
            return (PsiClass)((EjbWithHome)info).getRemote().getValue();
        }

        @Override
        @Nullable
        public PsiClass getPKClass(EjbBase info) {
            return (PsiClass)((EntityBean)info).getPrimKeyClass().getValue();
        }

        @Override
        public PsiClass getServiceEndpointInterface(EjbBase info) {
            return (PsiClass)((SessionBean)info).getServiceEndpoint().getValue();
        }
    };
    private static final ClassInfoGetter<EjbDataHolder, String> HOLDER_GETTER = new ClassInfoGetter<EjbDataHolder, String>(){

        @Override
        public boolean isEntity(EjbDataHolder info) {
            return info.getEjbType() == EjbType.Entity;
        }

        @Override
        public boolean isSession(EjbDataHolder info) {
            return info.getEjbType() == EjbType.Session;
        }

        @Override
        public boolean isMessage(EjbDataHolder info) {
            return info.getEjbType() == EjbType.Message;
        }

        @Override
        public EjbFacet getFacet(EjbDataHolder ejbDataHolder) {
            return ejbDataHolder.getEjbFacet();
        }

        @Override
        public PersistenceType getPersistenceType(EjbDataHolder info) {
            return info.getPersistenceType();
        }

        @Override
        public CmpVersion getCmpVersion(EjbDataHolder info) {
            return info.getCmpVersion();
        }

        @Override
        public SessionType getSessionType(EjbDataHolder info) {
            return info.getSessionType();
        }

        @Override
        public boolean isGenerateLocal(EjbDataHolder info) {
            return info.isGenerateLocal();
        }

        @Override
        public boolean isGenerateRemote(EjbDataHolder info) {
            return info.isGenerateRemote();
        }

        @Override
        public String getMainClass(EjbDataHolder info) {
            return info.getClassName();
        }

        @Override
        public String getLocalHomeInterface(EjbDataHolder info) {
            return info.getLocalHomeInterfaceName();
        }

        @Override
        @Nullable
        public String getLocalInterface(EjbDataHolder info) {
            return info.getLocalInterfaceName();
        }

        @Override
        @Nullable
        public String getRemoteHomeInterface(EjbDataHolder info) {
            return info.getRemoteHomeInterfaceName();
        }

        @Override
        @Nullable
        public String getRemoteInterface(EjbDataHolder info) {
            return info.getRemoteInterfaceName();
        }

        @Override
        public String getPKClass(EjbDataHolder info) {
            return info.getPKClassName();
        }

        @Override
        public String getServiceEndpointInterface(EjbDataHolder info) {
            return info.getServiceEndpointInterface();
        }
    };

    public EjbClassesPropertiesDialog(EjbFacet ejbFacet, EjbDataHolder ejbInfo, @Nls String title, Project project, EjbBase ejb) {
        super(ejbFacet.getModule().getProject(), true);
        this.myModule = ejbFacet.getModule();
        this.myEjbInfo = ejbInfo;
        this.myEjb = ejb;
        this.myClassesPropertiesPanel = new EjbClassesPropertiesPanel(ejbFacet.getMergedRoot(), ejbInfo, project, false, false){

            @Override
            protected void updateOKAction() {
                EjbClassesPropertiesDialog.this.setOKActionEnabled(this.isOKActionEnabled());
            }
        };
        this.setTitle(title);
        this.init();
    }

    protected String getHelpId() {
        return "reference.javaee.change-ejb-classes";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myClassesPropertiesPanel.getPreferredFocusedComponent();
    }

    protected JComponent createNorthPanel() {
        return this.myClassesPropertiesPanel.getComponent();
    }

    @Nullable
    public JComponent createCenterPanel() {
        return null;
    }

    protected void doOKAction() {
        List<Pair<String, String>> newClasses;
        if (!this.myClassesPropertiesPanel.isDataValid()) {
            return;
        }
        this.saveEjbInfo();
        if (this.myEjb != null && (newClasses = this.getNotExistingClasses(this.myEjbInfo)).size() > 0) {
            int result = Messages.showYesNoCancelDialog((String)EjbClassesPropertiesDialog.createWarningMessage(newClasses), (String)EjbBundle.message((String)"message.title.change.ejb.classes", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
            if (result == 0) {
                WriteCommandAction.runWriteCommandAction((Project)this.myModule.getProject(), () -> {
                    try {
                        this.createClasses(newClasses);
                    }
                    catch (Exception e) {
                        Messages.showErrorDialog((String)e.getLocalizedMessage(), (String)EjbBundle.message((String)"message.title.change.ejb.classes", (Object[])new Object[0]));
                    }
                });
            } else if (result == 2) {
                return;
            }
        }
        super.doOKAction();
    }

    private void createClasses(List<Pair<String, String>> newClasses) throws IncorrectOperationException {
        PsiDirectory classDirectory = this.findClassDirectory();
        if (classDirectory == null) {
            return;
        }
        for (Pair<String, String> pair : newClasses) {
            this.myEjbInfo.createClass((String)pair.getFirst(), (String)pair.getSecond(), classDirectory);
        }
    }

    @Nullable
    private PsiDirectory findClassDirectory() {
        PsiDirectory[] result = new PsiDirectory[]{null};
        EjbClassesPropertiesDialog.collectRequiredClasses(this.myEjb, EJB_CLASS_INFO_GETTER, t -> {
            PsiClass psiClass = (PsiClass)t.first;
            if (psiClass != null && !(psiClass instanceof PsiCompiledElement)) {
                PsiFile psiFile = psiClass.getContainingFile();
                result[0] = ClassUtil.sourceRoot((PsiDirectory)psiFile.getContainingDirectory());
                return true;
            }
            return false;
        });
        return result[0];
    }

    @Nls
    private static String createWarningMessage(List<Pair<String, String>> newClasses) {
        StringBuilder classes = new StringBuilder();
        for (Pair<String, String> newClass1 : newClasses) {
            if (classes.length() > 0) {
                classes.append("\n");
            }
            String newClass = (String)newClass1.getFirst();
            classes.append("'");
            classes.append(newClass);
            classes.append("'");
        }
        if (newClasses.size() == 1) {
            return EjbBundle.message((String)"confirmation.text.class.does.not.exist.create.it", (Object[])new Object[]{classes.toString()});
        }
        return EjbBundle.message((String)"confirmation.text.classes.do.not.exist.create.them", (Object[])new Object[]{classes.toString()});
    }

    private List<Pair<String, String>> getNotExistingClasses(EjbDataHolder ejbInfo) {
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        for (Pair<String, String> pair : EjbClassesPropertiesDialog.collectRequiredClasses(ejbInfo)) {
            if (EjbClassesPropertiesDialog.getClass(this.myModule, (String)pair.getFirst()) != null) continue;
            result.add(pair);
        }
        return result;
    }

    private static <Info, Class> void collectRequiredClasses(Info ejbInfo, ClassInfoGetter<Info, Class> getter, Processor<Pair<Class, String>> processor) {
        if (!processor.process((Object)Pair.create(getter.getMainClass(ejbInfo), (Object)EjbClassesPropertiesDialog.getEjbClassTemplateName(ejbInfo, getter)))) {
            return;
        }
        if (!getter.isMessage(ejbInfo)) {
            if (getter.isGenerateLocal(ejbInfo)) {
                if (!processor.process((Object)Pair.create(getter.getLocalHomeInterface(ejbInfo), (Object)(getter.isEntity(ejbInfo) ? "Entity Local Home Interface.java" : "Session Local Home Interface.java")))) {
                    return;
                }
                if (!processor.process((Object)Pair.create(getter.getLocalInterface(ejbInfo), (Object)"EJB Local Interface.java"))) {
                    return;
                }
            }
            if (getter.isGenerateRemote(ejbInfo)) {
                if (!processor.process((Object)Pair.create(getter.getRemoteHomeInterface(ejbInfo), (Object)(getter.isEntity(ejbInfo) ? "Entity Home Interface.java" : "Session Home Interface.java")))) {
                    return;
                }
                if (!processor.process((Object)Pair.create(getter.getRemoteInterface(ejbInfo), (Object)"EJB Remote Interface.java"))) {
                    return;
                }
            }
            if (getter.isSession(ejbInfo) && !processor.process((Object)Pair.create(getter.getServiceEndpointInterface(ejbInfo), (Object)"Session Service Endpoint Interface.java"))) {
                return;
            }
            if (getter.isEntity(ejbInfo)) {
                processor.process((Object)Pair.create(getter.getPKClass(ejbInfo), (Object)"#DEFAULT_CLASS_TEMPLATE"));
            }
        }
    }

    public static List<Pair<PsiClass, String>> collectRequiredClasses(EjbBase ejb) {
        ArrayList<Pair<PsiClass, String>> result = new ArrayList<Pair<PsiClass, String>>();
        EjbClassesPropertiesDialog.collectRequiredClasses(ejb, EJB_CLASS_INFO_GETTER, new FilteringProcessor(t -> t.first != null, (Processor)new CommonProcessors.CollectProcessor(result)));
        return result;
    }

    public static List<Pair<String, String>> collectRequiredClasses(EjbDataHolder ejbInfo) {
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        EjbClassesPropertiesDialog.collectRequiredClasses(ejbInfo, HOLDER_GETTER, new FilteringProcessor(t -> !StringUtil.isEmpty((String)((String)t.first)), (Processor)new CommonProcessors.CollectProcessor(result)));
        return result;
    }

    private static <Info> String getEjbClassTemplateName(Info ejb, ClassInfoGetter<Info, ?> getter) {
        boolean isEJB30;
        if (getter.isEntity(ejb)) {
            if (getter.getPersistenceType(ejb) == PersistenceType.BEAN) {
                return "Entity Bean Class BMP.java";
            }
            if (getter.getCmpVersion(ejb) == CmpVersion.CmpVersion_1_X) {
                return "Entity Bean Class CMP 1x.java";
            }
            return "Entity Bean Class CMP 2x.java";
        }
        EjbFacet ejbFacet = getter.getFacet(ejb);
        boolean bl = isEJB30 = ejbFacet == null || EjbDescriptorVersion.EJB_VERSION_3_0.compareTo((Enum)EjbUtil.getVersion(ejbFacet)) <= 0;
        if (getter.isSession(ejb)) {
            SessionType type = getter.getSessionType(ejb);
            assert (type != null);
            switch (type) {
                case SINGLETON: {
                    return "Session Bean Class Singleton.java";
                }
                case STATEFUL: {
                    return isEJB30 ? "Session Bean Class Stateful 3.java" : "Session Bean Class Stateful.java";
                }
                case STATELESS: {
                    return isEJB30 ? "Session Bean Class Stateless 3.java" : "Session Bean Class Stateless.java";
                }
            }
        }
        return isEJB30 ? "Message Driven Bean Class 3.java" : "Message Driven Bean Class.java";
    }

    @Nullable
    private static PsiClass getClass(Module module, String className) {
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass(className, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.j2ee.ejb.actions.CreateNewEjbDialog";
    }

    private void saveEjbInfo() {
        this.myClassesPropertiesPanel.saveEjbInfo();
    }

    private static interface ClassInfoGetter<Info, Class> {
        public boolean isEntity(Info var1);

        public boolean isSession(Info var1);

        public boolean isMessage(Info var1);

        @Nullable
        public PersistenceType getPersistenceType(Info var1);

        @Nullable
        public CmpVersion getCmpVersion(Info var1);

        @Nullable
        public SessionType getSessionType(Info var1);

        public boolean isGenerateLocal(Info var1);

        public boolean isGenerateRemote(Info var1);

        @Nullable
        public EjbFacet getFacet(Info var1);

        @Nullable
        public Class getMainClass(Info var1);

        @Nullable
        public Class getLocalHomeInterface(Info var1);

        @Nullable
        public Class getLocalInterface(Info var1);

        @Nullable
        public Class getRemoteHomeInterface(Info var1);

        @Nullable
        public Class getRemoteInterface(Info var1);

        @Nullable
        public Class getPKClass(Info var1);

        @Nullable
        public Class getServiceEndpointInterface(Info var1);
    }
}

