/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.module.view.ejb;

import com.intellij.javaee.ejb.resources.EjbBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.ui.IdeBorderFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;

class DeleteEjbClassDialog
extends DialogWrapper {
    private final PsiClass myClass1;
    private final PsiClass myClass2;
    @Nls
    private final String myTitle;
    private JCheckBox myDeleteClasses;

    DeleteEjbClassDialog(Project project, PsiClass aClass1, PsiClass aClass2, @Nls String title) {
        super(project, true);
        this.myClass1 = aClass1;
        this.myClass2 = aClass2;
        this.myTitle = title;
        this.init();
        this.setTitle(title);
    }

    protected String getHelpId() {
        return "j2ee.ejb.deletion.interface";
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        panel.setLayout(new BorderLayout());
        panel.add((Component)new JLabel(this.myTitle), "Center");
        return panel;
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    protected JComponent createSouthPanel() {
        JLabel label;
        String name;
        JPanel groupPanel = new JPanel();
        groupPanel.setBorder(IdeBorderFactory.createTitledBorder((String)""));
        groupPanel.setLayout(new GridLayout(3, 1));
        this.myDeleteClasses = new JCheckBox(EjbBundle.message((String)"checkbox.delete.ejb.delete.following.classes", (Object[])new Object[0]), false);
        groupPanel.add(this.myDeleteClasses);
        if (this.myClass1 != null) {
            name = PsiFormatUtil.formatClass((PsiClass)this.myClass1, (int)2049);
            label = new JLabel(name);
            groupPanel.add(label);
        }
        if (this.myClass2 != null) {
            name = PsiFormatUtil.formatClass((PsiClass)this.myClass2, (int)2049);
            label = new JLabel(name);
            groupPanel.add(label);
        }
        JComponent southPanel = super.createSouthPanel();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)groupPanel, "North");
        panel.add((Component)southPanel, "South");
        return panel;
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.j2ee.ejb.actions.DeleteEjbClassDialog";
    }

    public boolean isDeleteClasses() {
        return this.myDeleteClasses.isSelected();
    }
}

