/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.module.view.ejb;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.ide.util.MemberChooser;
import com.intellij.javaee.ejb.model.EntityBean;
import com.intellij.javaee.ejb.resources.EjbBundle;
import com.intellij.javaee.ejb.utils.EjbUtil;
import com.intellij.javaee.ui.JavaeeCodeStyleSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateTransferObjectDialog
extends MemberChooser<PsiMethodMember> {
    private final Project myProject;
    @NotNull
    private final EntityBean myEjb;
    private PsiDirectory myTargetDirectory;
    private JTextField myFldClassName;
    private JCheckBox myIsGenGetter;
    private JCheckBox myIsGenSetter;
    private JTextField myGetterName;
    private JTextField mySetterName;
    private String oldName;
    private final Object[] myAllElements;
    private final JavaeeCodeStyleSettings myCodeStyleSettings;

    public CreateTransferObjectDialog(Project project, EntityBean ejb, PsiMethod[] elements) {
        super((ClassMember[])((PsiMethodMember[])ContainerUtil.map2Array((Object[])elements, PsiMethodMember.class, s -> new PsiMethodMember(s))), false, true, project);
        this.myProject = project;
        this.myEjb = ejb;
        this.myAllElements = elements;
        this.myCodeStyleSettings = (JavaeeCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)this.myProject).getCustomSettings(JavaeeCodeStyleSettings.class);
        this.oldName = this.myCodeStyleSettings.ENTITY_VO_PREFIX + CreateTransferObjectDialog.getEjbName(ejb) + this.myCodeStyleSettings.ENTITY_VO_SUFFIX;
        this.init();
        this.setTitle(EjbBundle.message((String)"dialog.title.select.accessors.of.fields.to.include.in.transfer.object", (Object[])new Object[0]));
        this.mySetterName.setText(CreateTransferObjectDialog.suggestAccessorName("set", this.oldName));
        this.myGetterName.setText(CreateTransferObjectDialog.suggestAccessorName("get", this.oldName));
        this.myFldClassName.setText(CreateTransferObjectDialog.getEjbName(ejb));
        this.classNameChanged();
        this.checkBoxChanged();
    }

    @Nullable
    private static String getEjbName(EntityBean ejb) {
        return (String)ejb.getEjbName().getValue();
    }

    protected String getHelpId() {
        return "j2ee.unknown";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myFldClassName;
    }

    @Nullable
    protected JComponent createSouthPanel() {
        if (this.myEjb == null) {
            return null;
        }
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints();
        gb.gridy = 0;
        gb.gridx = 0;
        gb.insets = JBInsets.create((int)4, (int)8);
        gb.weightx = 0.0;
        gb.fill = 2;
        gb.anchor = 17;
        gb.gridwidth = 1;
        @NonNls String pattern = this.myCodeStyleSettings.ENTITY_VO_PREFIX + "*" + CreateTransferObjectDialog.getEjbName(this.myEjb) + "*" + this.myCodeStyleSettings.ENTITY_VO_SUFFIX;
        MultiLineLabel classNameHintLabel = new MultiLineLabel(EjbBundle.message((String)"message.text.recommended.transfer.object.class.agrees.with.pattern", (Object[])new Object[]{pattern}));
        JPanel hintPanel = new JPanel(new BorderLayout());
        hintPanel.add((Component)classNameHintLabel, "Center");
        panel.add((Component)hintPanel, gb);
        ++gb.gridy;
        gb.gridx = 0;
        gb.weightx = 0.0;
        panel.add((Component)new JLabel(EjbBundle.message((String)"label.create.transfer.object.transfer.object.class.name", (Object[])new Object[0])), gb);
        JPanel classNamePanel = new JPanel(new BorderLayout());
        ++gb.gridx;
        gb.gridwidth = 0;
        gb.weightx = 1.0;
        this.myFldClassName = new JTextField();
        this.myFldClassName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                CreateTransferObjectDialog.this.classNameChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javaee/ejb/module/view/ejb/CreateTransferObjectDialog$1", "textChanged"));
            }
        });
        @NlsSafe String voPrefix = this.myCodeStyleSettings.ENTITY_VO_PREFIX;
        if (!voPrefix.equals("")) {
            classNamePanel.add((Component)new JLabel(voPrefix), "West");
        }
        classNamePanel.add(this.myFldClassName);
        @NlsSafe String voSuffix = this.myCodeStyleSettings.ENTITY_VO_SUFFIX;
        if (!voSuffix.equals("")) {
            classNamePanel.add((Component)new JLabel(voSuffix), "East");
        }
        panel.add((Component)classNamePanel, gb);
        gb.gridx = 0;
        ++gb.gridy;
        gb.weightx = 0.0;
        gb.gridwidth = 1;
        this.myIsGenGetter = new JCheckBox(EjbBundle.message((String)"checkbox.create.transfer.object.generate.getter.in.interface", (Object[])new Object[]{CreateTransferObjectDialog.getEjbName(this.myEjb)}), true);
        panel.add((Component)this.myIsGenGetter, gb);
        this.myIsGenGetter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateTransferObjectDialog.this.myGetterName.setEnabled(CreateTransferObjectDialog.this.myIsGenGetter.isSelected());
                CreateTransferObjectDialog.this.checkBoxChanged();
            }
        });
        ++gb.gridx;
        gb.weightx = 1.0;
        gb.gridwidth = 0;
        this.myGetterName = new JTextField();
        panel.add((Component)this.myGetterName, gb);
        gb.gridx = 0;
        ++gb.gridy;
        gb.weightx = 0.0;
        gb.gridwidth = 1;
        this.myIsGenSetter = new JCheckBox(EjbBundle.message((String)"checkbox.create.transfer.object.generate.setter.in.interface", (Object[])new Object[]{CreateTransferObjectDialog.getEjbName(this.myEjb)}), true);
        panel.add((Component)this.myIsGenSetter, gb);
        this.myIsGenSetter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateTransferObjectDialog.this.mySetterName.setEnabled(CreateTransferObjectDialog.this.myIsGenSetter.isSelected());
                CreateTransferObjectDialog.this.checkBoxChanged();
            }
        });
        ++gb.gridx;
        gb.weightx = 1.0;
        gb.gridwidth = 0;
        this.mySetterName = new JTextField();
        panel.add((Component)this.mySetterName, gb);
        gb.gridx = 0;
        ++gb.gridy;
        gb.weightx = 1.0;
        gb.gridwidth = 0;
        panel.add((Component)super.createSouthPanel(), gb);
        DocumentAdapter listener = new DocumentAdapter(){

            public void textChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                CreateTransferObjectDialog.this.updateOKButton();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javaee/ejb/module/view/ejb/CreateTransferObjectDialog$4", "textChanged"));
            }
        };
        this.myGetterName.getDocument().addDocumentListener((DocumentListener)listener);
        this.mySetterName.getDocument().addDocumentListener((DocumentListener)listener);
        return panel;
    }

    private void checkBoxChanged() {
        ArrayList<PsiMethodMember> elements = new ArrayList<PsiMethodMember>();
        boolean includeGetters = this.isGenGetter();
        boolean includeSetters = this.isGenSetter();
        for (Object myAllElement : this.myAllElements) {
            PsiMethod setter;
            PsiMethod method = (PsiMethod)myAllElement;
            String propertyName = EjbUtil.getEjbFieldNameByAccessor(method);
            if (propertyName == null || (includeGetters ? !PropertyUtilBase.isSimplePropertyGetter((PsiMethod)method) || includeSetters && ((setter = PropertyUtilBase.findPropertySetter((PsiClass)method.getContainingClass(), (String)propertyName, (boolean)false, (boolean)true)) == null || !setter.hasModifierProperty("public")) : !includeSetters || !PropertyUtilBase.isSimplePropertySetter((PsiMethod)method))) continue;
            elements.add(new PsiMethodMember(method));
        }
        PsiMethodMember[] arr = elements.toArray(new PsiMethodMember[0]);
        this.resetElements((ClassMember[])arr);
        this.updateOKButton();
        this.selectElements((ClassMember[])arr);
    }

    private void updateOKButton() {
        boolean b;
        PsiNameHelper nameHelper = PsiNameHelper.getInstance((Project)this.myProject);
        boolean bl = b = (this.isGenGetter() || this.isGenSetter()) && nameHelper.isIdentifier(this.getClassName());
        if (this.isGenGetter() && !nameHelper.isIdentifier(this.getGetterName())) {
            b = false;
        }
        if (this.isGenSetter() && !nameHelper.isIdentifier(this.getSetterName())) {
            b = false;
        }
        this.setOKActionEnabled(b);
    }

    protected void doOKAction() {
        if (!this.areElementsSelected()) {
            Messages.showMessageDialog((String)EjbBundle.message((String)"message.text.select.field.to.include.in.transfer.object", (Object[])new Object[0]), (String)EjbBundle.message((String)"message.title.no.fields.selected", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return;
        }
        String[] errorString = new String[1];
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            Runnable action = () -> {
                this.myTargetDirectory = ((PsiClass)this.myEjb.getEjbClass().getValue()).getContainingFile().getContainingDirectory();
                errorString[0] = RefactoringMessageUtil.checkCanCreateClass((PsiDirectory)this.myTargetDirectory, (String)this.getClassName());
            };
            ApplicationManager.getApplication().runWriteAction(action);
        }, EjbBundle.message((String)"command.name.create.directory", (Object[])new Object[0]), null);
        if (errorString[0] != null) {
            if (errorString[0].length() > 0) {
                Messages.showMessageDialog((Project)this.myProject, (String)errorString[0], (String)EjbBundle.message((String)"message.title.error", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            }
            return;
        }
        super.doOKAction();
    }

    private void classNameChanged() {
        if (this.getSetterName().equals(CreateTransferObjectDialog.suggestAccessorName("set", this.oldName))) {
            this.mySetterName.setText(CreateTransferObjectDialog.suggestAccessorName("set", this.getClassName()));
        }
        if (this.getGetterName().equals(CreateTransferObjectDialog.suggestAccessorName("get", this.oldName))) {
            this.myGetterName.setText(CreateTransferObjectDialog.suggestAccessorName("get", this.getClassName()));
        }
        this.oldName = this.getClassName();
        this.updateOKButton();
    }

    private static String suggestAccessorName(@NonNls String prefix, @NonNls String className) {
        if (className != null && className.length() > 0) {
            return prefix + Character.toUpperCase(className.charAt(0)) + className.substring(1);
        }
        return "";
    }

    public boolean isGenGetter() {
        return this.myIsGenGetter.isSelected();
    }

    public boolean isGenSetter() {
        return this.myIsGenSetter.isSelected();
    }

    public String getGetterName() {
        return this.myGetterName.getText();
    }

    public String getSetterName() {
        return this.mySetterName.getText();
    }

    public String getClassName() {
        return this.myCodeStyleSettings.ENTITY_VO_PREFIX + this.myFldClassName.getText() + this.myCodeStyleSettings.ENTITY_VO_SUFFIX;
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.javaee.module.view.ejb.CreateTransferObjectDialog";
    }
}

