/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.model.xml.impl;

import com.intellij.javaee.constants.JavaeeCommonConstants;
import com.intellij.javaee.ejb.model.ActivationConfigProperty;
import com.intellij.javaee.ejb.model.EjbDescriptorVersion;
import com.intellij.javaee.ejb.model.InterceptorMethod;
import com.intellij.javaee.ejb.model.common.enums.TransactionType;
import com.intellij.javaee.ejb.model.xml.MessageDrivenBean;
import com.intellij.javaee.ejb.model.xml.compatibility.MessageDrivenDestinationType;
import com.intellij.javaee.ejb.model.xml.compatibility.SubscriptionDurabilityType;
import com.intellij.javaee.ejb.model.xml.impl.EnterpriseBeanImpl;
import com.intellij.javaee.ejb.model.xml.impl.GenericValueImpl;
import com.intellij.javaee.ejb.model.xml.impl.InterceptorImpl;
import com.intellij.javaee.ejb.utils.EjbUtil;
import com.intellij.javaee.model.JavaeeModelElement;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.GenericValue;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class MessageDrivenBeanImpl
extends EnterpriseBeanImpl
implements MessageDrivenBean {
    @Override
    public GenericValue<PsiMethod> getTimeoutMethodValue() {
        if (this.getTimeoutMethod().getXmlTag() != null) {
            return this.getTimeoutMethod().getMethod();
        }
        return super.getTimeoutMethodValue();
    }

    public GenericDomValue<TransactionType> getTransactionManagementType() {
        return this.getTransactionType();
    }

    public GenericValue<PsiClass> getMessageListenerInterface() {
        if (this.usesOldJmsOnlyStyle()) {
            return GenericValueImpl.getInstance(this.findPsiClass(JavaeeCommonConstants.JMS_MESSAGE_LISTENER_CLASS.javax()));
        }
        return this.getMessagingType();
    }

    public List<? extends ActivationConfigProperty> getActivationConfigProperties() {
        if (this.usesOldJmsOnlyStyle()) {
            ArrayList<ActivationConfigProperty> list = new ArrayList<ActivationConfigProperty>();
            MessageDrivenBeanImpl mdb = this;
            MessageDrivenDestinationType type = (MessageDrivenDestinationType)mdb.getMessageDrivenDestination().getDestinationType().getValue();
            SubscriptionDurabilityType durability = (SubscriptionDurabilityType)mdb.getMessageDrivenDestination().getSubscriptionDurability().getValue();
            this.addActivationConfigProperty(list, "acknowledgeMode", mdb.getAcknowledgeMode().getStringValue());
            this.addActivationConfigProperty(list, "messageSelector", (String)mdb.getMessageSelector().getValue());
            this.addActivationConfigProperty(list, "destinationType", type == null ? null : type.getValue());
            this.addActivationConfigProperty(list, "subscriptionDurability", durability == null ? null : durability.getValue());
            return list;
        }
        return this.getActivationConfig().getActivationConfigProperties();
    }

    @Override
    public void processInterceptorMethods(PsiClass currentClass, Processor<InterceptorMethod> processor) {
        super.processInterceptorMethods(currentClass, processor);
        if (!InterceptorImpl.processAroundInvokes((PsiClass)this.getEjbClass().getValue(), this.getAroundInvokes(), currentClass, processor)) {
            return;
        }
    }

    public boolean usesOldJmsOnlyStyle() {
        return EjbUtil.getVersion((JavaeeModelElement)this) == EjbDescriptorVersion.EJB_VERSION_2_0;
    }

    public void setActivationConfigProperty(String name, String value) {
        for (com.intellij.javaee.ejb.model.xml.ActivationConfigProperty property : this.getActivationConfig().getActivationConfigProperties()) {
            if (!name.equals(property.getActivationConfigPropertyName().getValue())) continue;
            property.getActivationConfigPropertyValue().setValue((Object)value);
            return;
        }
        com.intellij.javaee.ejb.model.xml.ActivationConfigProperty property = this.getActivationConfig().addActivationConfigProperty();
        property.getActivationConfigPropertyName().setValue((Object)name);
        property.getActivationConfigPropertyValue().setValue((Object)value);
    }

    public String getActivationConfigProperty(String name) {
        for (com.intellij.javaee.ejb.model.xml.ActivationConfigProperty property : this.getActivationConfig().getActivationConfigProperties()) {
            if (!name.equals(property.getActivationConfigPropertyName().getValue())) continue;
            return (String)property.getActivationConfigPropertyValue().getValue();
        }
        return null;
    }

    private void addActivationConfigProperty(ArrayList<ActivationConfigProperty> list, final String name, final String value) {
        if (name == null || value == null) {
            return;
        }
        ActivationConfigProperty activationConfigProperty = new ActivationConfigProperty(){
            GenericValue<String> myName;
            GenericValue<String> myValue;
            {
                this.myName = new GenericValueImpl<String>(name);
                this.myValue = new GenericValueImpl<String>(value);
            }

            public GenericValue<String> getPropertyName() {
                return this.myName;
            }

            public GenericValue<String> getPropertyValue() {
                return this.myValue;
            }

            public boolean isValid() {
                return true;
            }

            public XmlTag getXmlTag() {
                return null;
            }

            public PsiManager getPsiManager() {
                return MessageDrivenBeanImpl.this.getPsiManager();
            }

            public Module getModule() {
                return MessageDrivenBeanImpl.this.getModule();
            }

            @Nullable
            public PsiFile getContainingFile() {
                return MessageDrivenBeanImpl.this.getContainingFile();
            }

            public PsiElement getIdentifyingPsiElement() {
                return null;
            }
        };
        list.add(activationConfigProperty);
    }
}

