/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.model.xml.impl;

import com.intellij.javaee.ejb.model.InterceptorMethod;
import com.intellij.javaee.ejb.model.InterceptorMethodType;
import com.intellij.javaee.ejb.model.xml.AroundInvoke;
import com.intellij.javaee.ejb.model.xml.AssemblyDescriptor;
import com.intellij.javaee.ejb.model.xml.EjbLifecycleCallback;
import com.intellij.javaee.ejb.model.xml.Interceptor;
import com.intellij.javaee.ejb.model.xml.InterceptorBinding;
import com.intellij.javaee.ejb.model.xml.NamedMethod;
import com.intellij.javaee.ejb.model.xml.impl.EjbXmlImplUtil;
import com.intellij.javaee.ejb.model.xml.impl.EnvironmentGroupImpl;
import com.intellij.javaee.ejb.utils.EjbUtil;
import com.intellij.javaee.model.JavaeeModelElement;
import com.intellij.javaee.model.xml.JavaeeDomModelElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public abstract class InterceptorImpl
extends EnvironmentGroupImpl
implements Interceptor {
    public void processInterceptorBindings(Processor<com.intellij.javaee.ejb.model.InterceptorBinding> processor) {
        AssemblyDescriptor assemblyDescriptor = EjbXmlImplUtil.getAssemblyDescriptor((JavaeeModelElement)this);
        if (assemblyDescriptor == null) {
            return;
        }
        for (InterceptorBinding binding : assemblyDescriptor.getInterceptorBindings()) {
            GenericDomValue interceptorClassValue = (GenericDomValue)ContainerUtil.find((Iterable)binding.getInterceptorClasses(), object -> Objects.equals(this.getInterceptorClass().getStringValue(), object.getStringValue()));
            if (interceptorClassValue == null) continue;
            String ejbName = binding.getEnterpriseBean().getStringValue();
            if ("*".equals(ejbName)) {
                if (processor.process((Object)InterceptorImpl.createBinding(ejbName, null, binding, (GenericDomValue<PsiClass>)interceptorClassValue))) continue;
                return;
            }
            Object ejb = EjbUtil.findEjbByName(this.getModule(), ejbName);
            if (ejb == null || ejb.getEjbClass().getValue() == null) continue;
            NamedMethod namedMethod = binding.getMethod();
            if (namedMethod.getXmlTag() == null) {
                if (processor.process((Object)InterceptorImpl.createBinding(ejbName, (PsiMember)ejb.getEjbClass().getValue(), binding, (GenericDomValue<PsiClass>)interceptorClassValue))) continue;
                return;
            }
            for (PsiMethod psiMethod : EjbXmlImplUtil.findMethods((PsiClass)ejb.getEjbClass().getValue(), namedMethod)) {
                if (processor.process((Object)InterceptorImpl.createBinding(ejbName, (PsiMember)psiMethod, binding, (GenericDomValue<PsiClass>)interceptorClassValue))) continue;
                return;
            }
        }
    }

    public void processInterceptorMethods(PsiClass currentClass, Processor<InterceptorMethod> processor) {
        if (!InterceptorImpl.processAroundInvokes((PsiClass)this.getInterceptorClass().getValue(), this.getAroundInvokes(), currentClass, processor)) {
            return;
        }
        if (!InterceptorImpl.processLifecycleCallbackList((PsiClass)this.getInterceptorClass().getValue(), this.getPostActivates(), InterceptorMethodType.POST_ACTIVATE, currentClass, processor)) {
            return;
        }
        if (!InterceptorImpl.processLifecycleCallbackList((PsiClass)this.getInterceptorClass().getValue(), this.getPostConstructs(), InterceptorMethodType.POST_CONSTRUCT, currentClass, processor)) {
            return;
        }
        if (!InterceptorImpl.processLifecycleCallbackList((PsiClass)this.getInterceptorClass().getValue(), this.getPreDestroys(), InterceptorMethodType.PRE_DESTROY, currentClass, processor)) {
            return;
        }
        if (!InterceptorImpl.processLifecycleCallbackList((PsiClass)this.getInterceptorClass().getValue(), this.getPrePassivates(), InterceptorMethodType.PRE_PASSIVATE, currentClass, processor)) {
            return;
        }
    }

    static boolean processAroundInvokes(PsiClass topClass, List<? extends AroundInvoke> aroundInvokes, PsiClass currentClass, Processor<? super InterceptorMethod> processor) {
        boolean checkDeep = currentClass == null;
        for (AroundInvoke aroundInvoke : aroundInvokes) {
            PsiClass aClass = (PsiClass)aroundInvoke.getClazz().getValue();
            PsiClass targetClass = checkDeep ? (aClass != null ? aClass : topClass) : currentClass;
            if (targetClass == null || aClass != null && !checkDeep && targetClass != aClass) continue;
            for (PsiMethod psiMethod : targetClass.findMethodsByName(aroundInvoke.getMethodName().getStringValue(), checkDeep)) {
                if (processor.process((Object)InterceptorImpl.createInterceptorMethod(psiMethod, InterceptorMethodType.AROUND_INVOKE, (JavaeeDomModelElement)aroundInvoke))) continue;
                return false;
            }
        }
        return true;
    }

    static boolean processLifecycleCallbackList(PsiClass topClass, List<? extends EjbLifecycleCallback> list, InterceptorMethodType type, PsiClass currentClass, Processor<? super InterceptorMethod> processor) {
        boolean checkDeep = currentClass == null;
        for (EjbLifecycleCallback ejbLifecycleCallback : list) {
            PsiClass aClass = (PsiClass)ejbLifecycleCallback.getLifecycleCallbackClass().getValue();
            PsiClass targetClass = checkDeep ? (aClass != null ? aClass : topClass) : currentClass;
            if (targetClass == null || aClass != null && !checkDeep && targetClass != aClass) continue;
            for (PsiMethod psiMethod : targetClass.findMethodsByName(ejbLifecycleCallback.getLifecycleCallbackMethod().getStringValue(), checkDeep)) {
                if (processor.process((Object)InterceptorImpl.createInterceptorMethod(psiMethod, type, (JavaeeDomModelElement)ejbLifecycleCallback))) continue;
                return false;
            }
        }
        return true;
    }

    static InterceptorMethod createInterceptorMethod(PsiMethod psiMethod, InterceptorMethodType type, JavaeeDomModelElement element) {
        return new MyInterceptorMethod(psiMethod, type, element);
    }

    private static com.intellij.javaee.ejb.model.InterceptorBinding createBinding(final String ejbName, final PsiMember psiMember, final InterceptorBinding binding, final GenericDomValue<PsiClass> interceptorClassValue) {
        return new com.intellij.javaee.ejb.model.InterceptorBinding(){

            public String getEjbName() {
                return ejbName;
            }

            public PsiMember getTargetMember() {
                return psiMember;
            }

            public void delete() {
                if (binding.getInterceptorClasses().size() == 1) {
                    binding.undefine();
                } else {
                    interceptorClassValue.undefine();
                }
            }
        };
    }

    private static class MyInterceptorMethod
    implements InterceptorMethod {
        private final PsiMethod myPsiMethod;
        private final InterceptorMethodType myType;
        private final JavaeeDomModelElement myElement;

        MyInterceptorMethod(PsiMethod psiMethod, InterceptorMethodType type, JavaeeDomModelElement element) {
            this.myPsiMethod = psiMethod;
            this.myType = type;
            this.myElement = element;
        }

        @Nullable
        public PsiMethod getMethod() {
            return this.myPsiMethod;
        }

        public InterceptorMethodType getType() {
            return this.myType;
        }

        public void delete() throws IncorrectOperationException {
            this.myElement.undefine();
        }

        public JavaeeDomModelElement getDefiningElement() {
            return this.myElement;
        }

        public PsiFile getContainingFile() {
            return this.myElement.getContainingFile();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyInterceptorMethod that = (MyInterceptorMethod)o;
            if (this.myElement != null ? !this.myElement.equals(that.myElement) : that.myElement != null) {
                return false;
            }
            if (this.myPsiMethod != null ? !this.myPsiMethod.equals(that.myPsiMethod) : that.myPsiMethod != null) {
                return false;
            }
            return this.myType == that.myType;
        }

        public int hashCode() {
            int result = this.myPsiMethod != null ? this.myPsiMethod.hashCode() : 0;
            result = 31 * result + (this.myType != null ? this.myType.hashCode() : 0);
            result = 31 * result + (this.myElement != null ? this.myElement.hashCode() : 0);
            return result;
        }
    }
}

