/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.model.annotations.ejb;

import com.intellij.jam.JamClassAttributeElement;
import com.intellij.jam.annotations.JamAnnotation;
import com.intellij.jam.annotations.JamAttribute;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamMemberArchetype;
import com.intellij.javaee.ejb.model.EjbAnnotationConstants;
import com.intellij.javaee.ejb.model.EjbDescriptorVersion;
import com.intellij.javaee.ejb.model.SessionBean;
import com.intellij.javaee.ejb.model.annotations.ejb.NonEntityBeanImpl;
import com.intellij.javaee.ejb.model.common.enums.SessionType;
import com.intellij.javaee.ejb.utils.EjbUtil;
import com.intellij.javaee.model.JavaeeModelElement;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.ref.AnnotationChildLink;
import com.intellij.semantic.SemKey;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.GenericValueUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class SessionBeanImpl
extends NonEntityBeanImpl
implements SessionBean {
    public static final JamMemberArchetype<PsiClass, SessionBeanImpl> SESSION_ARCHETYPE = new JamMemberArchetype(EJB_META_ARCHETYPE).addAnnotation(new JamAnnotationMeta(EjbAnnotationConstants.REMOTE_ANNO.javax()).addAttribute((JamAttributeMeta)JamClassAttributeMeta.Single.CLASS_VALUE_META)).addAnnotation(new JamAnnotationMeta(EjbAnnotationConstants.LOCAL_ANNO.javax()).addAttribute((JamAttributeMeta)JamClassAttributeMeta.Single.CLASS_VALUE_META)).addAnnotation(new JamAnnotationMeta(EjbAnnotationConstants.LOCAL_HOME_ANNO.javax()).addAttribute((JamAttributeMeta)JamClassAttributeMeta.Single.CLASS_VALUE_META)).addAnnotation(new JamAnnotationMeta(EjbAnnotationConstants.REMOTE_HOME_ANNO.javax()).addAttribute((JamAttributeMeta)JamClassAttributeMeta.Single.CLASS_VALUE_META)).addAnnotation(new JamAnnotationMeta(EjbAnnotationConstants.REMOTE_ANNO.jakarta()).addAttribute((JamAttributeMeta)JamClassAttributeMeta.Single.CLASS_VALUE_META)).addAnnotation(new JamAnnotationMeta(EjbAnnotationConstants.LOCAL_ANNO.jakarta()).addAttribute((JamAttributeMeta)JamClassAttributeMeta.Single.CLASS_VALUE_META)).addAnnotation(new JamAnnotationMeta(EjbAnnotationConstants.LOCAL_HOME_ANNO.jakarta()).addAttribute((JamAttributeMeta)JamClassAttributeMeta.Single.CLASS_VALUE_META)).addAnnotation(new JamAnnotationMeta(EjbAnnotationConstants.REMOTE_HOME_ANNO.jakarta()).addAttribute((JamAttributeMeta)JamClassAttributeMeta.Single.CLASS_VALUE_META));
    public static final JamClassMeta<Stateful> STATEFUL_META = new JamClassMeta(SESSION_ARCHETYPE, Stateful.class, JAVAEE_ENVIRONMENT_KEY.subKey("@Stateful", new SemKey[0])).addRootAnnotation(new JamAnnotationMeta(EjbAnnotationConstants.STATEFUL_ANNO.javax(), EJB_ANNO_NAME_META)).addRootAnnotation(new JamAnnotationMeta(EjbAnnotationConstants.STATEFUL_ANNO.jakarta(), EJB_ANNO_NAME_META));
    public static final JamClassMeta<Stateless> STATELESS_META = new JamClassMeta(SESSION_ARCHETYPE, Stateless.class, JAVAEE_ENVIRONMENT_KEY.subKey("@Stateless", new SemKey[0])).addRootAnnotation(new JamAnnotationMeta(EjbAnnotationConstants.STATELESS_ANNO.javax(), EJB_ANNO_NAME_META)).addRootAnnotation(new JamAnnotationMeta(EjbAnnotationConstants.STATELESS_ANNO.jakarta(), EJB_ANNO_NAME_META));
    public static final JamClassMeta<Singleton> SINGLETON_META = new JamClassMeta(SESSION_ARCHETYPE, Singleton.class, JAVAEE_ENVIRONMENT_KEY.subKey("@Singleton", new SemKey[0])).addRootAnnotation(new JamAnnotationMeta(EjbAnnotationConstants.SINGLETON_ANNO.javax(), EJB_ANNO_NAME_META)).addRootAnnotation(new JamAnnotationMeta(EjbAnnotationConstants.SINGLETON_ANNO.jakarta(), EJB_ANNO_NAME_META));

    public SessionBeanImpl(PsiClass psiClass, @NotNull JavaeeClass javaeeClass) {
        if (javaeeClass == null) {
            SessionBeanImpl.$$$reportNull$$$0(0);
        }
        super(psiClass, javaeeClass);
    }

    @JamAnnotation(value="javax.jws.WebService")
    @JamAttribute(value="endpointInterface")
    public abstract JamClassAttributeElement getServiceEndpoint();

    public List<GenericValue<PsiClass>> getBusinessLocals() {
        return new ArrayList<GenericValue<PsiClass>>(this.collectBusinessInterfaces(true, false));
    }

    public List<GenericValue<PsiClass>> getBusinessRemotes() {
        return new ArrayList<GenericValue<PsiClass>>(this.collectBusinessInterfaces(false, true));
    }

    public GenericValue<Boolean> getLocalBean() {
        PsiAnnotation annotation = this.findAnnotation(EjbAnnotationConstants.LOCAL_BEAN_ANNO.fqn(this.getJavaeeType()));
        return AnnotationGenericValue.getInstance((Object)(annotation != null || this.getBusinessInterfaces().contains(this.getEjbClass()) ? 1 : 0), (PsiAnnotation)annotation, null);
    }

    public List<GenericValue<PsiClass>> getBusinessInterfaces() {
        Collection<GenericValue<PsiClass>> collection = this.collectBusinessInterfaces(true, true);
        JamClassAttributeElement service = this.getServiceEndpoint();
        if (!service.getParentAnnotationElement().isImaginary()) {
            collection.add((GenericValue<PsiClass>)service);
        }
        if (collection.isEmpty() && EjbDescriptorVersion.EJB_VERSION_3_1.compareTo((Enum)EjbUtil.getVersion((JavaeeModelElement)this)) <= 0) {
            collection.add(this.getEjbClass());
        }
        return new ArrayList<GenericValue<PsiClass>>(collection);
    }

    protected Collection<GenericValue<PsiClass>> collectBusinessInterfaces(boolean local, boolean remote) {
        boolean hasEmptyLocal;
        LinkedHashSet<GenericValue<PsiClass>> result = new LinkedHashSet<GenericValue<PsiClass>>();
        PsiClass ejbClass = (PsiClass)this.getEjbClass().getValue();
        if (ejbClass == null) {
            return result;
        }
        List locals = JamClassAttributeMeta.Collection.CLASS_COLLECTION_VALUE_META.getJam(this.createAnnoRef(this.getPsiClass(), EjbAnnotationConstants.LOCAL_ANNO));
        List remotes = JamClassAttributeMeta.Collection.CLASS_COLLECTION_VALUE_META.getJam(this.createAnnoRef(this.getPsiClass(), EjbAnnotationConstants.REMOTE_ANNO));
        boolean hasEmptyRemote = this.hasAnnotation(ejbClass, EjbAnnotationConstants.REMOTE_ANNO) && remotes.isEmpty();
        boolean bl = hasEmptyLocal = this.hasAnnotation(ejbClass, EjbAnnotationConstants.LOCAL_ANNO) && locals.isEmpty();
        if (local) {
            result.addAll(locals);
        }
        if (remote) {
            result.addAll(remotes);
        }
        for (PsiClass aClass : ejbClass.getInterfaces()) {
            if (this.isStandardInterface(aClass.getQualifiedName())) continue;
            for (PsiClass psiInterface : JamCommonUtil.getSuperClassList((PsiClass)aClass)) {
                boolean addAsRemote;
                String qName = psiInterface.getQualifiedName();
                if (this.isStandardInterface(qName)) continue;
                boolean explicitRemote = this.hasAnnotation(psiInterface, EjbAnnotationConstants.REMOTE_ANNO) || GenericValueUtil.containsString((Collection)remotes, (String)qName);
                boolean explicitLocal = this.hasAnnotation(psiInterface, EjbAnnotationConstants.LOCAL_ANNO) || GenericValueUtil.containsString((Collection)locals, (String)qName);
                boolean addAsLocal = explicitLocal || !explicitRemote && (hasEmptyLocal || !hasEmptyRemote);
                boolean bl2 = addAsRemote = explicitRemote || !explicitLocal && hasEmptyRemote;
                if (local && addAsLocal) {
                    result.add((GenericValue<PsiClass>)this.createClassValue(EjbAnnotationConstants.LOCAL_ANNO, psiInterface));
                }
                if (!remote || !addAsRemote) continue;
                result.add((GenericValue<PsiClass>)this.createClassValue(EjbAnnotationConstants.REMOTE_ANNO, psiInterface));
            }
        }
        return result;
    }

    protected boolean hasAnnotation(@NotNull PsiClass ejbClass, @NotNull JavaeeClass anno) {
        if (ejbClass == null) {
            SessionBeanImpl.$$$reportNull$$$0(1);
        }
        if (anno == null) {
            SessionBeanImpl.$$$reportNull$$$0(2);
        }
        return !this.createAnnoRef(ejbClass, anno).isImaginary();
    }

    @NotNull
    private PsiElementRef<PsiAnnotation> createAnnoRef(PsiClass psiClass, JavaeeClass anno) {
        PsiElementRef psiElementRef = AnnotationChildLink.createRef((PsiModifierListOwner)psiClass, (String)anno.fqn(this.getJavaeeType()));
        if (psiElementRef == null) {
            SessionBeanImpl.$$$reportNull$$$0(3);
        }
        return psiElementRef;
    }

    private JamClassAttributeElement createClassValue(@NotNull JavaeeClass javaeeClass, PsiClass value) {
        if (javaeeClass == null) {
            SessionBeanImpl.$$$reportNull$$$0(4);
        }
        return JamClassAttributeMeta.Single.CLASS_VALUE_META.getJam(this.createAnnoRef(this.getPsiClass(), javaeeClass), () -> value);
    }

    @Override
    public GenericValue<PsiClass> getHome() {
        return JamClassAttributeMeta.Single.CLASS_VALUE_META.getJam(this.createAnnoRef(this.getPsiClass(), EjbAnnotationConstants.REMOTE_HOME_ANNO));
    }

    @Override
    public GenericValue<PsiClass> getLocalHome() {
        return JamClassAttributeMeta.Single.CLASS_VALUE_META.getJam(this.createAnnoRef(this.getPsiClass(), EjbAnnotationConstants.LOCAL_HOME_ANNO));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaeeClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ejbClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/model/annotations/ejb/SessionBeanImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/model/annotations/ejb/SessionBeanImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnoRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasAnnotation";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createClassValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class Singleton
    extends SessionBeanImpl {
        public Singleton(PsiClass psiClass) {
            super(psiClass, EjbAnnotationConstants.SINGLETON_ANNO);
        }

        @Override
        protected JamClassMeta<?> getClassMeta() {
            return SINGLETON_META;
        }

        public GenericValue<SessionType> getSessionType() {
            return AnnotationGenericValue.getInstance((Object)SessionType.SINGLETON, (PsiAnnotation)((PsiAnnotation)this.getAnnoRef().getPsiElement()), null);
        }
    }

    public static abstract class Stateless
    extends SessionBeanImpl {
        public Stateless(PsiClass psiClass) {
            super(psiClass, EjbAnnotationConstants.STATELESS_ANNO);
        }

        @Override
        protected JamClassMeta<?> getClassMeta() {
            return STATELESS_META;
        }

        public GenericValue<SessionType> getSessionType() {
            return AnnotationGenericValue.getInstance((Object)SessionType.STATELESS, (PsiAnnotation)((PsiAnnotation)this.getAnnoRef().getPsiElement()), null);
        }
    }

    public static abstract class Stateful
    extends SessionBeanImpl {
        public Stateful(PsiClass psiClass) {
            super(psiClass, EjbAnnotationConstants.STATEFUL_ANNO);
        }

        @Override
        protected JamClassMeta<?> getClassMeta() {
            return STATEFUL_META;
        }

        public GenericValue<SessionType> getSessionType() {
            return AnnotationGenericValue.getInstance((Object)SessionType.STATEFUL, (PsiAnnotation)((PsiAnnotation)this.getAnnoRef().getPsiElement()), null);
        }
    }
}

