/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.model.annotations.ejb;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.constants.JavaeeCommonConstants;
import com.intellij.javaee.ejb.model.EjbAnnotationConstants;
import com.intellij.javaee.ejb.model.NonEntityBean;
import com.intellij.javaee.ejb.model.annotations.ejb.EjbMethodImpl;
import com.intellij.javaee.ejb.model.annotations.ejb.EnterpriseBeanImpl;
import com.intellij.javaee.ejb.model.common.enums.TransactionType;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.util.xml.GenericValue;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NonEntityBeanImpl
extends EnterpriseBeanImpl
implements NonEntityBean {
    private List<AnnotationGenericValue<PsiMethod>> myTimeoutMethods;

    protected NonEntityBeanImpl(PsiClass psiClass, @NotNull JavaeeClass javaeeClass) {
        if (javaeeClass == null) {
            NonEntityBeanImpl.$$$reportNull$$$0(0);
        }
        super(psiClass, javaeeClass);
    }

    public GenericValue<TransactionType> getTransactionManagementType() {
        return AnnotationModelUtil.getEnumValue((PsiAnnotation)this.findAnnotation(EjbAnnotationConstants.TRANSACTION_MANAGEMENT_ANNO.fqn(this.getJavaeeType())), (String)"value", TransactionType.class);
    }

    protected boolean isStandardInterface(String qName) {
        return qName == null || qName.startsWith(JavaeeCommonConstants.JAVAX_EJB_PACKAGE_PREFIX.javax()) || qName.startsWith(JavaeeCommonConstants.JAVAX_EJB_PACKAGE_PREFIX.jakarta()) || qName.equals("java.io.Serializable") || qName.equals("java.io.Externalizable");
    }

    @Nullable
    protected PsiClass getDefaultBusinessInterface(PsiClass psiClass) {
        PsiClass psiInterface = null;
        for (PsiClass curClass : JamCommonUtil.getSuperClassList((PsiClass)psiClass)) {
            for (PsiClass aClass : curClass.getInterfaces()) {
                String qName = aClass.getQualifiedName();
                if (this.isStandardInterface(qName)) continue;
                if (psiInterface != null) {
                    if (aClass.isInheritor(psiInterface, true)) {
                        psiInterface = aClass;
                        continue;
                    }
                    if (psiInterface.isInheritor(aClass, true)) continue;
                    return null;
                }
                psiInterface = aClass;
            }
        }
        return psiInterface;
    }

    public GenericValue<PsiMethod> getTimeoutMethodValue() {
        for (EjbMethodImpl method : this.getEjbMethods()) {
            Boolean value = (Boolean)method.isTimeoutMethod().getValue();
            if (value == null || !value.booleanValue()) continue;
            return AnnotationGenericValue.getInstance((Object)method.getPsiMethod(), null, null);
        }
        return AnnotationGenericValue.nullInstance();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaeeClass", "com/intellij/javaee/ejb/model/annotations/ejb/NonEntityBeanImpl", "<init>"));
    }
}

