/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.model.annotations.ejb;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamMemberArchetype;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.javaee.constants.JavaeeAnnotationConstants;
import com.intellij.javaee.ejb.model.EjbAnnotationConstants;
import com.intellij.javaee.ejb.model.annotations.ejb.EjbReferenceImpl;
import com.intellij.javaee.ejb.model.annotations.ejb.ResourceImpl;
import com.intellij.javaee.ejb.model.annotations.ejb.ServiceRefImpl;
import com.intellij.javaee.ejb.model.common.EnvironmentGroup;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.ref.AnnotationChildLink;
import com.intellij.semantic.SemKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EnvironmentGroupImpl
extends CommonModelElement.PsiBase
implements EnvironmentGroup,
JamElement {
    public static final SemKey<EnvironmentGroupImpl> JAVAEE_ENVIRONMENT_KEY = JamService.JAM_ELEMENT_KEY.subKey("JAVAEE_ENVIRONMENT_KEY", new SemKey[0]);
    public static final JamAttributeMeta<List<EjbReferenceImpl>> EJBS_VALUE_META = JamAttributeMeta.annoCollection((String)"value", (JamAnnotationMeta)EjbReferenceImpl.JAVAX_EJB_ANNO_META, EjbReferenceImpl.class);
    public static final JamAttributeMeta<List<EjbReferenceImpl>> JAKARTA_EJBS_VALUE_META = JamAttributeMeta.annoCollection((String)"value", (JamAnnotationMeta)EjbReferenceImpl.JAKARTA_EJB_ANNO_META, EjbReferenceImpl.class);
    public static final JamAttributeMeta<List<ResourceImpl>> JAVAX_RESOURCES_VALUE_META = JamAttributeMeta.annoCollection((String)"value", (JamAnnotationMeta)ResourceImpl.JAVAX_RESOURCE_ANNO_META, ResourceImpl.class);
    public static final JamAttributeMeta<List<ResourceImpl>> JAKARTA_RESOURCES_VALUE_META = JamAttributeMeta.annoCollection((String)"value", (JamAnnotationMeta)ResourceImpl.JAKARTA_RESOURCE_ANNO_META, ResourceImpl.class);
    public static final JamAttributeMeta<List<ServiceRefImpl>> JAVAX_SERVICES_VALUE_META = JamAttributeMeta.annoCollection((String)"value", (JamAnnotationMeta)ServiceRefImpl.JAVAX_SERVICE_ANNO_META, ServiceRefImpl.class);
    public static final JamAttributeMeta<List<ServiceRefImpl>> JAKARTA_SERVICES_VALUE_META = JamAttributeMeta.annoCollection((String)"value", (JamAnnotationMeta)ServiceRefImpl.JAKARTA_SERVICE_ANNO_META, ServiceRefImpl.class);
    private static final JamAnnotationMeta EJBS_ANNO_META = new JamAnnotationMeta(EjbAnnotationConstants.EJBS_ANNO.javax()).addAttribute(EJBS_VALUE_META);
    private static final JamAnnotationMeta JAKARTA_EJBS_ANNO_META = new JamAnnotationMeta(EjbAnnotationConstants.EJBS_ANNO.jakarta()).addAttribute(JAKARTA_EJBS_VALUE_META);
    private static final JamAnnotationMeta JAVAX_RESOURCES_ANNO_META = new JamAnnotationMeta(JavaeeAnnotationConstants.RESOURCES_ANNO.javax()).addAttribute(JAVAX_RESOURCES_VALUE_META);
    private static final JamAnnotationMeta JAKARTA_RESOURCES_ANNO_META = new JamAnnotationMeta(JavaeeAnnotationConstants.RESOURCES_ANNO.jakarta()).addAttribute(JAKARTA_RESOURCES_VALUE_META);
    private static final JamAnnotationMeta JAVAX_SERVICES_ANNO_META = new JamAnnotationMeta(JavaeeAnnotationConstants.WEB_SERVICE_REFS_ANNO.javax()).addAttribute(JAVAX_SERVICES_VALUE_META);
    private static final JamAnnotationMeta JAKARTA_SERVICES_ANNO_META = new JamAnnotationMeta(JavaeeAnnotationConstants.WEB_SERVICE_REFS_ANNO.jakarta()).addAttribute(JAKARTA_SERVICES_VALUE_META);
    public static final JamMemberArchetype<PsiClass, EnvironmentGroupImpl> ENV_GROUP_ARCHETYPE = new JamMemberArchetype(null).addAnnotation(EjbReferenceImpl.JAVAX_EJB_ANNO_META).addAnnotation(EjbReferenceImpl.JAKARTA_EJB_ANNO_META).addAnnotation(EJBS_ANNO_META).addAnnotation(JAKARTA_EJBS_ANNO_META).addAnnotation(JAVAX_RESOURCES_ANNO_META).addAnnotation(JAKARTA_RESOURCES_ANNO_META).addAnnotation(ResourceImpl.JAVAX_RESOURCE_ANNO_META).addAnnotation(ResourceImpl.JAKARTA_RESOURCE_ANNO_META).addAnnotation(JAVAX_SERVICES_ANNO_META).addAnnotation(JAKARTA_SERVICES_ANNO_META);
    private final PsiClass myPsiClass;
    private final PsiElementRef<PsiAnnotation> myAnno;
    private final JavaeeType myJavaeeType;

    protected EnvironmentGroupImpl(@NotNull PsiClass aClass, @NotNull JavaeeClass anno) {
        if (aClass == null) {
            EnvironmentGroupImpl.$$$reportNull$$$0(0);
        }
        if (anno == null) {
            EnvironmentGroupImpl.$$$reportNull$$$0(1);
        }
        this.myPsiClass = aClass;
        this.myJavaeeType = anno.typeFromAnnotated((PsiModifierListOwner)aClass);
        this.myAnno = AnnotationChildLink.createRef((PsiModifierListOwner)aClass, (String)anno.fqn(this.myJavaeeType));
    }

    public PsiClass getPsiClass() {
        return this.myPsiClass;
    }

    public PsiElementRef<PsiAnnotation> getAnnoRef() {
        return this.myAnno;
    }

    public JavaeeType getJavaeeType() {
        return this.myJavaeeType;
    }

    public boolean isValid() {
        return super.isValid() && Comparing.equal((Object)this.getClassMeta().getJamElement((PsiModifierListOwner)this.getPsiClass()), (Object)((Object)this));
    }

    protected abstract JamClassMeta<?> getClassMeta();

    @Nullable
    protected PsiAnnotation findAnnotation(String annoName) {
        return this.myPsiClass.getModifierList().findAnnotation(annoName);
    }

    public List<EjbReferenceImpl> getEjbReferences() {
        JamService service = JamService.getJamService((Project)this.myPsiClass.getProject());
        ArrayList<EjbReferenceImpl> result = new ArrayList<EjbReferenceImpl>();
        for (PsiClass aClass : JamCommonUtil.getSuperClassList((PsiClass)this.getPsiClass())) {
            result.addAll((Collection)EJBS_ANNO_META.getAttribute((PsiModifierListOwner)aClass, EJBS_VALUE_META));
            result.addAll((Collection)JAKARTA_EJBS_ANNO_META.getAttribute((PsiModifierListOwner)aClass, JAKARTA_EJBS_VALUE_META));
            result.addAll(service.getAnnotatedMembersList(aClass, 7, new JamMemberMeta[]{EjbReferenceImpl.EJB_META}));
        }
        return result;
    }

    public List<ResourceImpl> getResources() {
        JamService service = JamService.getJamService((Project)this.myPsiClass.getProject());
        ArrayList<ResourceImpl> result = new ArrayList<ResourceImpl>();
        for (PsiClass aClass : JamCommonUtil.getSuperClassList((PsiClass)this.getPsiClass())) {
            result.addAll((Collection)JAVAX_RESOURCES_ANNO_META.getAttribute((PsiModifierListOwner)aClass, JAVAX_RESOURCES_VALUE_META));
            result.addAll((Collection)JAKARTA_RESOURCES_ANNO_META.getAttribute((PsiModifierListOwner)aClass, JAKARTA_RESOURCES_VALUE_META));
            result.addAll(service.getAnnotatedMembersList(aClass, 7, new JamMemberMeta[]{ResourceImpl.RESOURCE_META}));
        }
        return result;
    }

    public List<ServiceRefImpl> getServiceRefs() {
        JamService service = JamService.getJamService((Project)this.myPsiClass.getProject());
        ArrayList<ServiceRefImpl> result = new ArrayList<ServiceRefImpl>();
        for (PsiClass aClass : JamCommonUtil.getSuperClassList((PsiClass)this.getPsiClass())) {
            result.addAll((Collection)JAVAX_SERVICES_ANNO_META.getAttribute((PsiModifierListOwner)aClass, JAVAX_SERVICES_VALUE_META));
            result.addAll((Collection)JAKARTA_SERVICES_ANNO_META.getAttribute((PsiModifierListOwner)aClass, JAKARTA_SERVICES_VALUE_META));
            result.addAll(service.getAnnotatedMembersList(this.myPsiClass, 7, new JamMemberMeta[]{ServiceRefImpl.SERVICE_META}));
        }
        return result;
    }

    @NotNull
    public PsiElement getPsiElement() {
        PsiClass psiClass = this.myPsiClass;
        if (psiClass == null) {
            EnvironmentGroupImpl.$$$reportNull$$$0(2);
        }
        return psiClass;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/model/annotations/ejb/EnvironmentGroupImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/model/annotations/ejb/EnvironmentGroupImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

