/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.model.annotations.ejb;

import com.intellij.jam.JamClassAttributeElement;
import com.intellij.jam.JamConverter;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamEnumAttributeElement;
import com.intellij.jam.JamPomTarget;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.annotations.JamAnnotation;
import com.intellij.jam.annotations.JamAttribute;
import com.intellij.jam.reflect.JamAnnotationArchetype;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamMemberArchetype;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.javaee.constants.JavaeeAnnotationConstants;
import com.intellij.javaee.ejb.EjbHelper;
import com.intellij.javaee.ejb.model.EjbAnnotationConstants;
import com.intellij.javaee.ejb.model.EjbDescriptorVersion;
import com.intellij.javaee.ejb.model.EnterpriseBean;
import com.intellij.javaee.ejb.model.InterceptorMethod;
import com.intellij.javaee.ejb.model.annotations.ejb.EjbMethodImpl;
import com.intellij.javaee.ejb.model.annotations.ejb.EnvironmentGroupImpl;
import com.intellij.javaee.ejb.model.annotations.ejb.InterceptorImpl;
import com.intellij.javaee.ejb.model.annotations.ejb.SecurityRoleImpl;
import com.intellij.javaee.ejb.model.common.enums.TransAttribute;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.model.CommonSecurityRole;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EnterpriseBeanImpl
extends EnvironmentGroupImpl
implements EnterpriseBean {
    public static final JamStringAttributeMeta.Single<String> NAME_ATTRIBUTE_META = JamAttributeMeta.singleString((String)"name");
    public static final JamAnnotationArchetype EJB_ANNO_NAME_META = new JamAnnotationArchetype().addAttribute(NAME_ATTRIBUTE_META);
    public static final JamAttributeMeta<JamEnumAttributeElement<TransAttribute>> TRANSACTION_ATTRIBUTE_VALUE_META = JamAttributeMeta.singleEnum((String)"value", TransAttribute.class);
    public static final JamAnnotationMeta TRANSACTION_ATTRIBUTE_META = new JamAnnotationMeta(EjbAnnotationConstants.TRANSACTION_ATTRIBUTE_ANNO.javax()).addAttribute(TRANSACTION_ATTRIBUTE_VALUE_META);
    public static final JamAttributeMeta<JamStringAttributeElement<CommonSecurityRole>> RUN_AS_VALUE_META = JamAttributeMeta.singleString((String)"value", (JamConverter)new JamConverter<CommonSecurityRole>(){

        public CommonSecurityRole fromString(@Nullable String s, JamStringAttributeElement<CommonSecurityRole> context) {
            EjbClassRole[] ejbRoles;
            if (StringUtil.isEmpty((String)s)) {
                return null;
            }
            for (EjbClassRole ejbRole : ejbRoles = EjbHelper.getEjbHelper().getEjbRoles((PsiClass)PsiTreeUtil.getParentOfType((PsiElement)context.getParentAnnotationElement().getRoot(), PsiClass.class, (boolean)true))) {
                for (CommonSecurityRole securityRole : ejbRole.getFacet().getMergedRoot().getSecurityRoles()) {
                    if (!Objects.equals(securityRole.getRoleName().getValue(), s)) continue;
                    return securityRole;
                }
            }
            return null;
        }
    });
    public static final JamAnnotationMeta RUN_AS_META = new JamAnnotationMeta(JavaeeAnnotationConstants.RUN_AS_ANNO.javax()).addAttribute(RUN_AS_VALUE_META);
    public static final JamAttributeMeta<List<JamStringAttributeElement<SecurityRoleImpl>>> ROLES_COLLECTION_VALUE_META = JamAttributeMeta.collectionString((String)"value", (JamConverter)new JamConverter<SecurityRoleImpl>(){

        public SecurityRoleImpl fromString(@Nullable String s, JamStringAttributeElement<SecurityRoleImpl> context) {
            return new SecurityRoleImpl(s, context.getPsiLiteral());
        }
    });
    public static final JamAnnotationMeta DECLARE_ROLES_META = new JamAnnotationMeta(JavaeeAnnotationConstants.DECLARE_ROLES_ANNO.javax()).addAttribute(ROLES_COLLECTION_VALUE_META);
    public static final JamAnnotationMeta ROLES_ALLOWED_META = new JamAnnotationMeta(JavaeeAnnotationConstants.ROLES_ALLOWED_ANNO.javax()).addAttribute(ROLES_COLLECTION_VALUE_META);
    public static final JamMemberArchetype<PsiClass, EnterpriseBeanImpl> EJB_META_ARCHETYPE = new JamMemberArchetype(ENV_GROUP_ARCHETYPE).addAnnotation(TRANSACTION_ATTRIBUTE_META).addAnnotation(DECLARE_ROLES_META).addAnnotation(ROLES_ALLOWED_META).addPomTargetProducer((ejb, consumer) -> consumer.consume((Object)ejb.getPomTarget()));

    public EnterpriseBeanImpl(PsiClass psiClass, @NotNull JavaeeClass javaeeClass) {
        if (javaeeClass == null) {
            EnterpriseBeanImpl.$$$reportNull$$$0(0);
        }
        super(psiClass, javaeeClass);
    }

    @NotNull
    public EjbDescriptorVersion getEjbVersion() {
        EjbDescriptorVersion ejbDescriptorVersion = EjbDescriptorVersion.EJB_VERSION_3_0;
        if (ejbDescriptorVersion == null) {
            EnterpriseBeanImpl.$$$reportNull$$$0(1);
        }
        return ejbDescriptorVersion;
    }

    public JamStringAttributeElement<String> getEjbName() {
        return NAME_ATTRIBUTE_META.getJam(this.getAnnoRef(), (Factory)((NullableFactory)() -> this.getPsiClass().getName()));
    }

    public GenericValue<PsiClass> getEjbClass() {
        return AnnotationGenericValue.getInstance((Object)this.getPsiClass(), (PsiAnnotation)((PsiAnnotation)this.getAnnoRef().getPsiElement()), null);
    }

    public void processInterceptorMethods(PsiClass currentClass, Processor<InterceptorMethod> processor) {
        boolean processDeep;
        PsiClass topClass = this.getPsiClass();
        boolean bl = processDeep = currentClass == null;
        if (topClass == null || !processDeep && topClass != currentClass && !topClass.isInheritor(currentClass, true)) {
            return;
        }
        InterceptorImpl.processInterceptorMethodsImpl(processDeep ? topClass : currentClass, processor, processDeep);
    }

    public JamEnumAttributeElement<TransAttribute> getTransactionAttribute() {
        return (JamEnumAttributeElement)TRANSACTION_ATTRIBUTE_META.getAttribute((PsiModifierListOwner)this.getPsiClass(), TRANSACTION_ATTRIBUTE_VALUE_META);
    }

    public GenericValue<? extends CommonSecurityRole> getRunAs() {
        return (GenericValue)RUN_AS_META.getAttribute((PsiModifierListOwner)this.getPsiClass(), RUN_AS_VALUE_META);
    }

    public List<EjbMethodImpl> getEjbMethods() {
        JamService jamService = JamService.getJamService((Project)this.getPsiClass().getProject());
        return jamService.getAnnotatedMembersList(this.getPsiClass(), 10, new JamMemberMeta[]{EjbMethodImpl.METHOD_META});
    }

    public GenericValue<Boolean> isPermitAll() {
        return AnnotationModelUtil.getBooleanValue((PsiAnnotation)this.findAnnotation(JavaeeAnnotationConstants.PERMIT_ALL_ANNO.fqn(this.getJavaeeType())));
    }

    public GenericValue<Boolean> isDenyAll() {
        return AnnotationModelUtil.getBooleanValue((PsiAnnotation)this.findAnnotation(JavaeeAnnotationConstants.DENY_ALL_ANNO.fqn(this.getJavaeeType())));
    }

    public List<SecurityRoleImpl> getSecurityRoleRefs() {
        ArrayList<SecurityRoleImpl> result = new ArrayList<SecurityRoleImpl>();
        for (JamStringAttributeElement<SecurityRoleImpl> jamStringAttributeElement : this.getDeclaredRoles()) {
            ContainerUtil.addIfNotNull(result, (Object)((Object)((SecurityRoleImpl)((Object)jamStringAttributeElement.getValue()))));
        }
        for (JamStringAttributeElement jamStringAttributeElement : this.getRolesAllowed()) {
            ContainerUtil.addIfNotNull(result, (Object)((Object)((SecurityRoleImpl)((Object)jamStringAttributeElement.getValue()))));
        }
        return result;
    }

    public List<JamStringAttributeElement<SecurityRoleImpl>> getDeclaredRoles() {
        return (List)DECLARE_ROLES_META.getAttribute((PsiModifierListOwner)this.getPsiClass(), ROLES_COLLECTION_VALUE_META);
    }

    public List<JamStringAttributeElement<SecurityRoleImpl>> getRolesAllowed() {
        return (List)ROLES_ALLOWED_META.getAttribute((PsiModifierListOwner)this.getPsiClass(), ROLES_COLLECTION_VALUE_META);
    }

    public GenericValue<Boolean> isExcludeDefaultInterceptors() {
        return AnnotationModelUtil.getBooleanValue((PsiAnnotation)this.findAnnotation(JavaeeAnnotationConstants.EXCLUDE_DEFAULT_INTERCEPTORS_ANNO.fqn(this.getJavaeeType())));
    }

    @JamAnnotation(value="javax.interceptor.Interceptors")
    @JamAttribute(value="value")
    public abstract List<JamClassAttributeElement> getClassInterceptors();

    public GenericValue<PsiClass> getHome() {
        return AnnotationGenericValue.nullInstance();
    }

    public GenericValue<PsiClass> getRemote() {
        return AnnotationGenericValue.nullInstance();
    }

    public GenericValue<PsiClass> getLocalHome() {
        return AnnotationGenericValue.nullInstance();
    }

    public GenericValue<PsiClass> getLocal() {
        return AnnotationGenericValue.nullInstance();
    }

    private PomTarget getPomTarget() {
        JamStringAttributeElement<String> nameValue = this.getEjbName();
        return nameValue.getPsiLiteral() == null ? this.getPsiClass() : new JamPomTarget((JamElement)this, nameValue);
    }

    public PsiElement getIdentifyingPsiElement() {
        return PomService.convertToPsi((Project)this.getPsiClass().getProject(), (PomTarget)this.getPomTarget());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaeeClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/model/annotations/ejb/EnterpriseBeanImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/model/annotations/ejb/EnterpriseBeanImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEjbVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

