/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.model.annotations.ejb;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.facet.FacetManager;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.javaee.constants.JavaeeAnnotationConstants;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.model.EjbDescriptorVersion;
import com.intellij.javaee.ejb.model.EjbRootElement;
import com.intellij.javaee.ejb.model.EnterpriseBeanSet;
import com.intellij.javaee.ejb.model.EntityBean;
import com.intellij.javaee.ejb.model.Interceptor;
import com.intellij.javaee.ejb.model.InterceptorSet;
import com.intellij.javaee.ejb.model.MessageDrivenBean;
import com.intellij.javaee.ejb.model.SessionBean;
import com.intellij.javaee.ejb.model.annotations.ejb.ApplicationExceptionImpl;
import com.intellij.javaee.ejb.model.annotations.ejb.InterceptorImpl;
import com.intellij.javaee.ejb.model.annotations.ejb.MessageDrivenBeanImpl;
import com.intellij.javaee.ejb.model.annotations.ejb.SessionBeanImpl;
import com.intellij.javaee.model.CommonSecurityRole;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ReadOnlyGenericValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class EjbRootElementImpl
extends CommonModelElement.ModuleBase
implements EjbRootElement {
    private static final Key<CachedValue<Collection<PsiClass>>> INTERCEPTOR_CLASSES_KEY = Key.create((String)"INTERCEPTOR_CLASSES_KEY");
    private final EjbFacet myFacet;
    private final CachedValue<List<SessionBeanImpl>> mySessionBeanValue;
    private final CachedValue<List<MessageDrivenBeanImpl>> myMessageBeanValue;
    private final CachedValue<List<ApplicationExceptionImpl>> myExceptionsValue;

    public EjbRootElementImpl(EjbFacet facet) {
        this.myFacet = facet;
        Project project = this.myFacet.getModule().getProject();
        Factory scopeFactory = this::getScope;
        this.mySessionBeanValue = JamCommonUtil.createClassCachedValue((Project)project, (Factory)scopeFactory, (JamClassMeta[])new JamClassMeta[]{SessionBeanImpl.STATEFUL_META, SessionBeanImpl.STATELESS_META, SessionBeanImpl.SINGLETON_META});
        this.myMessageBeanValue = JamCommonUtil.createClassCachedValue((Project)project, (Factory)scopeFactory, (JamClassMeta[])new JamClassMeta[]{MessageDrivenBeanImpl.MDB_META});
        this.myExceptionsValue = JamCommonUtil.createClassCachedValue((Project)project, (Factory)scopeFactory, (JamClassMeta[])new JamClassMeta[]{ApplicationExceptionImpl.APPLICATION_EXCEPTION_META});
    }

    private GlobalSearchScope getScope() {
        return GlobalSearchScope.moduleWithDependenciesScope((Module)this.myFacet.getModule());
    }

    public GenericValue<String> getVersion() {
        return ReadOnlyGenericValue.getInstance((Object)EjbDescriptorVersion.EJB_VERSION_3_0.getValue());
    }

    public List<ApplicationExceptionImpl> getApplicationExceptions() {
        return (List)this.myExceptionsValue.getValue();
    }

    public EnterpriseBeanSet getEnterpriseBeans() {
        return new MyEnterpriseBeanSet();
    }

    public InterceptorSet getInterceptors() {
        return new MyInterceptorSet();
    }

    public List<CommonSecurityRole> getSecurityRoles() {
        HashSet result = new HashSet();
        for (SessionBean ejb : this.getEnterpriseBeans().getSessions()) {
            for (GenericValue value : ejb.getDeclaredRoles()) {
                ContainerUtil.addIfNotNull(result, (Object)((CommonSecurityRole)value.getValue()));
            }
        }
        for (SessionBean ejb : this.getEnterpriseBeans().getMessageDrivens()) {
            for (GenericValue value : ejb.getDeclaredRoles()) {
                ContainerUtil.addIfNotNull(result, (Object)((CommonSecurityRole)value.getValue()));
            }
        }
        return Arrays.asList(result.toArray(new CommonSecurityRole[result.size()]));
    }

    @NotNull
    public Module getModule() {
        Module module = this.myFacet.getModule();
        if (module == null) {
            EjbRootElementImpl.$$$reportNull$$$0(0);
        }
        return module;
    }

    public static Collection<PsiClass> getInterceptorClasses(Project project) {
        return (Collection)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, INTERCEPTOR_CLASSES_KEY, () -> new CachedValueProvider.Result(EjbRootElementImpl.calculateInterceptorClasses(project), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false);
    }

    private static Collection<PsiClass> calculateInterceptorClasses(Project project) {
        if (DumbService.isDumb((Project)project)) {
            return Collections.emptySet();
        }
        HashSet<PsiClass> result = new HashSet<PsiClass>();
        EjbRootElementImpl.addInterceptorClasses(JavaeeAnnotationConstants.INTERCEPTORS_ANNO.javax(), project, result);
        EjbRootElementImpl.addInterceptorClasses(JavaeeAnnotationConstants.INTERCEPTORS_ANNO.jakarta(), project, result);
        return result;
    }

    private static void addInterceptorClasses(@NotNull String qualifiedName, @NotNull Project project, @NotNull Set<PsiClass> result) {
        PsiClass annoPsiClass;
        if (qualifiedName == null) {
            EjbRootElementImpl.$$$reportNull$$$0(1);
        }
        if (project == null) {
            EjbRootElementImpl.$$$reportNull$$$0(2);
        }
        if (result == null) {
            EjbRootElementImpl.$$$reportNull$$$0(3);
        }
        if ((annoPsiClass = JavaPsiFacade.getInstance((Project)project).findClass(qualifiedName, GlobalSearchScope.allScope((Project)project))) == null) {
            return;
        }
        for (PsiMember psiMember : AnnotatedMembersSearch.search((PsiClass)annoPsiClass, (SearchScope)GlobalSearchScope.projectScope((Project)project)).findAll()) {
            PsiAnnotation anno = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiMember, (String[])new String[]{qualifiedName});
            PsiNameValuePair attr = anno == null ? null : AnnotationUtil.findDeclaredAttribute((PsiAnnotation)anno, (String)"value");
            if (attr == null) continue;
            JamCommonUtil.processObjectArrayValue((PsiAnnotationMemberValue)attr.getDetachedValue(), classRef -> {
                ContainerUtil.addIfNotNull((Collection)result, (Object)JamCommonUtil.getPsiClass((PsiElement)classRef));
                return true;
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/model/annotations/ejb/EjbRootElementImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/model/annotations/ejb/EjbRootElementImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addInterceptorClasses";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyInterceptorSet
    extends CommonModelElement.ModuleBase
    implements InterceptorSet {
        private MyInterceptorSet() {
        }

        @NotNull
        public Module getModule() {
            Module module = EjbRootElementImpl.this.myFacet.getModule();
            if (module == null) {
                MyInterceptorSet.$$$reportNull$$$0(0);
            }
            return module;
        }

        public List<? extends Interceptor> getInterceptors() {
            GlobalSearchScope scope = EjbRootElementImpl.this.getScope();
            ArrayList result = new ArrayList();
            for (PsiClass psiClass : EjbRootElementImpl.getInterceptorClasses(EjbRootElementImpl.this.myFacet.getModule().getProject())) {
                if (!scope.contains(psiClass.getContainingFile().getVirtualFile())) continue;
                ContainerUtil.addIfNotNull(result, (Object)((Object)((InterceptorImpl)InterceptorImpl.INTERCEPTOR_META.getJamElement((PsiModifierListOwner)psiClass))));
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/model/annotations/ejb/EjbRootElementImpl$MyInterceptorSet", "getModule"));
        }
    }

    private class MyEnterpriseBeanSet
    extends CommonModelElement.ModuleBase
    implements EnterpriseBeanSet {
        private MyEnterpriseBeanSet() {
        }

        @NotNull
        public Module getModule() {
            Module module = EjbRootElementImpl.this.myFacet.getModule();
            if (module == null) {
                MyEnterpriseBeanSet.$$$reportNull$$$0(0);
            }
            return module;
        }

        public boolean isValid() {
            return FacetManager.getInstance((Module)EjbRootElementImpl.this.myFacet.getModule()).findFacet(EjbRootElementImpl.this.myFacet.getTypeId(), EjbRootElementImpl.this.myFacet.getName()) == EjbRootElementImpl.this.myFacet;
        }

        public List<? extends SessionBean> getSessions() {
            return (List)EjbRootElementImpl.this.mySessionBeanValue.getValue();
        }

        public List<? extends EntityBean> getEntities() {
            return Collections.emptyList();
        }

        public List<? extends MessageDrivenBean> getMessageDrivens() {
            return (List)EjbRootElementImpl.this.myMessageBeanValue.getValue();
        }

        public List<? extends GenericValue<PsiClass>> getDefaultInterceptors() {
            return Collections.emptyList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/model/annotations/ejb/EjbRootElementImpl$MyEnterpriseBeanSet", "getModule"));
        }
    }
}

