/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.model.annotations.ejb;

import com.intellij.jam.JamService;
import com.intellij.javaee.constants.JavaeeAnnotationConstants;
import com.intellij.javaee.ejb.NewEjbRoleHolder;
import com.intellij.javaee.ejb.model.EjbAnnotationConstants;
import com.intellij.javaee.ejb.model.EnterpriseBean;
import com.intellij.javaee.ejb.model.EntityBean;
import com.intellij.javaee.ejb.model.MessageDrivenBean;
import com.intellij.javaee.ejb.model.SessionBean;
import com.intellij.javaee.ejb.model.annotations.ejb.ApplicationExceptionImpl;
import com.intellij.javaee.ejb.model.annotations.ejb.EjbMethodImpl;
import com.intellij.javaee.ejb.model.annotations.ejb.EjbReferenceImpl;
import com.intellij.javaee.ejb.model.annotations.ejb.EjbRootElementImpl;
import com.intellij.javaee.ejb.model.annotations.ejb.EntityBeanImpl;
import com.intellij.javaee.ejb.model.annotations.ejb.InterceptorImpl;
import com.intellij.javaee.ejb.model.annotations.ejb.InterceptorMethodImpl;
import com.intellij.javaee.ejb.model.annotations.ejb.MessageDrivenBeanImpl;
import com.intellij.javaee.ejb.model.annotations.ejb.ResourceImpl;
import com.intellij.javaee.ejb.model.annotations.ejb.ServiceRefImpl;
import com.intellij.javaee.ejb.model.annotations.ejb.SessionBeanImpl;
import com.intellij.javaee.ejb.model.common.enums.SessionType;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.ejb.utils.EjbUtil;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiAnnotationPattern;
import com.intellij.patterns.PsiClassPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.semantic.SemContributor;
import com.intellij.semantic.SemKey;
import com.intellij.semantic.SemRegistrar;
import com.intellij.util.ConstantFunction;
import com.intellij.util.NullableFunction;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericValue;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

final class EjbJamContributor
extends SemContributor {
    EjbJamContributor() {
    }

    public void registerSemProviders(@NotNull SemRegistrar registrar, @NotNull Project project) {
        if (registrar == null) {
            EjbJamContributor.$$$reportNull$$$0(0);
        }
        if (project == null) {
            EjbJamContributor.$$$reportNull$$$0(1);
        }
        ApplicationExceptionImpl.APPLICATION_EXCEPTION_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotations(EjbAnnotationConstants.APPLICATION_EXCEPTION_ANNO.all()));
        SessionBeanImpl.STATEFUL_META.register(registrar, PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiClass().withAnnotations(EjbAnnotationConstants.STATEFUL_ANNO.all()), EjbJamContributor.createEjbClassPattern(SessionBean.class, SessionType.STATEFUL)}));
        SessionBeanImpl.STATELESS_META.register(registrar, PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiClass().withAnnotations(EjbAnnotationConstants.STATELESS_ANNO.all()), EjbJamContributor.createEjbClassPattern(SessionBean.class, SessionType.STATELESS)}));
        SessionBeanImpl.SINGLETON_META.register(registrar, PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiClass().withAnnotations(EjbAnnotationConstants.SINGLETON_ANNO.all()), EjbJamContributor.createEjbClassPattern(SessionBean.class, SessionType.SINGLETON)}));
        MessageDrivenBeanImpl.MDB_META.register(registrar, PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiClass().withAnnotations(EjbAnnotationConstants.MESSAGE_DRIVEN_ANNO.all()), EjbJamContributor.createEjbClassPattern(MessageDrivenBean.class, null)}));
        EntityBeanImpl.ENTITY_META.register(registrar, (ElementPattern)EjbJamContributor.createEjbClassPattern(EntityBean.class, null));
        InterceptorImpl.INTERCEPTOR_META.register(registrar, EjbJamContributor.createInterceptorPattern());
        EjbMethodImpl.METHOD_META.register(registrar, PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiMethod().withAnnotations(new String[]{EjbAnnotationConstants.REMOVE_ANNO.javax(), EjbAnnotationConstants.INIT_ANNO.javax(), JavaeeAnnotationConstants.INTERCEPTORS_ANNO.javax(), JavaeeAnnotationConstants.EXCLUDE_CLASS_INTERCEPTORS_ANNO.javax(), JavaeeAnnotationConstants.EXCLUDE_DEFAULT_INTERCEPTORS_ANNO.javax(), EjbAnnotationConstants.TIMEOUT_ANNO.javax(), JavaeeAnnotationConstants.WEB_METHOD_ANNO.javax(), EjbAnnotationConstants.REMOVE_ANNO.jakarta(), EjbAnnotationConstants.INIT_ANNO.jakarta(), JavaeeAnnotationConstants.INTERCEPTORS_ANNO.jakarta(), JavaeeAnnotationConstants.EXCLUDE_CLASS_INTERCEPTORS_ANNO.jakarta(), JavaeeAnnotationConstants.EXCLUDE_DEFAULT_INTERCEPTORS_ANNO.jakarta(), EjbAnnotationConstants.TIMEOUT_ANNO.jakarta(), JavaeeAnnotationConstants.WEB_METHOD_ANNO.jakarta()}), PsiJavaPatterns.psiMethod().with((PatternCondition)new PatternCondition<PsiMethod>("isBusinessMethod"){

            public boolean accepts(@NotNull PsiMethod psiMethod, ProcessingContext context) {
                if (psiMethod == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (psiMethod.isConstructor() || !psiMethod.hasModifierProperty("public") || psiMethod.hasModifierProperty("static")) {
                    return false;
                }
                HashSet businessInterfaces = new HashSet();
                for (EjbClassRole role : NewEjbRoleHolder.getInstance(psiMethod.getProject()).getMergedRoles(psiMethod.getContainingClass())) {
                    EnterpriseBean ejb = role.getEnterpriseBean();
                    if (ejb == null) continue;
                    for (GenericValue value : ejb.getBusinessInterfaces()) {
                        ContainerUtil.addIfNotNull(businessInterfaces, (Object)((PsiClass)value.getValue()));
                    }
                }
                return EjbUtil.isInheritedFromBusinessInterface(psiMethod, businessInterfaces);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/javaee/ejb/model/annotations/ejb/EjbJamContributor$1", "accepts"));
            }
        })}));
        registrar.registerSemElementProvider(JamService.MEMBER_META_KEY.subKey(EjbReferenceImpl.class.getSimpleName() + "sMeta", new SemKey[0]), (ElementPattern)((PsiAnnotationPattern)PsiJavaPatterns.psiAnnotation().withName(EjbAnnotationConstants.EJB_ANNO.all())).inside((ElementPattern)PsiJavaPatterns.psiAnnotation().withName(EjbAnnotationConstants.EJBS_ANNO.all())), (NullableFunction)new ConstantFunction(EjbReferenceImpl.EJB_META));
        EjbReferenceImpl.EJB_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMember().withAnnotations(EjbAnnotationConstants.EJB_ANNO.all()));
        registrar.registerSemElementProvider(JamService.MEMBER_META_KEY.subKey(ServiceRefImpl.class.getSimpleName() + "sMeta", new SemKey[0]), (ElementPattern)((PsiAnnotationPattern)PsiJavaPatterns.psiAnnotation().withName(JavaeeAnnotationConstants.WEB_SERVICE_REF_ANNO.all())).inside((ElementPattern)PsiJavaPatterns.psiAnnotation().withName(JavaeeAnnotationConstants.WEB_SERVICE_REFS_ANNO.all())), (NullableFunction)new ConstantFunction(ServiceRefImpl.SERVICE_META));
        ServiceRefImpl.SERVICE_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMember().withAnnotations(JavaeeAnnotationConstants.WEB_SERVICE_ANNO.all()));
        registrar.registerSemElementProvider(JamService.MEMBER_META_KEY.subKey(ResourceImpl.class.getSimpleName() + "sMeta", new SemKey[0]), (ElementPattern)((PsiAnnotationPattern)PsiJavaPatterns.psiAnnotation().withName(JavaeeAnnotationConstants.RESOURCE_ANNO.all())).inside((ElementPattern)PsiJavaPatterns.psiAnnotation().withName(JavaeeAnnotationConstants.RESOURCES_ANNO.all())), (NullableFunction)new ConstantFunction(ResourceImpl.RESOURCE_META));
        ResourceImpl.RESOURCE_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMember().withAnnotations(JavaeeAnnotationConstants.RESOURCE_ANNO.all()));
        InterceptorMethodImpl.METHOD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().withAnnotations(new String[]{JavaeeAnnotationConstants.PRE_DESTROY_ANNO.javax(), JavaeeAnnotationConstants.POST_CONSTRUCT_ANNO.javax(), EjbAnnotationConstants.POST_ACTIVATE_ANNO.javax(), EjbAnnotationConstants.PRE_PASSIVATE_ANNO.javax(), EjbAnnotationConstants.POST_ACTIVATE_ANNO.javax(), JavaeeAnnotationConstants.AROUND_INVOKE_ANNO.javax(), JavaeeAnnotationConstants.PRE_DESTROY_ANNO.jakarta(), JavaeeAnnotationConstants.POST_CONSTRUCT_ANNO.jakarta(), EjbAnnotationConstants.POST_ACTIVATE_ANNO.jakarta(), EjbAnnotationConstants.PRE_PASSIVATE_ANNO.jakarta(), EjbAnnotationConstants.POST_ACTIVATE_ANNO.jakarta(), JavaeeAnnotationConstants.AROUND_INVOKE_ANNO.jakarta()}));
    }

    private static PsiClassPattern createEjbClassPattern(final Class<? extends EnterpriseBean> beanClass, final SessionType sessionType) {
        return (PsiClassPattern)PsiJavaPatterns.psiClass().with((PatternCondition)new PatternCondition<PsiClass>("xmlEnterpriseBean"){

            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context) {
                if (psiClass == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (EjbClassRole role : NewEjbRoleHolder.getInstance(psiClass.getProject()).getXmlRoles(psiClass)) {
                    EnterpriseBean ejb = role.getEnterpriseBean();
                    if (role.getFacet().getAnnotationRoot() == null || role.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS || !psiClass.getManager().areElementsEquivalent((PsiElement)psiClass, (PsiElement)role.getEnterpriseBean().getEjbClass().getValue())) continue;
                    return beanClass.isInstance(ejb) && (sessionType == null || ((SessionBean)ejb).getSessionType().getValue() == sessionType);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/javaee/ejb/model/annotations/ejb/EjbJamContributor$2", "accepts"));
            }
        });
    }

    private static ElementPattern<? extends PsiClass> createInterceptorPattern() {
        return PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiClass().with((PatternCondition)new PatternCondition<PsiClass>("isInInterceptorsAnnotation"){

            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context) {
                if (psiClass == null) {
                    3.$$$reportNull$$$0(0);
                }
                return EjbRootElementImpl.getInterceptorClasses(psiClass.getProject()).contains(psiClass);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/javaee/ejb/model/annotations/ejb/EjbJamContributor$3", "accepts"));
            }
        }), PsiJavaPatterns.psiClass().with((PatternCondition)new PatternCondition<PsiClass>("xmlInterceptor"){

            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context) {
                if (psiClass == null) {
                    4.$$$reportNull$$$0(0);
                }
                for (EjbClassRole role : NewEjbRoleHolder.getInstance(psiClass.getProject()).getXmlRoles(psiClass)) {
                    if (role.getFacet().getAnnotationRoot() == null || role.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_INTERCEPTOR_CLASS) continue;
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/javaee/ejb/model/annotations/ejb/EjbJamContributor$4", "accepts"));
            }
        })});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "registrar";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/intellij/javaee/ejb/model/annotations/ejb/EjbJamContributor";
        objectArray[2] = "registerSemProviders";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

