/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.managedbean.impl.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.ejb.managedbean.ManagedBeanService;
import com.intellij.javaee.ejb.model.common.managedbean.ManagedBean;
import com.intellij.javaee.utils.highlighting.JavaeeHighlightingUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ManagedBeanClassInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            ManagedBeanClassInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = J2EEBundle.message((String)"group.names.javaee.issues", (Object[])new Object[0]);
        if (string == null) {
            ManagedBeanClassInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return "ManagedBeanClassInspection";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        ManagedBean bean;
        if (aClass == null) {
            ManagedBeanClassInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            ManagedBeanClassInspection.$$$reportNull$$$0(3);
        }
        if ((bean = ManagedBeanService.getInstance((Project)aClass.getProject()).getManagedBean(aClass)) == null) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, aClass.getContainingFile(), isOnTheFly);
        JavaeeHighlightingUtil.checkClassIsInterface((ProblemsHolder)holder, (PsiClass)aClass, (boolean)false);
        JavaeeHighlightingUtil.checkClassModifier((ProblemsHolder)holder, (PsiClass)aClass, (String)"final", (boolean)false);
        JavaeeHighlightingUtil.checkClassModifier((ProblemsHolder)holder, (PsiClass)aClass, (String)"abstract", (boolean)false);
        if (aClass.getContainingClass() != null) {
            JavaeeHighlightingUtil.checkClassModifier((ProblemsHolder)holder, (PsiClass)aClass, (String)"static", (boolean)true);
        }
        return holder.getResultsArray();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/managedbean/impl/inspections/ManagedBeanClassInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/managedbean/impl/inspections/ManagedBeanClassInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

