/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.ejb.codeInsight.annotator.EjbHighlightingBundle;
import com.intellij.javaee.ejb.inspections.AbstractEjbInspection;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class EjbStaticAccessInspection
extends AbstractEjbInspection {
    @Override
    protected JavaElementVisitor createJavaVisitor(final @NotNull ProblemsHolder holder, boolean onTheFly) {
        if (holder == null) {
            EjbStaticAccessInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                PsiClass psiClass = PsiUtil.getTopLevelClass((PsiElement)expression);
                if (psiClass != null && EjbStaticAccessInspection.this.acceptClass(psiClass)) {
                    EjbStaticAccessInspection.checkReferenceExpression(holder, expression);
                }
            }
        };
    }

    private static void checkReferenceExpression(ProblemsHolder holder, PsiReferenceExpression expression) {
        PsiClass aClass;
        PsiField field;
        PsiElement resolved;
        if (PsiUtil.isAccessedForWriting((PsiExpression)expression) && (resolved = expression.resolve()) instanceof PsiField && (field = (PsiField)resolved).hasModifierProperty("static") && !field.hasModifierProperty("final") && PsiTreeUtil.isAncestor((PsiElement)(aClass = field.getContainingClass()), (PsiElement)expression, (boolean)true)) {
            holder.registerProblem((PsiElement)expression, EjbHighlightingBundle.message("prohibited.static.field.access", field.getName()), new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/javaee/ejb/inspections/EjbStaticAccessInspection", "createJavaVisitor"));
    }
}

