/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.ejb.codeInsight.annotator.EjbHighlightingBundle;
import com.intellij.javaee.ejb.inspections.AbstractEjbInspection;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.util.PsiUtil;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class EjbProhibitedPackageUsageInspection
extends AbstractEjbInspection {
    @Override
    protected JavaElementVisitor createJavaVisitor(final @NotNull ProblemsHolder holder, boolean onTheFly) {
        if (holder == null) {
            EjbProhibitedPackageUsageInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                PsiClass psiClass = PsiUtil.getTopLevelClass((PsiElement)reference);
                if (psiClass != null && EjbProhibitedPackageUsageInspection.this.acceptClass(psiClass)) {
                    EjbProhibitedPackageUsageInspection.checkReferenceElement(holder, reference);
                }
            }
        };
    }

    private static void checkReferenceElement(ProblemsHolder holder, PsiJavaCodeReferenceElement element) {
        String qualifiedName;
        PsiElement resolved;
        if (element.getText() != null && (resolved = element.resolve()) instanceof PsiClass && (qualifiedName = ((PsiClass)resolved).getQualifiedName()) != null && Pattern.matches("^(java\\.io\\.File|java\\.awt|javax\\.swing|java\\.lang\\.reflect|java\\.security\\.Policy|java\\.security\\.Security|java\\.security\\.Provider|java\\.security\\.Signer|java\\.security\\.Identity|java\\.net\\.ServerSocket|java\\.lang\\.ClassLoader|java\\.lang\\.SecurityManager|java\\.lang\\.Thread).*$", qualifiedName)) {
            holder.registerProblem((PsiElement)element, EjbHighlightingBundle.message("prohibited.package.usage", qualifiedName), new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/javaee/ejb/inspections/EjbProhibitedPackageUsageInspection", "createJavaVisitor"));
    }
}

