/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.constants.JavaeeCommonConstants;
import com.intellij.javaee.ejb.codeInsight.annotator.EjbHighlightingBundle;
import com.intellij.javaee.ejb.inspections.AbstractEjbInspection;
import com.intellij.javaee.ejb.inspections.EjbHighlightUtil;
import com.intellij.javaee.ejb.model.InterceptorMethod;
import com.intellij.javaee.ejb.model.InterceptorMethodType;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.ejb.utils.EjbUtil;
import com.intellij.javaee.ejb.utils.OldEjbRolesUtil;
import com.intellij.javaee.utils.highlighting.JavaeeHighlightingUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class EjbInterceptorInspection
extends AbstractEjbInspection {
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            EjbInterceptorInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @Override
    protected boolean acceptClass(PsiClass psiClass) {
        for (EjbClassRole role : OldEjbRolesUtil.getEjbRoles(psiClass)) {
            EjbClassRoleEnum type = role.getType();
            if (type != EjbClassRoleEnum.EJB_CLASS_ROLE_INTERCEPTOR_CLASS) continue;
            return true;
        }
        return false;
    }

    @Override
    protected JavaElementVisitor createJavaVisitor(final @NotNull ProblemsHolder holder, boolean onTheFly) {
        if (holder == null) {
            EjbInterceptorInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(){

            public void visitClass(PsiClass aClass) {
                JavaeeHighlightingUtil.checkClassIsInterface((ProblemsHolder)holder, (PsiClass)aClass, (boolean)false);
                EjbHighlightUtil.checkPublicNoArgsConstructorDefined(holder, aClass);
                EjbInterceptorInspection.checkInterceptorMethods(holder, aClass, OldEjbRolesUtil.getEjbRoles(aClass));
            }
        };
    }

    public static void checkInterceptorMethods(ProblemsHolder holder, PsiClass aClass, EjbClassRole[] classRoles) {
        boolean ejbClass = false;
        boolean interceptorClass = false;
        boolean standardOnly = false;
        for (EjbClassRole role : classRoles) {
            if (role.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_INTERCEPTOR_CLASS) {
                standardOnly = false;
                interceptorClass = true;
                continue;
            }
            if (role.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS) continue;
            if (!standardOnly) {
                standardOnly = EjbUtil.implementsStandardEjbInterface(role.getEnterpriseBean());
            }
            ejbClass = true;
        }
        if (ejbClass == interceptorClass) {
            if (ejbClass) {
                holder.registerProblem((PsiElement)aClass.getNameIdentifier(), EjbHighlightingBundle.message("class.both.ejb.and.interceptor", aClass.getName()), new LocalQuickFix[0]);
            }
            return;
        }
        EjbInterceptorInspection.checkInterceptorMethods(holder, EjbInterceptorInspection.buildInterceptorMethodsMap(classRoles, aClass), !ejbClass, standardOnly);
    }

    public static HashMap<InterceptorMethodType, List<InterceptorMethod>> buildInterceptorMethodsMap(EjbClassRole[] classRoles, PsiClass aClass) {
        HashMap<InterceptorMethodType, List<InterceptorMethod>> map = new HashMap<InterceptorMethodType, List<InterceptorMethod>>();
        Processor processor = t -> {
            ArrayList<InterceptorMethod> list = (ArrayList<InterceptorMethod>)map.get(t.getType());
            if (list == null) {
                list = new ArrayList<InterceptorMethod>();
                map.put(t.getType(), list);
            }
            if (!list.contains(t)) {
                list.add((InterceptorMethod)t);
            }
            return true;
        };
        for (EjbClassRole role : classRoles) {
            if (role.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_INTERCEPTOR_CLASS) {
                role.getInterceptor().processInterceptorMethods(aClass, processor);
                continue;
            }
            if (role.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS) continue;
            role.getEnterpriseBean().processInterceptorMethods(aClass, processor);
        }
        return map;
    }

    private static void checkInterceptorMethods(ProblemsHolder holder, HashMap<InterceptorMethodType, List<InterceptorMethod>> map, boolean separateClass, boolean standardNamesOnly) {
        for (Map.Entry<InterceptorMethodType, List<InterceptorMethod>> entry : map.entrySet()) {
            List<InterceptorMethod> list = entry.getValue();
            if (list.size() > 1) {
                HashSet<PsiMethod> set = new HashSet<PsiMethod>();
                for (InterceptorMethod method : list) {
                    set.add(method.getMethod());
                }
                if (set.size() > 1) {
                    for (InterceptorMethod method : list) {
                        holder.registerProblem((PsiElement)method.getMethod().getNameIdentifier(), EjbHighlightingBundle.message("more.than.one.method.defined.for.interceptor.method.type", entry.getKey().getTypeName(), method.getMethod().getContainingClass().getName()), new LocalQuickFix[]{EjbInterceptorInspection.createRemoveElementQuickFix(method)});
                    }
                }
            }
            for (InterceptorMethod method : list) {
                if (!separateClass) {
                    String requiredName;
                    @NonNls String methodName = method.getMethod().getName();
                    if (standardNamesOnly && (requiredName = method.getType().getMethodStandardName()) != null && !requiredName.equals(methodName)) {
                        holder.registerProblem((PsiElement)method.getMethod().getNameIdentifier(), EjbHighlightingBundle.message("interceptor.method.name.should.be.standard", method.getType().getTypeName(), requiredName), new LocalQuickFix[0]);
                    }
                }
                EjbInterceptorInspection.checkInterceptorMethodSignature(holder, method.getMethod(), separateClass, method.getType());
            }
        }
    }

    private static LocalQuickFix createRemoveElementQuickFix(final InterceptorMethod method) {
        final String name = EjbHighlightingBundle.message("text.remove.0", JavaeeUtil.getJavaeeObjectDescription((Object)method.getDefiningElement(), (Function)FunctionUtil.id()));
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = name;
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = EjbHighlightingBundle.message("intention.family.remove.interceptor.method.metadata", new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (descriptor == null) {
                    2.$$$reportNull$$$0(3);
                }
                method.delete();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javaee/ejb/inspections/EjbInterceptorInspection$2";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javaee/ejb/inspections/EjbInterceptorInspection$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static void checkInterceptorMethodSignature(ProblemsHolder holder, PsiMethod psiMethod, boolean separateClass, InterceptorMethodType type) {
        EjbHighlightUtil.checkMethodModifier(holder, psiMethod, "final", false);
        EjbHighlightUtil.checkMethodModifier(holder, psiMethod, "static", false);
        if (separateClass || type == InterceptorMethodType.AROUND_INVOKE) {
            PsiClass invocationContext = EjbHighlightUtil.checkClassAvailable(holder, (PsiElement)psiMethod, JavaeeCommonConstants.INTERCEPTOR_INVOCATION_CONTEXT_CLASS.fqn((PsiElement)psiMethod));
            if (invocationContext != null) {
                EjbHighlightUtil.checkMethodParameters(holder, psiMethod, new PsiType[]{JavaPsiFacade.getInstance((Project)psiMethod.getProject()).getElementFactory().createType(invocationContext)});
            }
        } else {
            EjbHighlightUtil.checkMethodParameters(holder, psiMethod, PsiType.EMPTY_ARRAY);
        }
        if (type == InterceptorMethodType.AROUND_INVOKE) {
            EjbHighlightUtil.checkMethodReturns(holder, psiMethod, "java.lang.Object");
        } else {
            EjbHighlightUtil.checkMethodReturns(holder, psiMethod, (PsiType)PsiType.VOID);
            EjbInterceptorInspection.checkMethodThrows(holder, psiMethod, Collections.emptySet());
        }
    }

    private static void checkMethodThrows(ProblemsHolder holder, PsiMethod method, Set<String> allowedExceptions) {
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory();
        for (PsiJavaCodeReferenceElement element : method.getThrowsList().getReferenceElements()) {
            PsiClassType type = psiElementFactory.createType(element);
            if (ExceptionUtil.isUncheckedException((PsiClassType)type) || allowedExceptions.contains(type.getCanonicalText())) continue;
            holder.registerProblem((PsiElement)element, EjbHighlightingBundle.message("method.should.not.throw", method.getName(), type.getCanonicalText()), new LocalQuickFix[]{QuickFixFactory.getInstance().createMethodThrowsFix(method, type, false, false)});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/inspections/EjbInterceptorInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/inspections/EjbInterceptorInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createJavaVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

