/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.ejb.inspections.AbstractEjbInspection;
import com.intellij.javaee.ejb.inspections.EjbHighlightUtil;
import com.intellij.javaee.ejb.model.EntityBean;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.ejb.role.EjbMethodRole;
import com.intellij.javaee.ejb.utils.OldEjbRolesUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;

public class EjbEntityInterfaceInspection
extends AbstractEjbInspection {
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            EjbEntityInterfaceInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @Override
    protected boolean acceptClass(PsiClass psiClass) {
        EjbClassRole[] classRoles = OldEjbRolesUtil.getEjbRoles(psiClass);
        if (!EjbEntityInterfaceInspection.isOfType(EntityBean.class, classRoles)) {
            return false;
        }
        EnumSet<EjbClassRoleEnum> roleTypes = EjbEntityInterfaceInspection.getRoleTypes(classRoles);
        return roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_REMOTE_INTERFACE) || roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_INTERFACE);
    }

    @Override
    protected JavaElementVisitor createJavaVisitor(final @NotNull ProblemsHolder holder, boolean onTheFly) {
        if (holder == null) {
            EjbEntityInterfaceInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(){

            public void visitMethod(PsiMethod method) {
                EjbClassRole[] classRoles = OldEjbRolesUtil.getEjbRoles(method.getContainingClass());
                EnumSet<EjbClassRoleEnum> roleTypes = AbstractEjbInspection.getRoleTypes(classRoles);
                EjbMethodRole[] methodRoles = OldEjbRolesUtil.getEjbRoles(method);
                if (roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_INTERFACE)) {
                    block3: for (EjbMethodRole role : methodRoles) {
                        switch (role.getType()) {
                            case EJB_METHOD_ROLE_CMR_GETTER_DECL: 
                            case EJB_METHOD_ROLE_CMR_SETTER_DECL: {
                                EjbHighlightUtil.checkCmrAccessorSignature(holder, method, role);
                                break block3;
                            }
                            default: {
                                continue block3;
                            }
                        }
                    }
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/inspections/EjbEntityInterfaceInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/inspections/EjbEntityInterfaceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createJavaVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

