/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.constants.JavaeeCommonConstants;
import com.intellij.javaee.ejb.codeInsight.annotator.EjbHighlightingBundle;
import com.intellij.javaee.ejb.inspections.AbstractEjbInspection;
import com.intellij.javaee.ejb.inspections.EjbHighlightUtil;
import com.intellij.javaee.ejb.inspections.EjbSessionHomeInterfaceInspection;
import com.intellij.javaee.ejb.model.EnterpriseBean;
import com.intellij.javaee.ejb.model.EntityBean;
import com.intellij.javaee.ejb.model.common.enums.CmpVersion;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.ejb.role.EjbMethodRole;
import com.intellij.javaee.ejb.role.EjbMethodRoleEnum;
import com.intellij.javaee.ejb.utils.EjbUtil;
import com.intellij.javaee.ejb.utils.OldEjbRolesUtil;
import com.intellij.javaee.utils.highlighting.JavaeeHighlightingUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.EnumSet;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class EjbEntityHomeInspection
extends AbstractEjbInspection {
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            EjbEntityHomeInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @Override
    protected boolean acceptClass(PsiClass psiClass) {
        EjbClassRole[] classRoles = OldEjbRolesUtil.getEjbRoles(psiClass);
        if (!EjbEntityHomeInspection.isOfType(EntityBean.class, classRoles)) {
            return false;
        }
        EnumSet<EjbClassRoleEnum> roleTypes = EjbEntityHomeInspection.getRoleTypes(classRoles);
        return roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_HOME_INTERFACE) || roleTypes.contains(EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_HOME_INTERFACE);
    }

    @Override
    protected JavaElementVisitor createJavaVisitor(final @NotNull ProblemsHolder holder, boolean onTheFly) {
        if (holder == null) {
            EjbEntityHomeInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(){

            public void visitClass(PsiClass aClass) {
                EjbEntityHomeInspection.checkExistsFindByPKMethod(holder, aClass, OldEjbRolesUtil.getEjbRoles(aClass));
            }

            public void visitMethod(PsiMethod method) {
                EjbClassRole[] classRoles = OldEjbRolesUtil.getEjbRoles(method.getContainingClass());
                EnumSet<EjbClassRoleEnum> roleTypes = AbstractEjbInspection.getRoleTypes(classRoles);
                EjbMethodRole[] methodRoles = OldEjbRolesUtil.getEjbRoles(method);
                EjbEntityHomeInspection.checkCreateMethod(holder, method, methodRoles);
                EjbEntityHomeInspection.checkFinderMethod(holder, method, methodRoles);
                EjbEntityHomeInspection.checkCreateMethodReturn(holder, method, methodRoles, roleTypes);
                EjbEntityHomeInspection.checkFinderMethodReturn(holder, method, methodRoles, roleTypes);
            }
        };
    }

    private static void checkFinderMethodReturn(ProblemsHolder holder, PsiMethod method, EjbMethodRole[] methodRoles, EnumSet<EjbClassRoleEnum> roleTypes) {
        boolean checkReturn = false;
        for (EjbMethodRole role : methodRoles) {
            if (role.getType() != EjbMethodRoleEnum.EJB_METHOD_ROLE_FINDER_DECL) continue;
            checkReturn = true;
            break;
        }
        if (!checkReturn) {
            return;
        }
        boolean findByPK = method.getName().equals("findByPrimaryKey");
        boolean collection = EjbUtil.isCollectionFinderMethod(method);
        HashSet<String> interfaces = EjbEntityHomeInspection.getRequiredInterfaces(methodRoles, EjbMethodRoleEnum.EJB_METHOD_ROLE_FINDER_DECL, roleTypes);
        if (interfaces.size() > 1) {
            if (!collection) {
                if (!findByPK) {
                    interfaces.add("java.util.Collection");
                    interfaces.add("java.util.Enumeration");
                }
                holder.registerProblem((PsiElement)method.getReturnTypeElement(), EjbHighlightingBundle.message("method.should.return", method.getName(), EjbHighlightUtil.getReturnTypesCommaSeparatedList(interfaces.toArray())), new LocalQuickFix[0]);
            }
        } else if (interfaces.size() == 1) {
            if (findByPK) {
                EjbHighlightUtil.checkMethodReturns(holder, method, interfaces.iterator().next());
            } else {
                EjbHighlightUtil.checkMethodReturns(holder, method, new Object[]{"java.util.Collection", "java.util.Enumeration", interfaces.iterator().next()});
            }
        }
    }

    private static void checkCreateMethodReturn(ProblemsHolder holder, PsiMethod method, EjbMethodRole[] methodRoles, EnumSet<EjbClassRoleEnum> roleTypes) {
        EjbSessionHomeInterfaceInspection.checkCreateMethodReturn(holder, method, methodRoles, roleTypes);
    }

    private static HashSet<String> getRequiredInterfaces(EjbMethodRole[] methodRoles, EjbMethodRoleEnum roleType, EnumSet<EjbClassRoleEnum> roleTypes) {
        return EjbSessionHomeInterfaceInspection.getRequiredInterfaces(methodRoles, roleType, roleTypes);
    }

    private static void checkFinderMethod(ProblemsHolder holder, PsiMethod method, EjbMethodRole[] methodRoles) {
        boolean checkFinderException = false;
        for (EjbMethodRole role : methodRoles) {
            if (role.getType() != EjbMethodRoleEnum.EJB_METHOD_ROLE_FINDER_DECL) continue;
            checkFinderException = true;
        }
        if (checkFinderException) {
            EjbHighlightUtil.checkMethodThrows(holder, method, "javax.ejb.FinderException", true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void checkExistsFindByPKMethod(ProblemsHolder holder, PsiClass aClass, EjbClassRole[] classRoles) {
        block9: {
            PsiMethod[] psiFindByPK;
            EjbClassRole chosenClassRole;
            block7: {
                PsiMethod method;
                HashSet<PsiClassType> pkClasses;
                block8: {
                    chosenClassRole = null;
                    for (EjbClassRole ejbClassRole : classRoles) {
                        EntityBean ejb;
                        if (!(ejbClassRole.getEnterpriseBean() instanceof EntityBean) || aClass != (ejb = (EntityBean)ejbClassRole.getEnterpriseBean()).getHome().getValue() && aClass != ejb.getLocalHome().getValue()) continue;
                        chosenClassRole = ejbClassRole;
                        break;
                    }
                    if (chosenClassRole == null) {
                        return;
                    }
                    psiFindByPK = aClass.findMethodsByName("findByPrimaryKey", true);
                    if (psiFindByPK.length != 1) break block7;
                    pkClasses = new HashSet<PsiClassType>();
                    method = psiFindByPK[0];
                    for (EjbMethodRole role : OldEjbRolesUtil.getEjbRoles(method)) {
                        EntityBean ejb;
                        PsiClass pkClass;
                        if (role.getType() != EjbMethodRoleEnum.EJB_METHOD_ROLE_FINDER_DECL || (pkClass = (PsiClass)(ejb = (EntityBean)role.getEnterpriseBean()).getPrimKeyClass().getValue()) == null) continue;
                        pkClasses.add(JavaPsiFacade.getInstance((Project)pkClass.getProject()).getElementFactory().createType(pkClass));
                    }
                    if (pkClasses.size() <= 1) break block8;
                    holder.registerProblem((PsiElement)method.getParameterList(), EjbHighlightingBundle.message("method.parameter.of.type.expected", method.getName(), EjbHighlightUtil.getReturnTypesCommaSeparatedList(pkClasses.toArray())), new LocalQuickFix[0]);
                    break block9;
                }
                if (pkClasses.size() != 1) break block9;
                EjbHighlightUtil.checkMethodParameters(holder, method, new PsiType[]{(PsiType)pkClasses.iterator().next()});
                break block9;
            }
            if (psiFindByPK.length == 0) {
                EntityBean ejb = (EntityBean)chosenClassRole.getEnterpriseBean();
                boolean isRemote = aClass == ejb.getHome().getValue();
                PsiClass psiClass = isRemote ? (PsiClass)ejb.getRemote().getValue() : (PsiClass)ejb.getLocal().getValue();
                PsiClass pkClass = (PsiClass)ejb.getPrimKeyClass().getValue();
                if (psiClass == null || pkClass == null) {
                    return;
                }
                String[] exceptions = isRemote ? new String[]{JavaeeCommonConstants.JAVAX_EJB_FINDER_EXCEPTION_CLASS.fqn((PsiElement)aClass), "java.rmi.RemoteException"} : new String[]{JavaeeCommonConstants.JAVAX_EJB_FINDER_EXCEPTION_CLASS.fqn((PsiElement)aClass)};
                holder.registerProblem((PsiElement)aClass, JavaeeHighlightingUtil.getClassDeclarationRange((PsiClass)aClass), EjbHighlightingBundle.message("home.interface.should.define.findbyprimarykey.method", aClass.getName()), new LocalQuickFix[]{QuickFixFactory.getInstance().createAddMethodFix(EjbEntityHomeInspection.finderMethodTemplate(psiClass, pkClass), aClass, exceptions)});
            } else {
                void var7_15;
                PsiMethod[] psiMethodArray = psiFindByPK;
                int n = psiMethodArray.length;
                boolean bl = false;
                while (var7_15 < n) {
                    PsiMethod psiMethod = psiMethodArray[var7_15];
                    holder.registerProblem((PsiElement)psiMethod.getNameIdentifier(), EjbHighlightingBundle.message("home.interface.should.define.findbyprimarykey.method", aClass.getName()), new LocalQuickFix[0]);
                    ++var7_15;
                }
            }
        }
    }

    private static String finderMethodTemplate(PsiClass ejbInterface, PsiClass pkClass) {
        return "public " + ejbInterface.getQualifiedName() + " findByPrimaryKey(" + pkClass.getQualifiedName() + " key);";
    }

    private static void checkCreateMethod(ProblemsHolder holder, PsiMethod method, EjbMethodRole[] methodRoles) {
        boolean checkCreateException = false;
        boolean checkCMP1Create = false;
        for (EjbMethodRole methodRole : methodRoles) {
            if (methodRole.getType() != EjbMethodRoleEnum.EJB_METHOD_ROLE_CREATE_DECL) continue;
            checkCreateException = true;
            EnterpriseBean ejb = methodRole.getEnterpriseBean();
            if (!(ejb instanceof EntityBean) || !EjbUtil.isCMP(ejb, CmpVersion.CmpVersion_1_X)) continue;
            checkCMP1Create = true;
        }
        if (checkCreateException) {
            EjbHighlightUtil.checkMethodThrows(holder, method, "javax.ejb.CreateException", true);
        }
        if (checkCMP1Create && method.getName().length() > "create".length()) {
            holder.registerProblem((PsiElement)method.getNameIdentifier(), EjbHighlightingBundle.message("cmp1.entity.beans.not.authorized.to.define.method", method.getName()), new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/inspections/EjbEntityHomeInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/inspections/EjbEntityHomeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createJavaVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

