/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.constants.JavaeeCommonConstants;
import com.intellij.javaee.ejb.codeInsight.annotator.EjbHighlightingBundle;
import com.intellij.javaee.ejb.inspections.AbstractEjbInspection;
import com.intellij.javaee.ejb.inspections.EjbHighlightUtil;
import com.intellij.javaee.ejb.model.CmpField;
import com.intellij.javaee.ejb.model.CmrField;
import com.intellij.javaee.ejb.model.EnterpriseBean;
import com.intellij.javaee.ejb.model.EntityBean;
import com.intellij.javaee.ejb.model.common.enums.CmpVersion;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.ejb.role.EjbMethodRole;
import com.intellij.javaee.ejb.utils.EjbUtil;
import com.intellij.javaee.ejb.utils.OldEjbRolesUtil;
import com.intellij.javaee.model.JavaeeModelElement;
import com.intellij.javaee.utils.highlighting.JavaeeHighlightingUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class EjbEntityClassInspection
extends AbstractEjbInspection {
    @Override
    protected boolean acceptClass(PsiClass psiClass) {
        EjbClassRole[] classRoles = OldEjbRolesUtil.getEjbRoles(psiClass);
        return EjbEntityClassInspection.isOfType(EntityBean.class, classRoles) && EjbEntityClassInspection.getRoleTypes(classRoles).contains(EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS);
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            EjbEntityClassInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @Override
    protected JavaElementVisitor createJavaVisitor(final @NotNull ProblemsHolder holder, boolean onTheFly) {
        if (holder == null) {
            EjbEntityClassInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(){

            public void visitClass(PsiClass aClass) {
                EjbEntityClassInspection.checkClass(holder, aClass, OldEjbRolesUtil.getEjbRoles(aClass));
            }

            public void visitMethod(PsiMethod method) {
                EjbEntityClassInspection.checkMethod(holder, method, OldEjbRolesUtil.getEjbRoles(method), OldEjbRolesUtil.getEjbRoles(method.getContainingClass()));
            }
        };
    }

    public static void checkMethod(ProblemsHolder holder, PsiMethod method, EjbMethodRole[] methodRoles, EjbClassRole[] classRoles) {
        EjbEntityClassInspection.checkSelectAndFinderMethod(holder, method, classRoles);
        EjbEntityClassInspection.checkCMPAccesorMethod(holder, method, methodRoles);
        EjbEntityClassInspection.checkCMRAccesorMethod(holder, method, methodRoles);
    }

    public static void checkClass(ProblemsHolder holder, PsiClass aClass, EjbClassRole[] classRoles) {
        if (!EjbUtil.isTopLevelClass(aClass, EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS, classRoles)) {
            return;
        }
        EjbEntityClassInspection.checkClassImplementsCMPAccessors(holder, aClass, classRoles);
        EjbEntityClassInspection.checkClassImplementsCMRAccessors(holder, aClass, classRoles);
    }

    private static void checkSelectAndFinderMethod(ProblemsHolder holder, PsiMethod method, EjbClassRole[] classRoles) {
        boolean check = false;
        boolean isCMP2 = false;
        for (EjbClassRole role : classRoles) {
            if (!(role.getEnterpriseBean() instanceof EntityBean)) continue;
            isCMP2 = EjbUtil.isCMP(role.getEnterpriseBean(), CmpVersion.CmpVersion_2_X);
            check = true;
            break;
        }
        if (!check) {
            return;
        }
        String methodName = method.getName();
        if (methodName.startsWith("ejbSelect")) {
            EjbHighlightUtil.checkMethodModifier(holder, method, "abstract", true);
            EjbHighlightUtil.checkMethodModifier(holder, method, "public", true);
            EjbHighlightUtil.checkMethodThrows(holder, method, JavaeeCommonConstants.JAVAX_EJB_FINDER_EXCEPTION_CLASS.fqn((PsiElement)method), true);
        } else if (methodName.startsWith("ejbFind")) {
            if (isCMP2) {
                holder.registerProblem((PsiElement)method.getNameIdentifier(), EjbHighlightingBundle.message("ejb.class.should.not.define.method", method.getName()), new LocalQuickFix[0]);
            } else {
                EjbHighlightUtil.checkMethodModifier(holder, method, "final", false);
                if (!EjbUtil.isCollectionFinderMethod(method)) {
                    HashSet<String> returnTypes = new HashSet<String>();
                    for (EjbClassRole role : classRoles) {
                        if (!(role.getEnterpriseBean() instanceof EntityBean)) continue;
                        String primaryKeyClassName = ((EntityBean)role.getEnterpriseBean()).getPrimKeyClass().getStringValue();
                        returnTypes.add(primaryKeyClassName);
                        break;
                    }
                    boolean findByPK = methodName.equals("findByPrimaryKey");
                    if (returnTypes.size() > 1) {
                        if (!findByPK) {
                            returnTypes.add("java.util.Collection");
                            returnTypes.add("java.util.Enumeration");
                        }
                        holder.registerProblem((PsiElement)method.getReturnTypeElement(), EjbHighlightingBundle.message("method.should.return", method.getName(), EjbHighlightUtil.getReturnTypesCommaSeparatedList(returnTypes.toArray())), new LocalQuickFix[0]);
                    } else if (returnTypes.size() == 1) {
                        if (findByPK) {
                            EjbHighlightUtil.checkMethodReturns(holder, method, (String)returnTypes.iterator().next());
                        } else {
                            EjbHighlightUtil.checkMethodReturns(holder, method, new Object[]{"java.util.Collection", "java.util.Enumeration", returnTypes.iterator().next()});
                        }
                    }
                } else {
                    EjbHighlightUtil.checkMethodThrows(holder, method, "javax.ejb.ObjectNotFoundException", false);
                }
            }
        }
    }

    private static void checkCMPAccesorMethod(ProblemsHolder holder, PsiMethod method, EjbMethodRole[] methodRoles) {
        boolean checkedOnce = false;
        boolean shouldBeAbstract = false;
        boolean conflict = false;
        boolean checkNotFinal = false;
        block3: for (EjbMethodRole role : methodRoles) {
            switch (role.getType()) {
                case EJB_METHOD_ROLE_CMP_GETTER_IMPL: 
                case EJB_METHOD_ROLE_CMP_SETTER_IMPL: {
                    EntityBean ejb = (EntityBean)role.getEnterpriseBean();
                    boolean curShouldBeAbstract = EjbUtil.isCMP((EnterpriseBean)ejb, CmpVersion.CmpVersion_2_X);
                    if (checkedOnce && !conflict && shouldBeAbstract != curShouldBeAbstract) {
                        conflict = true;
                        continue block3;
                    }
                    if (checkedOnce) continue block3;
                    checkedOnce = true;
                    shouldBeAbstract = curShouldBeAbstract;
                    if (EjbUtil.isEjbVersion1x((JavaeeModelElement)ejb)) continue block3;
                    checkNotFinal = true;
                }
            }
        }
        if (conflict) {
            holder.registerProblem((PsiElement)method.getModifierList(), EjbHighlightingBundle.message("method.should.be.both.abstract.and.not.abstract", method.getName()), new LocalQuickFix[0]);
        } else if (checkedOnce) {
            EjbHighlightUtil.checkMethodModifier(holder, method, "abstract", shouldBeAbstract);
            if (checkNotFinal) {
                EjbHighlightUtil.checkMethodModifier(holder, method, "final", false);
            }
        }
    }

    private static void checkCMRAccesorMethod(ProblemsHolder holder, PsiMethod method, EjbMethodRole[] methodRoles) {
        boolean checkedOnce = false;
        boolean shouldBeAbstract = false;
        boolean conflict = false;
        block3: for (EjbMethodRole role : methodRoles) {
            switch (role.getType()) {
                case EJB_METHOD_ROLE_CMR_GETTER_IMPL: 
                case EJB_METHOD_ROLE_CMR_SETTER_IMPL: {
                    EntityBean ejb = (EntityBean)role.getEnterpriseBean();
                    boolean curShouldBeAbstract = EjbUtil.isCMP((EnterpriseBean)ejb, CmpVersion.CmpVersion_2_X);
                    if (checkedOnce && !conflict && shouldBeAbstract != curShouldBeAbstract) {
                        conflict = true;
                        continue block3;
                    }
                    if (checkedOnce) continue block3;
                    checkedOnce = true;
                    shouldBeAbstract = curShouldBeAbstract;
                    EjbHighlightUtil.checkCmrAccessorSignature(holder, method, role);
                }
            }
        }
        if (conflict) {
            holder.registerProblem((PsiElement)method.getModifierList(), EjbHighlightingBundle.message("method.should.be.both.abstract.and.not.abstract", method.getName()), new LocalQuickFix[0]);
        } else if (checkedOnce) {
            EjbHighlightUtil.checkMethodModifier(holder, method, "abstract", shouldBeAbstract);
        }
    }

    private static void checkClassImplementsCMPAccessors(ProblemsHolder holder, PsiClass aClass, EjbClassRole[] classRoles) {
        HashSet cmpFields = new HashSet();
        for (EjbClassRole role : classRoles) {
            EntityBean ejb;
            if (!(role.getEnterpriseBean() instanceof EntityBean) || EjbUtil.isCMP((EnterpriseBean)(ejb = (EntityBean)role.getEnterpriseBean()), CmpVersion.CmpVersion_1_X)) continue;
            cmpFields.addAll(ejb.getCmpFields());
        }
        for (CmpField cmpField : cmpFields) {
            PsiMethod setterTarget;
            PsiMethod getterTarget;
            PsiType getterType;
            String name = (String)cmpField.getFieldName().getValue();
            if (name == null) continue;
            PsiMethod getter = EjbUtil.findGetter(aClass, name, null, true);
            PsiMethod[] getterCandidates = PsiMethod.EMPTY_ARRAY;
            if (getter == null && (getterCandidates = aClass.findMethodsByName(JavaeeUtil.suggestGetterName((String)name), true)).length == 0) {
                LocalQuickFix[] localQuickFixArray;
                PsiMethod accessor = EjbUtil.getEjbCMPAccessorPrototype(cmpField, true);
                if (accessor != null) {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = QuickFixFactory.getInstance().createAddMethodFix(accessor, aClass);
                } else {
                    localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                }
                LocalQuickFix[] quickFixes = localQuickFixArray;
                holder.registerProblem((PsiElement)aClass, JavaeeHighlightingUtil.getClassDeclarationRange((PsiClass)aClass), EjbHighlightingBundle.message("cmp.field.getter.is.not.defined", name), quickFixes);
            }
            PsiMethod setter = EjbUtil.findSetter(aClass, name, null, true);
            PsiMethod[] setterCandidates = PsiMethod.EMPTY_ARRAY;
            if (setter == null && (setterCandidates = aClass.findMethodsByName(JavaeeUtil.suggestSetterName((String)name), true)).length == 0) {
                LocalQuickFix[] localQuickFixArray;
                PsiMethod accessor = EjbUtil.getEjbCMPAccessorPrototype(cmpField, false);
                if (accessor != null) {
                    LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray3;
                    localQuickFixArray3[0] = QuickFixFactory.getInstance().createAddMethodFix(accessor, aClass);
                } else {
                    localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                }
                LocalQuickFix[] quickFixes = localQuickFixArray;
                holder.registerProblem((PsiElement)aClass, JavaeeHighlightingUtil.getClassDeclarationRange((PsiClass)aClass), EjbHighlightingBundle.message("cmp.field.setter.is.not.defined", name), quickFixes);
            }
            PsiParameter[] setterParameters = setter == null ? null : setter.getParameterList().getParameters();
            PsiType setterType = setterParameters == null ? null : setterParameters[0].getType();
            PsiType psiType = getterType = getter == null ? null : getter.getReturnType();
            Object object = getter != null ? getter : (getterTarget = getterCandidates.length > 0 ? getterCandidates[0] : null);
            Object object2 = setter != null ? setter : (setterTarget = setterCandidates.length > 0 ? setterCandidates[0] : null);
            if (getterTarget != null && getterTarget.getContainingFile() == aClass.getContainingFile()) {
                if (setterType != null) {
                    EjbHighlightUtil.checkMethodReturns(holder, getterTarget, setterType);
                }
                EjbHighlightUtil.checkMethodParameters(holder, getterTarget, PsiType.EMPTY_ARRAY);
            }
            if (setterTarget == null || setterTarget.getContainingFile() != aClass.getContainingFile()) continue;
            if (getterType != null) {
                EjbHighlightUtil.checkMethodParameters(holder, setterTarget, new PsiType[]{getterType});
            }
            EjbHighlightUtil.checkMethodReturns(holder, setterTarget, (PsiType)PsiType.VOID);
        }
    }

    private static void checkClassImplementsCMRAccessors(ProblemsHolder holder, PsiClass aClass, EjbClassRole[] classRoles) {
        HashSet cmrFields = new HashSet();
        for (EjbClassRole role : classRoles) {
            EntityBean ejb;
            if (!(role.getEnterpriseBean() instanceof EntityBean) || EjbUtil.isCMP((EnterpriseBean)(ejb = (EntityBean)role.getEnterpriseBean()), CmpVersion.CmpVersion_1_X)) continue;
            cmrFields.addAll(ejb.getCmrFields());
        }
        for (CmrField cmrField : cmrFields) {
            LocalQuickFix[] localQuickFixArray;
            PsiMethod setter;
            String name = (String)cmrField.getCmrFieldName().getValue();
            if (name == null) continue;
            PsiType type = EjbUtil.findType(cmrField);
            PsiMethod getter = EjbUtil.findGetter(aClass, name, type, true);
            if (getter == null) {
                LocalQuickFix[] localQuickFixArray2;
                PsiMethod accessor = EjbUtil.getEjbCMRAccessorPrototype(cmrField, true, aClass);
                if (accessor != null) {
                    LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[1];
                    localQuickFixArray2 = localQuickFixArray3;
                    localQuickFixArray3[0] = QuickFixFactory.getInstance().createAddMethodFix(accessor, aClass);
                } else {
                    localQuickFixArray2 = LocalQuickFix.EMPTY_ARRAY;
                }
                LocalQuickFix[] quickFixes = localQuickFixArray2;
                holder.registerProblem((PsiElement)aClass, JavaeeHighlightingUtil.getClassDeclarationRange((PsiClass)aClass), EjbHighlightingBundle.message("cmr.field.getter.is.not.defined", name), quickFixes);
            }
            if ((setter = EjbUtil.findSetter(aClass, name, type, true)) != null) continue;
            PsiMethod accessor = EjbUtil.getEjbCMRAccessorPrototype(cmrField, false, aClass);
            if (accessor != null) {
                LocalQuickFix[] localQuickFixArray4 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray4;
                localQuickFixArray4[0] = QuickFixFactory.getInstance().createAddMethodFix(accessor, aClass);
            } else {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            }
            LocalQuickFix[] quickFixes = localQuickFixArray;
            holder.registerProblem((PsiElement)aClass, JavaeeHighlightingUtil.getClassDeclarationRange((PsiClass)aClass), EjbHighlightingBundle.message("cmr.field.setter.is.not.defined", name), quickFixes);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/inspections/EjbEntityClassInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/inspections/EjbEntityClassInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createJavaVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

