/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.inspections;

import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.constants.JavaeeCommonConstants;
import com.intellij.javaee.ejb.codeInsight.annotator.EjbHighlightingBundle;
import com.intellij.javaee.ejb.inspections.AbstractEjbInspection;
import com.intellij.javaee.ejb.inspections.EjbClassBasicInspection;
import com.intellij.javaee.ejb.inspections.EjbHighlightUtil;
import com.intellij.javaee.ejb.model.EjbWithHome;
import com.intellij.javaee.ejb.model.EnterpriseBean;
import com.intellij.javaee.ejb.model.EntityBean;
import com.intellij.javaee.ejb.model.MessageDrivenBean;
import com.intellij.javaee.ejb.model.SessionBean;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.ejb.utils.EjbUtil;
import com.intellij.javaee.ejb.utils.OldEjbRolesUtil;
import com.intellij.javaee.model.JavaeeModelElement;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class EjbClassWarningsInspection
extends AbstractEjbInspection {
    @Override
    protected boolean acceptClass(PsiClass psiClass) {
        return EjbClassWarningsInspection.getRoleTypes(OldEjbRolesUtil.getEjbRoles(psiClass)).contains(EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS);
    }

    @Override
    protected JavaElementVisitor createJavaVisitor(final @NotNull ProblemsHolder holder, boolean onTheFly) {
        if (holder == null) {
            EjbClassWarningsInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitClass(PsiClass aClass) {
                EjbClassRole[] classRoles = OldEjbRolesUtil.getEjbRoles(aClass);
                if (!EjbUtil.isTopLevelClass(aClass, EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS, classRoles)) {
                    return;
                }
                EjbClassWarningsInspection.checkClassExtends(holder, aClass, classRoles);
            }

            public void visitMethod(PsiMethod method) {
                EjbClassWarningsInspection.checkMethod(holder, method, OldEjbRolesUtil.getEjbRoles(method.getContainingClass()));
            }

            public void visitField(PsiField field) {
                EjbClassWarningsInspection.checkField(holder, field);
            }
        };
    }

    public static void checkMethod(ProblemsHolder holder, PsiMethod method, EjbClassRole[] classRoles) {
        EjbClassRole role;
        EjbClassRole[] ejbClassRoleArray = classRoles;
        int n = ejbClassRoleArray.length;
        for (int i = 0; !(i >= n || (role = ejbClassRoleArray[i]).getEnterpriseBean() != null && EjbUtil.isEjbVersion1x((JavaeeModelElement)role.getEnterpriseBean()) && EjbClassWarningsInspection.checkThrowsRemoteException(holder, method, role)); ++i) {
        }
    }

    private static boolean checkThrowsRemoteException(ProblemsHolder holder, PsiMethod method, EjbClassRole classRole) {
        return EjbClassBasicInspection.checkThrowsRemoteException(holder, method, classRole);
    }

    private static void checkField(ProblemsHolder holder, PsiField field) {
        if (field.hasModifierProperty("static") && !field.hasModifierProperty("final")) {
            holder.registerProblem((PsiElement)field, EjbHighlightingBundle.message("static.fields.only.recommended", new Object[0]), new LocalQuickFix[]{QuickFixFactory.getInstance().createModifierListFix((PsiModifierListOwner)field, "final", true, false)});
        }
    }

    private static void checkClassExtends(ProblemsHolder holder, PsiClass aClass, EjbClassRole[] classRole) {
        HashSet<String> shouldNotImplement = new HashSet<String>();
        JavaeeType javaeeType = JavaeeType.discover((PsiElement)aClass, (JavaeeClass)JavaeeCommonConstants.SESSION_BEAN_CLASS);
        for (EjbClassRole role : classRole) {
            EnterpriseBean ejb = role.getEnterpriseBean();
            if (ejb == null) continue;
            if (ejb instanceof SessionBean) {
                shouldNotImplement.add(JavaeeCommonConstants.ENTITY_BEAN_CLASS.fqn(javaeeType));
                shouldNotImplement.add(JavaeeCommonConstants.MESSAGE_DRIVEN_BEAN_CLASS.fqn(javaeeType));
            } else if (ejb instanceof EntityBean) {
                shouldNotImplement.add(JavaeeCommonConstants.SESSION_BEAN_CLASS.fqn(javaeeType));
                shouldNotImplement.add(JavaeeCommonConstants.MESSAGE_DRIVEN_BEAN_CLASS.fqn(javaeeType));
            } else if (ejb instanceof MessageDrivenBean) {
                shouldNotImplement.add(JavaeeCommonConstants.SESSION_BEAN_CLASS.fqn(javaeeType));
                shouldNotImplement.add(JavaeeCommonConstants.ENTITY_BEAN_CLASS.fqn(javaeeType));
            }
            if (!(ejb instanceof EjbWithHome)) continue;
            EjbWithHome ejbWithHome = (EjbWithHome)ejb;
            shouldNotImplement.add(ejbWithHome.getHome().getStringValue());
            shouldNotImplement.add(ejbWithHome.getLocalHome().getStringValue());
            shouldNotImplement.add(ejbWithHome.getRemote().getStringValue());
            shouldNotImplement.add(ejbWithHome.getLocal().getStringValue());
        }
        for (String interfaceName : shouldNotImplement) {
            if (StringUtil.isEmptyOrSpaces((String)interfaceName)) continue;
            EjbHighlightUtil.checkClassExtends(holder, aClass, interfaceName, false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/javaee/ejb/inspections/EjbClassWarningsInspection", "createJavaVisitor"));
    }
}

