/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.model.EnterpriseBean;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.ejb.utils.OldEjbRolesUtil;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEjbInspection
extends LocalInspectionTool {
    protected abstract JavaElementVisitor createJavaVisitor(@NotNull ProblemsHolder var1, boolean var2);

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            AbstractEjbInspection.$$$reportNull$$$0(0);
        }
        final JavaElementVisitor javaVisitor = this.createJavaVisitor(holder, isOnTheFly);
        return new PsiElementVisitor(){
            private Boolean myIsFileRelated = null;

            public void visitElement(@NotNull PsiElement element) {
                PsiClass psiClass;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (this.myIsFileRelated == null) {
                    this.myIsFileRelated = AbstractEjbInspection.this.isFileEjbRelated(element.getContainingFile());
                }
                if (!this.myIsFileRelated.booleanValue()) {
                    return;
                }
                Object object = element instanceof PsiClass ? (PsiClass)element : (psiClass = element instanceof PsiMember ? ((PsiMember)element).getContainingClass() : null);
                if (psiClass != null && !AbstractEjbInspection.this.acceptClass(psiClass)) {
                    return;
                }
                element.accept((PsiElementVisitor)javaVisitor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javaee/ejb/inspections/AbstractEjbInspection$1", "visitElement"));
            }
        };
    }

    protected boolean acceptClass(PsiClass psiClass) {
        return OldEjbRolesUtil.getEjbRoles(psiClass).length > 0;
    }

    private boolean isFileEjbRelated(PsiFile file) {
        if (JavaeeFacetUtil.getInstance().getJavaeeFacets(EjbFacet.ID, file.getProject()).isEmpty()) {
            return false;
        }
        if (!JamCommonUtil.isPlainJavaFile((PsiElement)file)) {
            return false;
        }
        for (PsiClass psiClass : ((PsiJavaFile)file).getClasses()) {
            if (!this.acceptClass(psiClass)) continue;
            return true;
        }
        return false;
    }

    protected static EnumSet<EjbClassRoleEnum> getRoleTypes(EjbClassRole[] classRoles) {
        EnumSet<EjbClassRoleEnum> roleTypes = EnumSet.noneOf(EjbClassRoleEnum.class);
        for (EjbClassRole role : classRoles) {
            roleTypes.add(role.getType());
        }
        return roleTypes;
    }

    protected static <T extends EnterpriseBean> boolean isOfType(Class<T> beanType, EjbClassRole[] classRoles) {
        for (EjbClassRole classRole : classRoles) {
            EnterpriseBean ejb = classRole.getEnterpriseBean();
            if (ejb == null || !beanType.isInstance(ejb)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/javaee/ejb/inspections/AbstractEjbInspection", "buildVisitor"));
    }
}

