/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.facet.EjbFacetConfiguration;
import com.intellij.javaee.ejb.facet.EjbFacetConfigurationImpl;
import com.intellij.javaee.ejb.facet.EjbFacetType;
import com.intellij.javaee.ejb.model.EjbDescriptorVersion;
import com.intellij.javaee.ejb.model.EjbRootElement;
import com.intellij.javaee.ejb.model.annotations.ejb.EjbRootElementImpl;
import com.intellij.javaee.ejb.model.merged.MergedEjbRootElement;
import com.intellij.javaee.ejb.model.xml.EjbJar;
import com.intellij.javaee.ejb.model.xml.converters.EjbRootDescriptor;
import com.intellij.javaee.ejb.utils.EjbUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetCommonPart;
import com.intellij.javaee.facet.JavaeeFacetEx;
import com.intellij.javaee.facet.JavaeeFacetListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileContainer;
import com.intellij.util.descriptors.ConfigFileMetaDataProvider;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EjbFacetImpl
extends EjbFacet
implements JavaeeFacetEx {
    private DomFileElement<EjbJar> myEjbModuleDescriptor;
    private EjbRootElementImpl myAnnotationsRootElement;
    private final JavaeeFacetCommonPart myCommonPart;

    public EjbFacetImpl(@NotNull EjbFacetType facetType, @NotNull Module module, String name, @NotNull EjbFacetConfiguration configuration, Facet underlyingFacet) {
        if (facetType == null) {
            EjbFacetImpl.$$$reportNull$$$0(0);
        }
        if (module == null) {
            EjbFacetImpl.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            EjbFacetImpl.$$$reportNull$$$0(2);
        }
        super((FacetType)facetType, module, name, (FacetConfiguration)configuration, underlyingFacet);
        this.myCommonPart = new JavaeeFacetCommonPart((JavaeeFacet)this, (ConfigFileMetaDataProvider)facetType.getDescriptorsMetaDataProvider(), configuration.getDescriptorsConfiguration());
        Disposer.register((Disposable)this, (Disposable)this.myCommonPart);
    }

    public ConfigFileContainer getDescriptorsContainer() {
        return this.myCommonPart.getDescriptorsContainer();
    }

    public JavaeeFacetCommonPart getCommonPart() {
        return this.myCommonPart;
    }

    public void onFacetChanged() {
    }

    public ModificationTracker getModificationTracker() {
        return this.myCommonPart.getModificationTracker();
    }

    public void addFacetListener(JavaeeFacetListener listener) {
        this.myCommonPart.addListener(listener);
    }

    public void removeFacetListener(JavaeeFacetListener listener) {
        this.myCommonPart.removeListener(listener);
    }

    @Nullable
    public final EjbJar getXmlRoot() {
        this.refreshModelRoot();
        return this.myEjbModuleDescriptor == null ? null : (EjbJar)this.myEjbModuleDescriptor.getRootElement();
    }

    @Nullable
    public EjbRootElement getAnnotationRoot() {
        this.refreshModelRoot();
        return this.myAnnotationsRootElement;
    }

    private void refreshModelRoot() {
        ConfigFile descriptor = this.getEjbJarDescriptor();
        XmlFile xmlFile = descriptor == null ? null : descriptor.getXmlFile();
        EjbJar xmlRoot = (EjbJar)JamCommonUtil.getRootElement((PsiFile)xmlFile, EjbJar.class);
        boolean annoEnabled = EjbFacetImpl.shouldCreateAnnotationRoot(xmlRoot);
        if (this.myAnnotationsRootElement == null && annoEnabled) {
            this.myAnnotationsRootElement = new EjbRootElementImpl(this);
        } else if (this.myAnnotationsRootElement != null && !annoEnabled) {
            this.myAnnotationsRootElement = null;
        }
        this.myEjbModuleDescriptor = xmlRoot == null ? null : (DomFileElement)xmlRoot.getParent();
    }

    private static boolean shouldCreateAnnotationRoot(EjbJar ejbJar) {
        EjbDescriptorVersion ejbVersion;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        return ejbJar == null || !ejbJar.isValid() || EjbDescriptorVersion.EJB_VERSION_3_0.compareTo((Enum)(ejbVersion = EjbUtil.getEjbJarVersion(DomService.getInstance().getContainingFile((DomElement)ejbJar)))) <= 0 && !Boolean.TRUE.equals(ejbJar.getMetadataComplete().getValue());
    }

    public void initFacet() {
        this.myCommonPart.initFacet();
        JavaeeUtil.installDomAndJamListeners((Facet)this, (ConfigFileContainer)this.getCommonPart().getDescriptorsContainer());
    }

    @NotNull
    public final EjbRootElement getMergedRoot() {
        this.refreshModelRoot();
        if (this.myEjbModuleDescriptor != null) {
            EjbJar ejbJar = (EjbJar)this.myEjbModuleDescriptor.getRootElement();
            if (this.myAnnotationsRootElement == null || Boolean.TRUE.equals(ejbJar.getMetadataComplete().getValue())) {
                EjbJar ejbJar2 = ejbJar;
                if (ejbJar2 == null) {
                    EjbFacetImpl.$$$reportNull$$$0(3);
                }
                return ejbJar2;
            }
            return new MergedEjbRootElement(this, new EjbRootElement[]{this.myAnnotationsRootElement, ejbJar});
        }
        if (this.myAnnotationsRootElement != null) {
            EjbRootElementImpl ejbRootElementImpl = this.myAnnotationsRootElement;
            if (ejbRootElementImpl == null) {
                EjbFacetImpl.$$$reportNull$$$0(4);
            }
            return ejbRootElementImpl;
        }
        return new MergedEjbRootElement(this, new EjbRootElement[0]);
    }

    @Nullable
    public ConfigFile getEjbJarDescriptor() {
        return this.getDescriptorsContainer().getConfigFile(EjbRootDescriptor.EJB_JAR_META_DATA);
    }

    public Collection<VirtualFile> getSourceRoots() {
        ArrayList<VirtualFile> list = new ArrayList<VirtualFile>();
        VirtualFileManager fileManager = VirtualFileManager.getInstance();
        for (String url : this.getConfigurationImpl().getSourceRoots()) {
            VirtualFile file = fileManager.findFileByUrl(url);
            if (file == null) continue;
            list.add(file);
        }
        return list;
    }

    @NotNull
    public Collection<VirtualFile> getFacetRoots() {
        Collection roots = this.myCommonPart.getDescriptors();
        roots.addAll(this.getSourceRoots());
        Collection collection = roots;
        if (collection == null) {
            EjbFacetImpl.$$$reportNull$$$0(5);
        }
        return collection;
    }

    public List<String> getEjbSourceRootUrls() {
        return Collections.unmodifiableList(this.getConfigurationImpl().getSourceRoots());
    }

    public void setEjbSourceRoots(@NonNls String @NotNull [] urls) {
        if (urls == null) {
            EjbFacetImpl.$$$reportNull$$$0(6);
        }
        this.getConfigurationImpl().setSourceRoots(new ArrayList<String>(Arrays.asList(urls)));
        JavaeeUtil.fireFacetChanged((JavaeeFacet)this);
    }

    public String @NotNull [] getEjbSourceRoots() {
        List<String> roots = this.getConfigurationImpl().getSourceRoots();
        String[] stringArray = ArrayUtilRt.toStringArray(roots);
        if (stringArray == null) {
            EjbFacetImpl.$$$reportNull$$$0(7);
        }
        return stringArray;
    }

    private EjbFacetConfigurationImpl getConfigurationImpl() {
        return (EjbFacetConfigurationImpl)this.getConfiguration();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/facet/EjbFacetImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/facet/EjbFacetImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergedRoot";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetRoots";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEjbSourceRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setEjbSourceRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

