/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.extensions;

import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefGraphAnnotatorEx;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.javaee.ejb.EjbHelper;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.ejb.role.EjbDeclMethodRole;
import com.intellij.javaee.ejb.role.EjbImplMethodRole;
import com.intellij.javaee.ejb.role.EjbMethodRole;
import com.intellij.javaee.ejb.role.EjbMethodRoleEnum;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;

public class EjbGraphAnnotator
extends RefGraphAnnotatorEx {
    private static final Logger LOG = Logger.getInstance(EjbGraphAnnotator.class);
    private static long IS_EJB_DECLARATION_MASK;
    private static long IS_EJB_IMPLEMENTATION_MASK;
    private static long IS_EJB_MASK;

    public void initialize(RefManager refManager) {
        IS_EJB_MASK = refManager.getLastUsedMask();
        IS_EJB_DECLARATION_MASK = refManager.getLastUsedMask();
        IS_EJB_IMPLEMENTATION_MASK = refManager.getLastUsedMask();
    }

    public void onInitialize(RefElement refElement) {
        EjbClassRole role;
        RefMethodImpl refMethod;
        PsiMethod method;
        if (refElement instanceof RefMethod && (method = (PsiMethod)(refMethod = (RefMethodImpl)refElement).getElement()) != null && (role = EjbHelper.getEjbHelper().getEjbRole(method.getContainingClass())) != null) {
            PsiClassType[] throwsList;
            for (PsiClassType type : throwsList = method.getThrowsList().getReferencedTypes()) {
                String qualifiedName = type.getCanonicalText();
                if (!EjbGraphAnnotator.isEjbException(qualifiedName)) continue;
                refMethod.removeUnThrownExceptions(type.resolve());
            }
        }
    }

    public void onReferencesBuild(RefElement refElement) {
        block12: {
            EjbClassRole role;
            RefClassImpl refClass;
            PsiClass psiClass;
            block11: {
                EjbMethodRoleEnum roleType;
                EjbMethodRole role2;
                PsiMethod method;
                RefMethodImpl refMethod;
                block13: {
                    if (!(refElement instanceof RefMethod)) break block11;
                    refMethod = (RefMethodImpl)refElement;
                    PsiModifierListOwner modifierListOwner = refMethod.getElement();
                    if (!(modifierListOwner instanceof PsiMethod)) break block12;
                    method = (PsiMethod)modifierListOwner;
                    EjbHelper helper = EjbHelper.getEjbHelper();
                    EjbClassRole classRole = helper.getEjbRole(method.getContainingClass());
                    if (classRole == null || (role2 = helper.getEjbRole(method)) == null) break block12;
                    roleType = role2.getType();
                    if (!(role2 instanceof EjbDeclMethodRole)) break block13;
                    EjbGraphAnnotator.setEjbDeclaration(refMethod, true);
                    if (roleType != EjbMethodRoleEnum.EJB_METHOD_ROLE_FINDER_DECL && roleType != EjbMethodRoleEnum.EJB_METHOD_ROLE_CMP_SETTER_DECL && roleType != EjbMethodRoleEnum.EJB_METHOD_ROLE_CMR_SETTER_DECL && roleType != EjbMethodRoleEnum.EJB_METHOD_ROLE_CMP_GETTER_DECL && roleType != EjbMethodRoleEnum.EJB_METHOD_ROLE_CMR_GETTER_DECL) break block12;
                    for (RefParameter refParameter : refMethod.getParameters()) {
                        refParameter.parameterReferenced(false);
                        refParameter.parameterReferenced(true);
                    }
                    break block12;
                }
                if (!(role2 instanceof EjbImplMethodRole)) break block12;
                EjbGraphAnnotator.setEjbImplementation(refMethod, true);
                PsiMethod[] declarations = ((EjbImplMethodRole)role2).findAllDeclarations();
                if (declarations.length != 0) {
                    for (PsiMethod psiMethod : declarations) {
                        if (refMethod.getRefManager().belongsToScope((PsiElement)psiMethod)) {
                            RefMethodImpl refDeclaration = (RefMethodImpl)refMethod.getRefManager().getReference((PsiElement)psiMethod);
                            if (refDeclaration != null) {
                                if (psiMethod == method) continue;
                                refMethod.addSuperMethod(refDeclaration);
                                refDeclaration.markExtended(refMethod);
                                continue;
                            }
                            refMethod.setLibraryOverride(true);
                            continue;
                        }
                        refMethod.setLibraryOverride(true);
                    }
                }
                if (roleType == EjbMethodRoleEnum.EJB_METHOD_ROLE_CMP_GETTER_IMPL || roleType == EjbMethodRoleEnum.EJB_METHOD_ROLE_CMP_SETTER_IMPL || roleType == EjbMethodRoleEnum.EJB_METHOD_ROLE_CMR_GETTER_IMPL || roleType == EjbMethodRoleEnum.EJB_METHOD_ROLE_CMR_SETTER_IMPL || roleType == EjbMethodRoleEnum.EJB_METHOD_ROLE_CREATE_IMPL) {
                    refMethod.setBodyEmpty(false);
                }
                if (roleType == EjbMethodRoleEnum.EJB_METHOD_ROLE_CMP_GETTER_IMPL || roleType == EjbMethodRoleEnum.EJB_METHOD_ROLE_CMP_SETTER_IMPL || roleType == EjbMethodRoleEnum.EJB_METHOD_ROLE_CMR_GETTER_IMPL || roleType == EjbMethodRoleEnum.EJB_METHOD_ROLE_CMR_SETTER_IMPL || roleType == EjbMethodRoleEnum.EJB_METHOD_ROLE_FINDER_IMPL || roleType == EjbMethodRoleEnum.EJB_METHOD_ROLE_SELECTOR_IMPL) {
                    for (PsiMethod psiMethod : refMethod.getParameters()) {
                        psiMethod.parameterReferenced(false);
                        psiMethod.parameterReferenced(true);
                    }
                }
                break block12;
            }
            if (refElement instanceof RefClass && (psiClass = (refClass = (RefClassImpl)refElement).getElement()) != null && (role = EjbHelper.getEjbHelper().getEjbRole(psiClass)) != null) {
                EjbGraphAnnotator.setEjb(refClass, true);
                if (role.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_HOME_INTERFACE || role.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_REMOTE_INTERFACE) {
                    PsiClassType remoteExceptionType = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory().createTypeByFQClassName("java.rmi.RemoteException", psiClass.getResolveScope());
                    for (PsiMethod psiMethod : psiClass.getAllMethods()) {
                        RefMethodImpl refMethod;
                        RefManagerImpl refManager = refClass.getRefManager();
                        if (!refManager.belongsToScope((PsiElement)psiMethod) || (refMethod = (RefMethodImpl)refManager.getReference((PsiElement)psiMethod)) == null) continue;
                        refMethod.updateThrowsList(remoteExceptionType);
                    }
                }
            }
        }
    }

    private static void setEjbDeclaration(RefMethodImpl refMethod, boolean ejbDeclaration) {
        refMethod.setFlag(ejbDeclaration, IS_EJB_DECLARATION_MASK);
    }

    private static void setEjbImplementation(RefMethodImpl refMethod, boolean ejbImplementation) {
        refMethod.setFlag(ejbImplementation, IS_EJB_IMPLEMENTATION_MASK);
    }

    private static void setEjb(RefClassImpl refClass, boolean ejb) {
        refClass.setFlag(ejb, IS_EJB_MASK);
    }

    public static boolean isEjb(RefClass refClass) {
        return ((RefClassImpl)refClass).checkFlag(IS_EJB_MASK);
    }

    public static boolean isEjbImplementation(RefMethod refMethod) {
        LOG.assertTrue(IS_EJB_DECLARATION_MASK > 0L, (Object)"not initialized ejb mask");
        return ((RefMethodImpl)refMethod).checkFlag(IS_EJB_IMPLEMENTATION_MASK);
    }

    public static boolean isEjbDeclaration(RefMethod refMethod) {
        LOG.assertTrue(IS_EJB_DECLARATION_MASK > 0L, (Object)"not initialized ejb mask");
        return ((RefMethodImpl)refMethod).checkFlag(IS_EJB_DECLARATION_MASK);
    }

    private static boolean isEjbException(String qualifiedName) {
        return "javax.ejb.CreateException".equals(qualifiedName) || "java.rmi.RemoteException".equals(qualifiedName) || "javax.ejb.FinderException".equals(qualifiedName) || "javax.ejb.RemoveException".equals(qualifiedName);
    }
}

