/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.codeInsight.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.model.EjbDescriptorVersion;
import com.intellij.javaee.ejb.module.view.ejb.InterceptorBindingsDialog;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.ejb.utils.EjbUtil;
import com.intellij.javaee.ejb.utils.OldEjbRolesUtil;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EJBInterceptorBindingAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            EJBInterceptorBindingAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            EJBInterceptorBindingAction.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiWhiteSpace) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        if (!(file instanceof PsiJavaFile) || file.getLanguage() != JavaLanguage.INSTANCE) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiClass targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (targetClass == null || !targetClass.isValid() || targetClass.getQualifiedName() == null) {
            return false;
        }
        if (!HighlightNamesUtil.getClassDeclarationTextRange((PsiClass)targetClass).containsRange(offset, offset + 1)) {
            return false;
        }
        if (targetClass.getDocComment() != null && targetClass.getDocComment().getTextRange().containsRange(offset, offset + 1)) {
            return false;
        }
        if (PsiTreeUtil.getChildOfType((PsiElement)targetClass, PsiErrorElement.class) != null) {
            return false;
        }
        String text = EJBInterceptorBindingAction.getExplanation(targetClass);
        if (text != null) {
            this.setText(text);
            return true;
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.edit.interceptor.binding.family", (Object[])new Object[0]);
        if (string == null) {
            EJBInterceptorBindingAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nls
    public static String getExplanation(PsiClass member) {
        EjbFacet ejbFacet = EjbUtil.getEjbFacet((PsiElement)member);
        if (ejbFacet == null || EjbDescriptorVersion.EJB_VERSION_3_0.compareTo((Enum)EjbUtil.getVersion(ejbFacet)) > 0) {
            return null;
        }
        boolean good = false;
        for (EjbClassRole role : OldEjbRolesUtil.getEjbRoles(member)) {
            if (role.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_INTERCEPTOR_CLASS || !member.equals(role.getInterceptor().getInterceptorClass().getValue())) continue;
            good = true;
            break;
        }
        if (good) {
            return CodeInsightBundle.message((String)"intention.edit.interceptor.binding.text", (Object[])new Object[]{member.getName()});
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            EJBInterceptorBindingAction.$$$reportNull$$$0(3);
        }
        if (element == null) {
            EJBInterceptorBindingAction.$$$reportNull$$$0(4);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiClass targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        EjbFacet ejbFacet = EjbUtil.getEjbFacet((PsiElement)targetClass);
        InterceptorBindingsDialog dialog = new InterceptorBindingsDialog(project, targetClass.getQualifiedName(), ejbFacet);
        dialog.show();
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/codeInsight/impl/EJBInterceptorBindingAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/codeInsight/impl/EJBInterceptorBindingAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

