/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.codeInsight.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.ClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.CreateClassDialog;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.ide.IdeBundle;
import com.intellij.javaee.constants.JavaeeAnnotationConstants;
import com.intellij.javaee.ejb.codeInsight.generation.actions.GenerateInterceptorMethods;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.model.EjbCommonModelUtil;
import com.intellij.javaee.ejb.model.EjbDescriptorVersion;
import com.intellij.javaee.ejb.model.EnterpriseBean;
import com.intellij.javaee.ejb.model.Interceptor;
import com.intellij.javaee.ejb.module.view.ejb.actions.CreateInterceptorAction;
import com.intellij.javaee.ejb.resources.EjbBundle;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.ejb.role.EjbMethodRole;
import com.intellij.javaee.ejb.role.EjbMethodRoleEnum;
import com.intellij.javaee.ejb.utils.EjbUtil;
import com.intellij.javaee.ejb.utils.OldEjbRolesUtil;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EJBAddInterceptorAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)EJBAddInterceptorAction.class.getName());

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiMethod docCommentOwner;
        if (project == null) {
            EJBAddInterceptorAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            EJBAddInterceptorAction.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiWhiteSpace) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        if (!(file instanceof PsiJavaFile) || file.getLanguage() != JavaLanguage.INSTANCE) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiMethod targetMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        if (targetMethod == null) {
            PsiClass targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            if (targetClass == null || !targetClass.isValid() || targetClass.getQualifiedName() == null) {
                return false;
            }
            if (!HighlightNamesUtil.getClassDeclarationTextRange((PsiClass)targetClass).containsRange(offset, offset + 1)) {
                return false;
            }
            docCommentOwner = targetClass;
        } else {
            if (!targetMethod.isValid()) {
                return false;
            }
            if (!HighlightNamesUtil.getMethodDeclarationTextRange((PsiMethod)targetMethod).containsRange(offset, offset + 1)) {
                return false;
            }
            docCommentOwner = targetMethod;
        }
        if (PsiTreeUtil.getChildOfType((PsiElement)docCommentOwner, PsiErrorElement.class) != null) {
            return false;
        }
        if (docCommentOwner.getDocComment() != null && docCommentOwner.getDocComment().getTextRange().containsRange(offset, offset + 1)) {
            return false;
        }
        String text = EJBAddInterceptorAction.getExplanation((PsiMember)docCommentOwner);
        if (text != null) {
            this.setText(text);
            return true;
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.intercept.ejb.method.or.class.family", (Object[])new Object[0]);
        if (string == null) {
            EJBAddInterceptorAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    @Nls
    public static String getExplanation(PsiMember member) {
        EjbFacet ejbFacet = EjbUtil.getEjbFacet((PsiElement)member);
        if (ejbFacet == null || EjbDescriptorVersion.EJB_VERSION_3_0.compareTo((Enum)EjbUtil.getVersion(ejbFacet)) > 0) {
            return null;
        }
        boolean good = false;
        if (member instanceof PsiClass) {
            for (EjbClassRole role : OldEjbRolesUtil.getEjbRoles((PsiClass)member)) {
                if (role.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS) continue;
                good = true;
            }
        } else if (member instanceof PsiMethod) {
            for (EjbMethodRole role : OldEjbRolesUtil.getEjbRoles((PsiMethod)member)) {
                if (role.getType() != EjbMethodRoleEnum.EJB_METHOD_ROLE_BUSINESS_METHOD_IMPL || !EjbUtil.isInheritedFromBusinessInterface((PsiMethod)member, EjbCommonModelUtil.getEjbClasses((EnterpriseBean)role.getEnterpriseBean(), (boolean)false, (boolean)false, (boolean)true))) continue;
                good = true;
            }
        }
        if (good) {
            if (member instanceof PsiClass) {
                return CodeInsightBundle.message((String)"intention.intercept.ejb.method.or.class.class.text", (Object[])new Object[]{member.getName()});
            }
            return CodeInsightBundle.message((String)"intention.intercept.ejb.method.or.class.method.text", (Object[])new Object[]{member.getName()});
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            EJBAddInterceptorAction.$$$reportNull$$$0(3);
        }
        if (element == null) {
            EJBAddInterceptorAction.$$$reportNull$$$0(4);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
            return;
        }
        this.generateInterceptorAnnotation(project, editor, element.getContainingFile());
    }

    private void generateInterceptorAnnotation(final Project project, Editor editor, final PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        PsiMethod member = method != null ? method : (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        LOG.assertTrue(member != null);
        PsiAnnotation psiAnnotationCur = member.getModifierList().findAnnotation(JavaeeAnnotationConstants.INTERCEPTORS_ANNO.fqn((PsiElement)file));
        List list = AnnotationModelUtil.getPsiClassArrayValue((PsiAnnotation)psiAnnotationCur, (String)"value");
        HashSet<PsiClass> excludedClasses = new HashSet<PsiClass>();
        for (AnnotationGenericValue value : list) {
            excludedClasses.add((PsiClass)value.getValue());
        }
        EjbFacet ejbFacet = EjbUtil.getEjbFacet((PsiElement)member);
        HashSet<PsiClass> interceptorClasses = new HashSet<PsiClass>();
        for (Interceptor interceptor : ejbFacet.getMergedRoot().getInterceptors().getInterceptors()) {
            PsiClass aClass = (PsiClass)interceptor.getInterceptorClass().getValue();
            if (aClass == null || excludedClasses.contains(aClass)) continue;
            interceptorClasses.add(aClass);
        }
        String previousSingleValue = null;
        if (psiAnnotationCur != null && psiAnnotationCur.isValid()) {
            PsiAnnotationMemberValue annotationMemberValue = psiAnnotationCur.findAttributeValue("value");
            boolean deleteCurrentAnnotation = false;
            if (annotationMemberValue instanceof PsiArrayInitializerMemberValue) {
                PsiArrayInitializerMemberValue psiArrayInitializerMemberValue = (PsiArrayInitializerMemberValue)annotationMemberValue;
                PsiAnnotationMemberValue[] memberValues = psiArrayInitializerMemberValue.getInitializers();
                if (memberValues.length != 0) {
                    editor.getCaretModel().moveToOffset(memberValues[memberValues.length - 1].getTextRange().getEndOffset());
                } else {
                    deleteCurrentAnnotation = true;
                }
            } else if (annotationMemberValue != null) {
                previousSingleValue = annotationMemberValue.getText();
                deleteCurrentAnnotation = true;
            } else {
                deleteCurrentAnnotation = true;
            }
            if (deleteCurrentAnnotation) {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    try {
                        psiAnnotationCur.delete();
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                });
            }
        }
        ConstantNode classExpression = new ConstantNode((Result)(interceptorClasses.isEmpty() ? null : new TextResult(((PsiClass)interceptorClasses.iterator().next()).getQualifiedName()))).withLookupItems((Collection)ContainerUtil.map(interceptorClasses, s -> JavaClassNameCompletionContributor.createClassLookupItem((PsiClass)s, (boolean)true)));
        Template template = TemplateManager.getInstance((Project)project).createTemplate("", "");
        if (psiAnnotationCur != null && psiAnnotationCur.isValid()) {
            template.addTextSegment(", ");
            template.addVariable("class", (Expression)classExpression, (Expression)classExpression, true);
            template.addTextSegment(".class");
        } else {
            editor.getCaretModel().moveToOffset(member.getModifierList().getTextOffset());
            template.addTextSegment("@" + JavaeeAnnotationConstants.INTERCEPTORS_ANNO + "({");
            if (previousSingleValue != null) {
                template.addTextSegment(previousSingleValue + ", ");
            }
            template.addVariable("class", (Expression)classExpression, (Expression)classExpression, true);
            template.addTextSegment(".class})\n");
        }
        TemplateState templateState = TemplateManager.getInstance((Project)project).runTemplate(editor, template);
        templateState.addTemplateStateListener((TemplateEditingListener)new TemplateEditingAdapter(){

            public void beforeTemplateFinished(@NotNull TemplateState state, Template template) {
                TextResult textResult;
                if (state == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((textResult = state.getVariableValue("class")).getText().length() > 0) {
                    TextRange textRange = state.getVariableRange("class");
                    PsiElement psiElement = file.findElementAt(textRange.getStartOffset());
                    if (psiElement == null) {
                        return;
                    }
                    PsiClassObjectAccessExpression classObjectAccessExpression = (PsiClassObjectAccessExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClassObjectAccessExpression.class);
                    if (classObjectAccessExpression == null) {
                        return;
                    }
                    PsiClassType classType = (PsiClassType)classObjectAccessExpression.getOperand().getType();
                    PsiClass psiClass = EJBAddInterceptorAction.this.ensureInterceptorClassExists(project, file, classType.getCanonicalText());
                    if (psiClass != null && !classType.getCanonicalText().equals(psiClass.getQualifiedName())) {
                        try {
                            PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory();
                            classObjectAccessExpression.getOperand().replace((PsiElement)psiElementFactory.createTypeElement((PsiType)psiElementFactory.createType(psiClass)));
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/javaee/ejb/codeInsight/impl/EJBAddInterceptorAction$1", "beforeTemplateFinished"));
            }
        });
    }

    @Nullable
    private PsiClass ensureInterceptorClassExists(Project project, PsiFile file, String className) {
        String targetPackageName;
        if (className == null) {
            return null;
        }
        PsiClass psiTargetClass = JavaPsiFacade.getInstance((Project)file.getProject()).findClass(className, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)ModuleUtilCore.findModuleForPsiElement((PsiElement)file)));
        if (psiTargetClass != null) {
            return psiTargetClass;
        }
        String shortClassName = PsiNameHelper.getShortClassName((String)className);
        if (shortClassName.length() < className.length()) {
            targetPackageName = className.substring(0, className.lastIndexOf(shortClassName) - 1);
        } else {
            PsiDirectory sourceDir = file.getContainingDirectory();
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(sourceDir);
            targetPackageName = aPackage != null ? aPackage.getQualifiedName() : "";
        }
        CreateClassDialog dialog = new CreateClassDialog(project, EjbBundle.message((String)"ejb.dialog.title.new.typename", (Object[])new Object[]{EjbBundle.message((String)"ejb.interceptor.type", (Object[])new Object[0])}), shortClassName, targetPackageName, (ClassKind)CreateClassKind.CLASS, false, ModuleUtilCore.findModuleForPsiElement((PsiElement)file));
        if (!dialog.showAndGet()) {
            return null;
        }
        PsiDirectory targetDirectory = dialog.getTargetDirectory();
        if (targetDirectory == null) {
            return null;
        }
        try {
            PsiClass targetClass = (PsiClass)WriteAction.compute(() -> {
                IdeDocumentHistory.getInstance((Project)project).includeCurrentPlaceAsChangePlace();
                return JavaDirectoryService.getInstance().createClass(targetDirectory, dialog.getClassName());
            });
            EjbFacet ejbFacet = EjbUtil.getEjbFacet((PsiElement)file);
            CreateInterceptorAction.createInterceptorMetadata(ejbFacet.getXmlRoot(), targetClass.getQualifiedName());
            Editor editor1 = CodeInsightUtil.positionCursorAtLBrace((Project)project, (PsiFile)targetClass.getContainingFile(), (PsiClass)targetClass);
            if (editor1 != null) {
                new GenerateInterceptorMethods().actionPerformedImpl(project, editor1);
            }
            return targetClass;
        }
        catch (IncorrectOperationException e) {
            Messages.showErrorDialog((Project)project, (String)IdeBundle.message((String)"title.cannot.create.class", (Object[])new Object[0]), (String)StringUtil.getMessage((Throwable)e));
            return null;
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/codeInsight/impl/EJBAddInterceptorAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/codeInsight/impl/EJBAddInterceptorAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

