/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.codeInsight.generation;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.GenerateMembersHandlerBase;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.javaee.constants.JavaeeCommonConstants;
import com.intellij.javaee.ejb.model.InterceptorMethodType;
import com.intellij.javaee.ejb.resources.EjbBundle;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.ejb.utils.EjbUtil;
import com.intellij.javaee.ejb.utils.OldEjbRolesUtil;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;

public class GenerateInterceptorMethodsHandler
extends GenerateMembersHandlerBase {
    public GenerateInterceptorMethodsHandler() {
        super(EjbBundle.message((String)"title.choose.interceptor.method.types", (Object[])new Object[0]));
    }

    protected ClassMember[] getAllOriginalMembers(PsiClass aClass) {
        boolean ejbClassMode = false;
        boolean standardNames = false;
        for (EjbClassRole role : OldEjbRolesUtil.getEjbRoles(aClass)) {
            if (role.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS) continue;
            ejbClassMode = true;
            standardNames = EjbUtil.implementsStandardEjbInterface(role.getEnterpriseBean());
        }
        PsiClass copy = (PsiClass)aClass.copy();
        ArrayList result = new ArrayList();
        for (InterceptorMethodType methodType : InterceptorMethodType.values()) {
            GenerateInterceptorMethodsHandler.addInterceptorMethod(result, copy, methodType, !ejbClassMode, standardNames);
        }
        return result.toArray(ClassMember.EMPTY_ARRAY);
    }

    public static void addInterceptorMethod(ArrayList<? super PsiMethodMember> result, PsiClass aClass, InterceptorMethodType methodType, boolean separateClass, boolean standardNames) {
        block4: {
            JavaeeType javaeeType = JavaeeType.discover((PsiElement)aClass, (JavaeeClass)JavaeeCommonConstants.INTERCEPTOR_INVOCATION_CONTEXT_CLASS);
            for (PsiMethod psiMethod : aClass.getMethods()) {
                String annotation = methodType.getMethodAnnotation(javaeeType);
                if (annotation == null) {
                    return;
                }
                PsiAnnotation psiAnnotation = psiMethod.getModifierList().findAnnotation(annotation);
                if (psiAnnotation == null) continue;
                return;
            }
            PsiMethod psiMethod = GenerateInterceptorMethodsHandler.generateInterceptorMethod(aClass, methodType, separateClass, standardNames);
            try {
                result.add((PsiMethodMember)new PsiMethodMember((PsiMethod)aClass.add((PsiElement)psiMethod)));
            }
            catch (IncorrectOperationException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)e);
            }
        }
    }

    private static PsiMethod generateInterceptorMethod(PsiClass aClass, InterceptorMethodType methodType, boolean separateClass, boolean standardNames) {
        String methodName;
        String annotationName = methodType.getMethodAnnotation(JavaeeType.discover((PsiElement)aClass, (JavaeeClass)JavaeeCommonConstants.INTERCEPTOR_INVOCATION_CONTEXT_CLASS));
        String parameterClassName = JavaeeCommonConstants.INTERCEPTOR_INVOCATION_CONTEXT_CLASS.fqn((PsiElement)aClass);
        String string = methodName = standardNames ? methodType.getMethodStandardName() : StringUtil.decapitalize((String)methodType.getTypeName());
        String methodText = methodType == InterceptorMethodType.AROUND_INVOKE ? "@" + annotationName + " public Object " + methodName + "(" + parameterClassName + " context) throws Exception { return context.proceed(); }" : (separateClass ? "@" + annotationName + " void " + methodName + "(" + parameterClassName + " context) { try { context.proceed(); } catch (Exception e) { e.printStackTrace(); } }" : "@" + annotationName + " void " + methodName + "() { }");
        try {
            return JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createMethodFromText(methodText, null);
        }
        catch (IncorrectOperationException e) {
            assert (false) : e;
            return null;
        }
    }

    protected GenerationInfo[] generateMemberPrototypes(PsiClass aClass, ClassMember originalMember) throws IncorrectOperationException {
        return new GenerationInfo[]{new PsiGenerationInfo((PsiMember)((PsiMethod)((PsiMethodMember)originalMember).getElement()))};
    }
}

