/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.codeInsight.generation;

import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.generation.EncapsulatableClassMember;
import com.intellij.codeInsight.generation.MemberChooserObject;
import com.intellij.codeInsight.generation.MemberChooserObjectBase;
import com.intellij.codeInsight.generation.TemplateGenerationInfo;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.ide.IconUtilEx;
import com.intellij.javaee.ejb.codeInsight.generation.EjbMemberChooserObjectBase;
import com.intellij.javaee.ejb.model.CmpField;
import com.intellij.javaee.ejb.model.EnterpriseBean;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.Nullable;

public class CmpFieldClassMember
extends MemberChooserObjectBase
implements EncapsulatableClassMember {
    private final PsiClass myPsiClass;
    private final CmpField myField;

    public CmpFieldClassMember(PsiClass psiClass, CmpField field) {
        super(CmpFieldClassMember.getFieldNameValue(field), IconUtilEx.getIcon((Object)field, (int)0, null));
        this.myPsiClass = psiClass;
        this.myField = field;
    }

    @Nullable
    @NlsSafe
    protected static String getFieldNameValue(CmpField field) {
        return (String)field.getFieldName().getValue();
    }

    public MemberChooserObject getParentNodeDelegate() {
        return new EjbMemberChooserObjectBase((EnterpriseBean)this.myField.getEntityBean());
    }

    @Nullable
    public TemplateGenerationInfo generateGetter() throws IncorrectOperationException {
        PsiClassType objectType = this.getJavaLangObject();
        String methodName = PropertyUtilBase.suggestGetterName((String)CmpFieldClassMember.getFieldNameValue(this.myField), (PsiType)objectType);
        for (PsiMethod method : this.myPsiClass.getMethods()) {
            if (!method.getName().equals(methodName) || method.getParameterList().getParameters().length != 0) continue;
            return null;
        }
        PsiMethod method = this.createAbstractMethod(methodName, (PsiType)objectType);
        return new TemplateGenerationInfo(method, CmpFieldClassMember.createExpression(method)){

            protected PsiTypeElement getTemplateElement(PsiMethod method) {
                return method.getReturnTypeElement();
            }
        };
    }

    private static Expression createExpression(PsiMethod method) {
        PsiClass stringClass;
        LinkedHashSet<Object> set = new LinkedHashSet<Object>();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)method.getProject());
        PsiClass objectClass = JavaPsiFacade.getInstance((Project)method.getProject()).findClass("java.lang.Object", scope);
        if (objectClass != null) {
            set.add(JavaClassNameCompletionContributor.createClassLookupItem((PsiClass)objectClass, (boolean)true));
        }
        if ((stringClass = JavaPsiFacade.getInstance((Project)method.getProject()).findClass("java.lang.String", scope)) != null) {
            set.add(JavaClassNameCompletionContributor.createClassLookupItem((PsiClass)stringClass, (boolean)true));
        }
        set.add(PsiTypeLookupItem.createLookupItem((PsiType)PsiType.BOOLEAN, null));
        set.add(PsiTypeLookupItem.createLookupItem((PsiType)PsiType.BYTE, null));
        set.add(PsiTypeLookupItem.createLookupItem((PsiType)PsiType.CHAR, null));
        set.add(PsiTypeLookupItem.createLookupItem((PsiType)PsiType.SHORT, null));
        set.add(PsiTypeLookupItem.createLookupItem((PsiType)PsiType.INT, null));
        set.add(PsiTypeLookupItem.createLookupItem((PsiType)PsiType.LONG, null));
        set.add(PsiTypeLookupItem.createLookupItem((PsiType)PsiType.FLOAT, null));
        set.add(PsiTypeLookupItem.createLookupItem((PsiType)PsiType.DOUBLE, null));
        return new ConstantNode("Object").withLookupItems(set);
    }

    private PsiMethod createAbstractMethod(String methodName, PsiType returnType) throws IncorrectOperationException {
        PsiMethod method = JavaPsiFacade.getInstance((Project)this.myPsiClass.getProject()).getElementFactory().createMethod(methodName, returnType);
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"abstract", (boolean)true);
        method.getBody().delete();
        return method;
    }

    @Nullable
    public TemplateGenerationInfo generateSetter() throws IncorrectOperationException {
        PsiMethod[] methods;
        String name = CmpFieldClassMember.getFieldNameValue(this.myField);
        String methodName = PropertyUtilBase.suggestSetterName((String)name);
        for (PsiMethod method : methods = this.myPsiClass.getMethods()) {
            if (!method.getName().equals(methodName) || method.getParameterList().getParameters().length != 1 || !PsiType.VOID.equals((Object)method.getReturnType())) continue;
            return null;
        }
        PsiMethod method = this.createAbstractMethod(methodName, (PsiType)PsiType.VOID);
        PsiParameterList parameterList = method.getParameterList();
        String paramName = JavaCodeStyleManager.getInstance((Project)this.myPsiClass.getProject()).propertyNameToVariableName(name, VariableKind.PARAMETER);
        parameterList.add((PsiElement)JavaPsiFacade.getInstance((Project)this.myPsiClass.getProject()).getElementFactory().createParameter(paramName, (PsiType)this.getJavaLangObject()));
        return new TemplateGenerationInfo(method, CmpFieldClassMember.createExpression(method)){

            protected PsiTypeElement getTemplateElement(PsiMethod method) {
                return method.getParameterList().getParameters()[0].getTypeElement();
            }
        };
    }

    private PsiClassType getJavaLangObject() {
        return PsiType.getJavaLangObject((PsiManager)this.myPsiClass.getManager(), (GlobalSearchScope)this.myPsiClass.getResolveScope());
    }
}

