/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.codeInsight.annotator;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.ejb.EjbModuleUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.model.EjbCommonModelUtil;
import com.intellij.javaee.ejb.model.EnterpriseBean;
import com.intellij.javaee.ejb.model.Interceptor;
import com.intellij.javaee.ejb.model.common.EnvironmentGroup;
import com.intellij.javaee.ejb.module.openapi.EjbInspectionToolProvider;
import com.intellij.javaee.ejb.resources.EjbBundle;
import com.intellij.javaee.ejb.utils.EjbUtil;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.util.InspectionValidator;
import com.intellij.openapi.compiler.util.InspectionValidatorUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.descriptors.ConfigFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class EjbValidator
extends InspectionValidator {
    public EjbValidator() {
        super("EJB Validator", EjbBundle.message((String)"ejb.validator.description", (Object[])new Object[0]), EjbBundle.message((String)"progress.validating.ejbs.text", (Object[])new Object[0]));
    }

    public boolean isAvailableOnScope(@NotNull CompileScope scope) {
        if (scope == null) {
            EjbValidator.$$$reportNull$$$0(0);
        }
        return EjbValidator.containsEjbFacet(scope);
    }

    public Class<? extends LocalInspectionTool> @NotNull [] getInspectionToolClasses(CompileContext context) {
        Class[] classArray = new EjbInspectionToolProvider().getInspectionClasses();
        if (classArray == null) {
            EjbValidator.$$$reportNull$$$0(1);
        }
        return classArray;
    }

    public Collection<VirtualFile> getFilesToProcess(Project project, CompileContext context) {
        VirtualFile[] javaFiles;
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (VirtualFile javaFile : javaFiles = context.getProjectCompileScope().getFiles((FileType)StdFileTypes.JAVA, true)) {
            EjbFacet ejbFacet = EjbModuleUtil.getEjbFacet((Project)project, (VirtualFile)javaFile);
            if (ejbFacet == null) continue;
            result.add(javaFile);
        }
        HashSet descriptorFiles = new HashSet();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            for (EjbFacet facet : EjbFacet.getInstances((Module)module)) {
                InspectionValidatorUtil.addDescriptor(descriptorFiles, (ConfigFile)facet.getEjbJarDescriptor());
            }
        }
        result.addAll(InspectionValidatorUtil.expandCompileScopeIfNeeded(descriptorFiles, (CompileContext)context));
        return result;
    }

    @NotNull
    public Collection<PsiElement> getDependencies(PsiFile psiFile) {
        Collection collection = (Collection)ReadAction.compute(() -> {
            ArrayList<Object> result = new ArrayList<Object>();
            Set<? extends EnvironmentGroup> parts = EjbUtil.getEnterpriseBeansAndInterceptors(psiFile);
            for (EnvironmentGroup environmentGroup : parts) {
                Interceptor interceptor;
                PsiClass interceptorClass;
                XmlTag tag = JamCommonUtil.getXmlTag((CommonModelElement)environmentGroup);
                if (tag != null) {
                    result.add(tag);
                }
                if (environmentGroup instanceof EnterpriseBean) {
                    EnterpriseBean ejb = (EnterpriseBean)environmentGroup;
                    PsiClass beanClass = (PsiClass)ejb.getEjbClass().getValue();
                    if (beanClass != null) {
                        result.add(beanClass);
                    }
                    result.addAll(EjbCommonModelUtil.getEjbClasses((EnterpriseBean)ejb, (boolean)false, (boolean)true, (boolean)true));
                    continue;
                }
                if (!(environmentGroup instanceof Interceptor) || (interceptorClass = (PsiClass)(interceptor = (Interceptor)environmentGroup).getInterceptorClass().getValue()) == null) continue;
                result.add(interceptorClass);
            }
            return result;
        });
        if (collection == null) {
            EjbValidator.$$$reportNull$$$0(2);
        }
        return collection;
    }

    private static boolean containsEjbFacet(CompileScope compileScope) {
        Module[] modules = compileScope.getAffectedModules();
        return !JavaeeFacetUtil.getInstance().getJavaeeFacets(EjbFacet.ID, modules).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/codeInsight/annotator/EjbValidator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/codeInsight/annotator/EjbValidator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionToolClasses";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnScope";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

