/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.codeInsight.annotator;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.core.JavaPsiBundle;
import com.intellij.javaee.ejb.EjbDomModelVisitor;
import com.intellij.javaee.ejb.codeInsight.annotator.EjbHighlightingBundle;
import com.intellij.javaee.ejb.model.CmpField;
import com.intellij.javaee.ejb.model.EjbCommonModelUtil;
import com.intellij.javaee.ejb.model.EnterpriseBean;
import com.intellij.javaee.ejb.model.EntityBean;
import com.intellij.javaee.ejb.model.common.enums.CmpVersion;
import com.intellij.javaee.ejb.model.common.enums.PersistenceType;
import com.intellij.javaee.ejb.model.common.xml.EjbReference;
import com.intellij.javaee.ejb.model.xml.CmrField;
import com.intellij.javaee.ejb.model.xml.Method;
import com.intellij.javaee.ejb.model.xml.MethodParams;
import com.intellij.javaee.ejb.model.xml.NamedMethod;
import com.intellij.javaee.ejb.model.xml.QueryMethod;
import com.intellij.javaee.ejb.utils.EjbUtil;
import com.intellij.javaee.model.xml.InjectionTarget;
import com.intellij.javaee.util.JavaeeHighlightingVisitor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.AbstractMethodParams;
import com.intellij.util.xml.converters.AbstractMethodResolveConverter;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class EjbJarHighlightingVisitor
extends EjbDomModelVisitor {
    private final DomElementAnnotationHolder myAnnotator;

    public EjbJarHighlightingVisitor(DomElementAnnotationHolder annotator) {
        this.myAnnotator = annotator;
    }

    @Override
    public void visitEjbReference(EjbReference ejbRef) {
        super.visitEjbReference(ejbRef);
        EnterpriseBean ejb = (EnterpriseBean)ejbRef.getEjbLink().getValue();
        if (ejb != null && !EjbCommonModelUtil.getEjbClasses((EnterpriseBean)ejb, (boolean)false, (boolean)false, (boolean)true).contains(ejbRef.getComponentInterface().getValue())) {
            this.myAnnotator.createProblem((DomElement)ejbRef.getComponentInterface(), EjbHighlightingBundle.message("error.text.ejb.does.not.have.component.interface", ejb.getEjbName().getValue(), ejbRef.getComponentInterface().getStringValue()), new LocalQuickFix[0]);
        }
    }

    @Override
    public void visitInjectionTarget(InjectionTarget injectionTarget) {
        GenericDomValue memberValue;
        super.visitInjectionTarget(injectionTarget);
        PsiClass psiClass = (PsiClass)injectionTarget.getInjectionTargetClass().getValue();
        if (psiClass != null && (memberValue = injectionTarget.getInjectionTargetMember()).getXmlTag() != null) {
            PsiMember member = (PsiMember)memberValue.getValue();
            if (member instanceof PsiField) {
                EjbJarHighlightingVisitor.checkFieldModifier((DomElement)memberValue, (PsiField)member, "final", false, this.myAnnotator);
            } else if (member instanceof PsiMethod) {
                EjbJarHighlightingVisitor.checkMethodModifier((DomElement)memberValue, (PsiMethod)member, "final", false, this.myAnnotator);
                if (!PropertyUtilBase.isSimplePropertySetter((PsiMethod)((PsiMethod)member))) {
                    this.myAnnotator.createProblem((DomElement)memberValue, EjbHighlightingBundle.message("injected.property.method.should.be.setter", memberValue.getStringValue()), new LocalQuickFix[0]);
                }
            } else if (member != null) assert (false);
        }
    }

    @Override
    public void visitMethod(Method method) {
        super.visitMethod(method);
        EjbJarHighlightingVisitor.checkMethod(this.myAnnotator, (GenericDomValue<? extends PsiMethod>)method.getMethod(), method.getMethodParams());
    }

    @Override
    public void visitNamedMethod(NamedMethod method) {
        super.visitNamedMethod(method);
        EjbJarHighlightingVisitor.checkMethod(this.myAnnotator, (GenericDomValue<? extends PsiMethod>)method.getMethod(), method.getMethodParams());
    }

    @Override
    public void visitQueryMethod(QueryMethod method) {
        super.visitQueryMethod(method);
        EjbJarHighlightingVisitor.checkMethod(this.myAnnotator, (GenericDomValue<? extends PsiMethod>)method.getMethodName(), method.getMethodParams());
    }

    @Override
    public void visitCmpField(com.intellij.javaee.ejb.model.xml.CmpField field) {
        super.visitCmpField(field);
        EntityBean entityBean = field.getEntityBean();
        String fieldName = (String)field.getFieldName().getValue();
        if (StringUtil.isNotEmpty((String)fieldName) && entityBean != null && entityBean.getCmpVersion().getValue() == CmpVersion.CmpVersion_2_X && Character.isUpperCase(fieldName.charAt(0))) {
            this.myAnnotator.createProblem((DomElement)field.getFieldName(), EjbHighlightingBundle.message("error.message.cmp.field.lowercase", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @Override
    public void visitCmrField(CmrField field) {
        super.visitCmrField(field);
        String fieldName = (String)field.getCmrFieldName().getValue();
        if (StringUtil.isNotEmpty((String)fieldName) && Character.isUpperCase(fieldName.charAt(0))) {
            this.myAnnotator.createProblem((DomElement)field.getCmrFieldName(), EjbHighlightingBundle.message("error.message.cmr.field.lowercase", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @Override
    public void visitEntityBean(com.intellij.javaee.ejb.model.xml.EntityBean ejb) {
        super.visitEntityBean(ejb);
        this.checkPk(ejb);
        this.checkCmpFieldsAvailability(ejb);
        this.checkQueryMethodDuplicates(ejb);
    }

    private void checkPk(com.intellij.javaee.ejb.model.xml.EntityBean ejb) {
        GenericDomValue primKeyClass = ejb.getPrimKeyClass();
        PsiClass pkClass = (PsiClass)primKeyClass.getValue();
        if (pkClass != null) {
            CmpField primkeyField;
            Project project;
            PsiClassType type;
            if (ejb.getHome().getValue() != null && !EjbUtil.isTypeRMICompatible((PsiType)(type = JavaPsiFacade.getInstance((Project)(project = ejb.getManager().getProject())).getElementFactory().createType(pkClass)), project)) {
                this.myAnnotator.createProblem((DomElement)primKeyClass, EjbHighlightingBundle.message("warning.text.primary.key.class.is.not.rmi.iiop.compatible", new Object[0]), new LocalQuickFix[0]);
            }
            if ((primkeyField = (CmpField)ejb.getPrimkeyField().getValue()) != null && !JavaPsiFacade.getInstance((Project)pkClass.getProject()).getElementFactory().createType(pkClass).equals((Object)EjbUtil.findType(primkeyField))) {
                this.myAnnotator.createProblem((DomElement)ejb.getPrimkeyField(), EjbHighlightingBundle.message("error.text.primary.key.field.type.should.be.equal.to.primary.key.class", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    private void checkCmpFieldsAvailability(com.intellij.javaee.ejb.model.xml.EntityBean ejb) {
        GenericDomValue cmpVersion = ejb.getCmpVersion();
        List cmpFields = ejb.getCmpFields();
        if (ejb.getPersistenceType().getValue() == PersistenceType.CONTAINER) {
            GenericDomValue abstractSchemaName;
            if (cmpVersion.getValue() == CmpVersion.CmpVersion_2_X && StringUtil.isEmpty((String)((String)(abstractSchemaName = ejb.getAbstractSchemaName()).getValue()))) {
                this.myAnnotator.createProblem((DomElement)abstractSchemaName, EjbHighlightingBundle.message("warning.text.abstract.schema.name.should.not.be.empty", new Object[0]), new LocalQuickFix[0]);
            }
            if (cmpFields.isEmpty()) {
                this.myAnnotator.createProblem((DomElement)ejb, ejb.getGenericInfo().getCollectionChildDescription("cmp-field"), EjbHighlightingBundle.message("warning.text.cmp.field.list.for.cmp.bean.should.not.be.empty", new Object[0]));
            }
            if (ejb.getPrimkeyField().getXmlTag() == null) {
                if (ejb.getPrimKeyClass().getXmlTag() == null) {
                    this.myAnnotator.createProblem((DomElement)ejb, EjbHighlightingBundle.message("error.text.no.primkeyfield.or.primkeyclass.defined", new Object[0]), new LocalQuickFix[0]);
                } else {
                    String pkClassName;
                    PsiClass pkClass = (PsiClass)ejb.getPrimKeyClass().getValue();
                    String string = pkClassName = pkClass == null ? null : pkClass.getQualifiedName();
                    if (!Objects.equals(PsiTypesUtil.unboxIfPossible((String)pkClassName), pkClassName) || "java.lang.String".equals(pkClassName)) {
                        this.myAnnotator.createProblem((DomElement)ejb, EjbHighlightingBundle.message("error.text.no.primkeyfield.defined", new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }
        } else {
            if (cmpVersion.getXmlTag() != null) {
                this.myAnnotator.createProblem((DomElement)cmpVersion, EjbHighlightingBundle.message("error.text.no.cmp.version.for.bmp.bean", new Object[0]), new LocalQuickFix[0]);
            }
            if (!cmpFields.isEmpty()) {
                this.myAnnotator.createProblem((DomElement)cmpFields.get(0), EjbHighlightingBundle.message("error.text.no.cmp.fields.for.bmp.bean", new Object[0]), new LocalQuickFix[0]);
            }
            if (ejb.getPrimKeyClass().getXmlTag() == null) {
                this.myAnnotator.createProblem((DomElement)ejb, EjbHighlightingBundle.message("error.text.no.primkey.for.bmp.bean", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    private void checkQueryMethodDuplicates(com.intellij.javaee.ejb.model.xml.EntityBean ejb) {
        JavaeeHighlightingVisitor.checkDuplicates((Collection)ejb.getQueries(), query -> query.getQueryMethod().getMethodName().getValue(), query -> this.myAnnotator.createProblem((DomElement)query.getQueryMethod(), EjbHighlightingBundle.message("error.text.duplicate.query.method", new Object[0]), new LocalQuickFix[0]));
    }

    public static void checkMethodModifier(DomElement domElement, PsiMethod method, @PsiModifier.ModifierConstant String modifier, boolean shouldHave, DomElementAnnotationHolder holder) {
        PsiModifierList modifierList = method.getModifierList();
        if (modifierList.hasModifierProperty(modifier) != shouldHave) {
            holder.createProblem(domElement, EjbHighlightingBundle.message(shouldHave ? "method.should.have.modifier" : "method.should.not.have.modifier", method.getName(), modifier), new LocalQuickFix[0]);
        }
    }

    public static void checkFieldModifier(DomElement domElement, PsiField field, @PsiModifier.ModifierConstant String modifier, boolean shouldHave, DomElementAnnotationHolder holder) {
        PsiModifierList modifierList = field.getModifierList();
        if (modifierList.hasModifierProperty(modifier) != shouldHave) {
            holder.createProblem(domElement, EjbHighlightingBundle.message(shouldHave ? "field.should.have.modifier" : "field.should.not.have.modifier", field.getName(), modifier), new LocalQuickFix[0]);
        }
    }

    private static void checkMethod(DomElementAnnotationHolder annotator, GenericDomValue<? extends PsiMethod> genericValue, @NotNull MethodParams methodParams) {
        PsiMethod method;
        if (methodParams == null) {
            EjbJarHighlightingVisitor.$$$reportNull$$$0(0);
        }
        if ((method = (PsiMethod)genericValue.getValue()) != null) {
            if (!AbstractMethodResolveConverter.methodParamsMatchSignature((AbstractMethodParams)methodParams, (PsiMethod)method)) {
                String s = genericValue.getStringValue();
                annotator.createProblem((DomElement)methodParams, CodeInsightBundle.message((String)"error.cannot.resolve.0.1", (Object[])new Object[]{JavaPsiBundle.message((String)"element.method", (Object[])new Object[0]), AbstractMethodResolveConverter.getReferenceCanonicalText((String)s, (AbstractMethodParams)methodParams)}), new LocalQuickFix[0]);
            } else if (!AbstractMethodResolveConverter.methodSuits((PsiMethod)method)) {
                annotator.createProblem(genericValue, EjbHighlightingBundle.message("method.should.not.be.final.or.static", new Object[0]), new LocalQuickFix[0]);
            }
        }
        if ("*".equals(genericValue.getStringValue()) && methodParams.getXmlTag() != null) {
            annotator.createProblem((DomElement)methodParams, EjbHighlightingBundle.message("there.should.be.no.method.params.for.*.method", methodParams.getXmlElementName()), new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodParams", "com/intellij/javaee/ejb/codeInsight/annotator/EjbJarHighlightingVisitor", "checkMethod"));
    }
}

