/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb;

import com.intellij.javaee.constants.JavaeeCommonConstants;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.model.EjbRootElement;
import com.intellij.javaee.ejb.model.EjbWithHome;
import com.intellij.javaee.ejb.model.EnterpriseBean;
import com.intellij.javaee.ejb.model.EnterpriseBeanSet;
import com.intellij.javaee.ejb.model.Interceptor;
import com.intellij.javaee.ejb.model.MessageDrivenBean;
import com.intellij.javaee.ejb.model.SessionBean;
import com.intellij.javaee.ejb.model.xml.EjbJar;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.ejb.role.EjbClassRoleImpl;
import com.intellij.javaee.ejb.utils.EjbUtil;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.xml.GenericValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class NewEjbRoleHolder {
    private final Project myProject;

    public static NewEjbRoleHolder getInstance(Project project) {
        return (NewEjbRoleHolder)ServiceManager.getService((Project)project, NewEjbRoleHolder.class);
    }

    public NewEjbRoleHolder(@NotNull Project project) {
        if (project == null) {
            NewEjbRoleHolder.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    private Info getCachedXmlRoles() {
        return (Info)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, () -> new CachedValueProvider.Result((Object)NewEjbRoleHolder.calculateXmlRoles(this.myProject), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private Info getCachedMergedRoles() {
        return (Info)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, () -> new CachedValueProvider.Result((Object)NewEjbRoleHolder.calculateMergedRoles(this.myProject), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    public EjbClassRole[] getXmlRoles(PsiClass psiClass) {
        if (psiClass == null) {
            return EjbClassRoleImpl.EMPTY_ARRAY;
        }
        return NewEjbRoleHolder.getRoles(psiClass, this.getCachedXmlRoles());
    }

    public EjbClassRole[] getAllXmlRoles() {
        List<EjbClassRole> roleList = this.getCachedXmlRoles().allRoles;
        return roleList.toArray(new EjbClassRole[0]);
    }

    public EjbClassRole[] getMergedRoles(PsiClass psiClass) {
        if (psiClass == null) {
            return EjbClassRoleImpl.EMPTY_ARRAY;
        }
        return NewEjbRoleHolder.getRoles(psiClass, this.getCachedMergedRoles());
    }

    public EjbClassRole[] getAllMergedRoles() {
        List<EjbClassRole> roleList = this.getCachedMergedRoles().allRoles;
        return roleList.toArray(new EjbClassRole[0]);
    }

    private static EjbClassRole[] getRoles(PsiClass psiClass, Info info) {
        if (info.map.isEmpty()) {
            return EjbClassRoleImpl.EMPTY_ARRAY;
        }
        List<EjbClassRole> roleList = info.map.get(psiClass);
        if (roleList == null || roleList.isEmpty()) {
            return EjbClassRoleImpl.EMPTY_ARRAY;
        }
        return roleList.toArray(new EjbClassRole[0]);
    }

    private static Info calculateMergedRoles(Project project) {
        Info info = new Info();
        for (EjbFacet ejbFacet : EjbUtil.getAllEjbFacets(project)) {
            EjbRootElement ejbRootElement = ejbFacet.getMergedRoot();
            NewEjbRoleHolder.processRootElement(info, ejbFacet, ejbRootElement);
        }
        return info;
    }

    private static Info calculateXmlRoles(Project project) {
        Info info = new Info();
        for (EjbFacet ejbFacet : EjbUtil.getAllEjbFacets(project)) {
            EjbJar ejbRootElement = ejbFacet.getXmlRoot();
            if (ejbRootElement == null) continue;
            NewEjbRoleHolder.processRootElement(info, ejbFacet, (EjbRootElement)ejbRootElement);
        }
        return info;
    }

    private static void processRootElement(Info info, EjbFacet ejbFacet, EjbRootElement ejbRootElement) {
        EnterpriseBeanSet enterpriseBeanSet = ejbRootElement.getEnterpriseBeans();
        NewEjbRoleHolder.processBeans(info, ejbFacet, enterpriseBeanSet.getEntities(), true, false);
        NewEjbRoleHolder.processBeans(info, ejbFacet, enterpriseBeanSet.getSessions(), true, true);
        NewEjbRoleHolder.processBeans(info, ejbFacet, enterpriseBeanSet.getMessageDrivens(), false, false);
        for (Interceptor interceptor : ejbRootElement.getInterceptors().getInterceptors()) {
            NewEjbRoleHolder.processInterceptorClass(info, ejbFacet, (PsiClass)interceptor.getInterceptorClass().getValue(), interceptor);
        }
    }

    private static void processBeans(Info info, EjbFacet facet, Collection<? extends EnterpriseBean> beans, boolean withHome, boolean session) {
        for (EnterpriseBean enterpriseBean : beans) {
            info.allRoles.add(new EjbClassRoleImpl(EjbClassRoleEnum.EMPTY_ROLE, enterpriseBean, facet));
            NewEjbRoleHolder.processClass(info, (PsiClass)enterpriseBean.getEjbClass().getValue(), EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS, facet, enterpriseBean);
            if (withHome) {
                EjbWithHome elementWithHome = (EjbWithHome)enterpriseBean;
                NewEjbRoleHolder.processClass(info, (PsiClass)elementWithHome.getHome().getValue(), EjbClassRoleEnum.EJB_CLASS_ROLE_HOME_INTERFACE, facet, enterpriseBean);
                NewEjbRoleHolder.processClass(info, (PsiClass)elementWithHome.getRemote().getValue(), EjbClassRoleEnum.EJB_CLASS_ROLE_REMOTE_INTERFACE, facet, enterpriseBean);
                NewEjbRoleHolder.processClass(info, (PsiClass)elementWithHome.getLocalHome().getValue(), EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_HOME_INTERFACE, facet, enterpriseBean);
                NewEjbRoleHolder.processClass(info, (PsiClass)elementWithHome.getLocal().getValue(), EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_INTERFACE, facet, enterpriseBean);
            } else {
                NewEjbRoleHolder.processClass(info, (PsiClass)((MessageDrivenBean)enterpriseBean).getMessageListenerInterface().getValue(), EjbClassRoleEnum.EJB_CLASS_ROLE_BUSINESS_LOCAL_INTERFACE, facet, enterpriseBean);
            }
            if (!session) continue;
            SessionBean sessionBean = (SessionBean)enterpriseBean;
            NewEjbRoleHolder.processClass(info, (PsiClass)sessionBean.getServiceEndpoint().getValue(), EjbClassRoleEnum.EJB_CLASS_ROLE_SERVICE_ENDPOINT_INTERFACE, facet, enterpriseBean);
            for (GenericValue genericValue : sessionBean.getBusinessLocals()) {
                NewEjbRoleHolder.processClass(info, (PsiClass)genericValue.getValue(), EjbClassRoleEnum.EJB_CLASS_ROLE_BUSINESS_LOCAL_INTERFACE, facet, enterpriseBean);
            }
            for (GenericValue genericValue : sessionBean.getBusinessRemotes()) {
                NewEjbRoleHolder.processClass(info, (PsiClass)genericValue.getValue(), EjbClassRoleEnum.EJB_CLASS_ROLE_BUSINESS_REMOTE_INTERFACE, facet, enterpriseBean);
            }
        }
    }

    private static void processInterceptorClass(Info info, EjbFacet facet, PsiClass psiClass, Interceptor interceptor) {
        info.allRoles.add(new EjbClassRoleImpl(EjbClassRoleEnum.EMPTY_ROLE, interceptor, facet));
        if (psiClass == null) {
            return;
        }
        EjbClassRoleImpl classRole = new EjbClassRoleImpl(EjbClassRoleEnum.EJB_CLASS_ROLE_INTERCEPTOR_CLASS, interceptor, facet);
        NewEjbRoleHolder.processClass(info, psiClass, classRole);
    }

    private static void processClass(Info info, PsiClass psiClass, EjbClassRoleEnum ejbClassRole, EjbFacet facet, @NotNull EnterpriseBean ejb) {
        if (ejb == null) {
            NewEjbRoleHolder.$$$reportNull$$$0(1);
        }
        if (psiClass != null) {
            NewEjbRoleHolder.processClass(info, psiClass, new EjbClassRoleImpl(ejbClassRole, ejb, facet));
        }
    }

    private static void processClass(Info info, PsiClass psiClass, EjbClassRoleImpl classRole) {
        ProgressManager.checkCanceled();
        ArrayList<PsiClass> psiClasses = new ArrayList<PsiClass>(5);
        psiClasses.add(psiClass);
        for (int i = 0; i < psiClasses.size(); ++i) {
            PsiClass curClass = (PsiClass)psiClasses.get(i);
            for (PsiClassType superClassType : curClass.getExtendsListTypes()) {
                String name;
                PsiClass superClass = superClassType.resolve();
                if (superClass == null || (name = superClass.getQualifiedName()) == null || name.startsWith(JavaeeCommonConstants.JAVAX_EJB_PACKAGE_PREFIX.fqn((PsiElement)psiClass)) || name.equals("java.io.Serializable") || name.equals("java.io.Externalizable") || psiClasses.contains(superClass)) continue;
                psiClasses.add(superClass);
            }
        }
        for (PsiClass aClass : psiClasses) {
            List<EjbClassRole> roleList = info.map.get(aClass);
            if (roleList == null) {
                roleList = new ArrayList<EjbClassRole>(1);
                info.map.put(aClass, roleList);
            }
            roleList.add(classRole);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ejb";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javaee/ejb/NewEjbRoleHolder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Info {
        final Map<PsiClass, List<EjbClassRole>> map = new HashMap<PsiClass, List<EjbClassRole>>();
        final List<EjbClassRole> allRoles = new ArrayList<EjbClassRole>();

        private Info() {
        }
    }
}

