/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.ejb.model.common.enums.CmpVersion;
import com.intellij.javaee.ejb.model.xml.EntityBean;
import com.intellij.javaee.model.xml.JavaeeDomModelElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Factory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaeeFieldUpdater<T extends JavaeeDomModelElement> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.ejb.JavaeeFieldUpdater");
    private final String myOldName;
    private final String myOldType;
    private String myNewName;
    private String myNewType;
    private String myDescription;
    private final Factory<T> myFactory;
    private final EntityBean myParent;
    private Boolean myProcessCovariantOverriders;

    protected JavaeeFieldUpdater(Factory<T> factory, EntityBean parent, String name, String description, PsiType type) {
        this(factory, parent, name, description, type, name, type);
    }

    protected JavaeeFieldUpdater(Factory<T> factory, EntityBean parent, String oldName, String description, PsiType newType, String newName, PsiType oldType) {
        this.myOldName = oldName;
        this.myDescription = description;
        this.myNewType = newType == null ? null : newType.getCanonicalText();
        this.myFactory = factory;
        this.myNewName = newName;
        this.myOldType = oldType == null ? null : oldType.getCanonicalText();
        this.myParent = (EntityBean)parent.createStableCopy();
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    public void setNewName(String newName) {
        this.myNewName = newName;
    }

    public void setNewType(PsiType newType) {
        this.myNewType = newType == null ? null : newType.getCanonicalText();
    }

    public Factory<T> getFactory() {
        return this.myFactory;
    }

    public EntityBean getParent() {
        return this.myParent;
    }

    protected static void deleteField(PsiClass pkClass, String name) throws IncorrectOperationException {
        PsiField field = pkClass.findFieldByName(name, true);
        if (field != null && field.getManager().isInProject((PsiElement)field) && FileModificationService.getInstance().prepareFileForWrite(field.getContainingFile())) {
            field.delete();
        }
    }

    protected static void deleteMethod(PsiClass pkClass, @NonNls String name, PsiType ... parameterTypes) throws IncorrectOperationException {
        MethodSignature equalsSignature = MethodSignatureUtil.createMethodSignature((String)name, (PsiType[])parameterTypes, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        PsiMethod equals = MethodSignatureUtil.findMethodBySignature((PsiClass)pkClass, (MethodSignature)equalsSignature, (boolean)false);
        if (equals != null) {
            equals.delete();
        }
    }

    public final void updateGetter(@Nullable PsiClass source, boolean isRemote, boolean shouldBe) throws IncorrectOperationException {
        if (source == null || this.myNewName == null || this.myNewType == null) {
            return;
        }
        this.updateMethod(source, this.myOldName == null || this.myOldType == null ? null : this.getGetterPrototype(source, this.myOldName, this.myOldType, isRemote), this.getGetterPrototype(source, this.myNewName, this.myNewType, isRemote), shouldBe);
    }

    public final void updateSetter(@Nullable PsiClass source, boolean isRemote, boolean shouldBe) throws IncorrectOperationException {
        if (source == null || this.myNewName == null || this.myNewType == null) {
            return;
        }
        this.updateMethod(source, this.myOldName == null || this.myOldType == null ? null : this.getSetterPrototype(source, this.myOldName, this.myOldType, isRemote), this.getSetterPrototype(source, this.myNewName, this.myNewType, isRemote), shouldBe);
    }

    @NotNull
    private PsiMethod getGetterPrototype(@NotNull PsiClass context, String name, @NotNull String type, boolean isRemote) throws IncorrectOperationException {
        PsiCodeBlock body;
        if (context == null) {
            JavaeeFieldUpdater.$$$reportNull$$$0(0);
        }
        if (type == null) {
            JavaeeFieldUpdater.$$$reportNull$$$0(1);
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory();
        PsiType psiType = factory.createTypeFromText(type, (PsiElement)context);
        PsiMethod method = factory.createMethod(JavaeeUtil.suggestGetterName((String)name), psiType);
        if (!this.shouldBeAbstract(context) && (body = method.getBody()) != null) {
            body.add((PsiElement)factory.createStatementFromText("return " + name + ";", null));
        }
        PsiMethod psiMethod = this.tuneAccessorMethod(isRemote, method, context);
        if (psiMethod == null) {
            JavaeeFieldUpdater.$$$reportNull$$$0(2);
        }
        return psiMethod;
    }

    @NotNull
    private PsiMethod getSetterPrototype(@NotNull PsiClass context, String name, String type, boolean isRemote) throws IncorrectOperationException {
        PsiCodeBlock body;
        if (context == null) {
            JavaeeFieldUpdater.$$$reportNull$$$0(3);
        }
        PsiManager psiManager = context.getManager();
        LOG.assertTrue(PsiNameHelper.getInstance((Project)psiManager.getProject()).isIdentifier(name));
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
        PsiMethod method = factory.createMethod(JavaeeUtil.suggestSetterName((String)name), (PsiType)PsiType.VOID);
        method.getParameterList().add((PsiElement)factory.createParameter(name, factory.createTypeFromText(type, (PsiElement)context)));
        if (!this.shouldBeAbstract(context) && (body = method.getBody()) != null) {
            body.add((PsiElement)JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createStatementFromText("this." + name + " = " + name + ";", null));
        }
        PsiMethod psiMethod = this.tuneAccessorMethod(isRemote, method, context);
        if (psiMethod == null) {
            JavaeeFieldUpdater.$$$reportNull$$$0(4);
        }
        return psiMethod;
    }

    @NotNull
    protected PsiMethod tuneAccessorMethod(boolean isRemote, @NotNull PsiMethod method, PsiClass context) throws IncorrectOperationException {
        if (method == null) {
            JavaeeFieldUpdater.$$$reportNull$$$0(5);
        }
        if (isRemote) {
            PsiUtil.addException((PsiMethod)method, (String)"java.rmi.RemoteException");
        }
        if (this.shouldBeAbstract(context)) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"abstract", (boolean)true);
            PsiCodeBlock body = method.getBody();
            if (body != null) {
                body.delete();
            }
        }
        PsiMethod psiMethod = method;
        if (psiMethod == null) {
            JavaeeFieldUpdater.$$$reportNull$$$0(6);
        }
        return psiMethod;
    }

    private boolean shouldBeAbstract(PsiClass context) {
        return this.getParent().getCmpVersion().getValue() != CmpVersion.CmpVersion_1_X || context.isInterface();
    }

    private void updateMethod(PsiClass source, @Nullable PsiMethod oldMethodPrototype, @NotNull PsiMethod newMethodPrototype, boolean shouldBe) throws IncorrectOperationException {
        PsiMethod existingMethod;
        if (newMethodPrototype == null) {
            JavaeeFieldUpdater.$$$reportNull$$$0(7);
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)source)) {
            return;
        }
        PsiMethod psiMethod = existingMethod = oldMethodPrototype == null ? null : source.findMethodBySignature(oldMethodPrototype, true);
        if (existingMethod == null) {
            if (source.findMethodBySignature(newMethodPrototype, true) == null && shouldBe) {
                source.add((PsiElement)newMethodPrototype);
            }
            return;
        }
        if (!shouldBe) {
            existingMethod.delete();
            return;
        }
        ParameterInfoImpl[] oldParameterInfo = ParameterInfoImpl.fromMethod((PsiMethod)existingMethod);
        PsiParameter[] oldParameters = existingMethod.getParameterList().getParameters();
        PsiParameter[] newParameters = newMethodPrototype.getParameterList().getParameters();
        if (oldParameters.length != 0 && newParameters.length != 0) {
            PsiIdentifier identifier = newParameters[0].getNameIdentifier();
            assert (identifier != null);
            identifier.replace((PsiElement)oldParameters[0].getNameIdentifier());
        }
        ParameterInfoImpl[] newParameterInfo = ParameterInfoImpl.fromMethod((PsiMethod)newMethodPrototype);
        if (!(Comparing.equal((Object)newMethodPrototype.getReturnType(), (Object)existingMethod.getReturnType()) && Comparing.strEqual((String)existingMethod.getName(), (String)newMethodPrototype.getName()) && Arrays.asList(oldParameterInfo).equals(Arrays.asList(newParameterInfo)))) {
            ChangeSignatureProcessor changeSignatureProcessor = new ChangeSignatureProcessor(source.getProject(), existingMethod, false, "public", newMethodPrototype.getName(), newMethodPrototype.getReturnType(), newParameterInfo){

                protected boolean isProcessCovariantOverriders() {
                    if (JavaeeFieldUpdater.this.myProcessCovariantOverriders == null) {
                        JavaeeFieldUpdater.this.myProcessCovariantOverriders = super.isProcessCovariantOverriders();
                    }
                    return JavaeeFieldUpdater.this.myProcessCovariantOverriders;
                }
            };
            changeSignatureProcessor.run();
        }
    }

    @Nullable
    public static PsiType findType(String name, Project project) {
        try {
            PsiType componentType;
            PsiType type = JavaPsiFacade.getInstance((Project)project).getElementFactory().createTypeFromText(name, null);
            if (type instanceof PsiPrimitiveType) {
                return type;
            }
            if (type instanceof PsiArrayType && (componentType = ((PsiArrayType)type).getComponentType()) != null && JavaeeFieldUpdater.findType(componentType.getCanonicalText(), project) != null) {
                return type;
            }
            if (type instanceof PsiClassType && ((PsiClassType)type).resolve() != null) {
                return type;
            }
            return null;
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    public String getOldName() {
        return this.myOldName;
    }

    public String getNewName() {
        return this.myNewName;
    }

    @Nullable
    public String getNewType() {
        return this.myNewType;
    }

    public String getDescription() {
        return this.myDescription;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/JavaeeFieldUpdater";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMethodPrototype";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/JavaeeFieldUpdater";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGetterPrototype";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSetterPrototype";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "tuneAccessorMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGetterPrototype";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSetterPrototype";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tuneAccessorMethod";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

