/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.DomSpringBeanPointer;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.webflow.config.model.xml.version1_0.Registry;
import com.intellij.spring.webflow.config.model.xml.version2_0.FlowRegistry;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class WebflowConfigUtil {
    private WebflowConfigUtil() {
    }

    @NotNull
    public static List<FlowRegistry> getFlowRegistries(@NotNull Module module) {
        if (module == null) {
            WebflowConfigUtil.$$$reportNull$$$0(0);
        }
        return WebflowConfigUtil.doGetFlowRegistries(module, FlowRegistry.class, "org.springframework.webflow.definition.registry.FlowDefinitionRegistry");
    }

    @NotNull
    public static List<Registry> getFlowRegistries10(@NotNull Module module) {
        if (module == null) {
            WebflowConfigUtil.$$$reportNull$$$0(1);
        }
        return WebflowConfigUtil.doGetFlowRegistries(module, Registry.class, "org.springframework.webflow.definition.registry.FlowDefinitionRegistry");
    }

    @NotNull
    public static List<SpringProperty> getAdditionalConfigProperties(@NotNull Module module) {
        PsiClass flowRegistrar;
        if (module == null) {
            WebflowConfigUtil.$$$reportNull$$$0(2);
        }
        if ((flowRegistrar = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.webflow.engine.builder.xml.XmlFlowRegistrar")) == null) {
            List<SpringProperty> list = Collections.emptyList();
            if (list == null) {
                WebflowConfigUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)flowRegistrar).effectiveBeanTypes();
        SmartList configProperties = new SmartList();
        Set models = SpringManager.getInstance((Project)module.getProject()).getAllModels(module);
        for (SpringModel model : models) {
            List flowRegistrarBeans = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters);
            for (SpringBeanPointer beanPointer : flowRegistrarBeans) {
                CommonSpringBean bean = beanPointer.getSpringBean();
                SpringPropertyDefinition locations = SpringPropertyUtils.findPropertyByName((CommonSpringBean)bean, (String)"flowLocations");
                if (!(locations instanceof SpringProperty)) continue;
                configProperties.add((SpringProperty)locations);
            }
        }
        SmartList smartList = configProperties;
        if (smartList == null) {
            WebflowConfigUtil.$$$reportNull$$$0(4);
        }
        return smartList;
    }

    @NotNull
    public static List<JamSpringBeanPointer> getCodeFlowRegistries(@NotNull Module module) {
        PsiClass flowRegistryClass;
        if (module == null) {
            WebflowConfigUtil.$$$reportNull$$$0(5);
        }
        if ((flowRegistryClass = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.webflow.definition.registry.FlowDefinitionRegistry")) == null) {
            List<JamSpringBeanPointer> list = Collections.emptyList();
            if (list == null) {
                WebflowConfigUtil.$$$reportNull$$$0(6);
            }
            return list;
        }
        SpringModel model = SpringManager.getInstance((Project)module.getProject()).getCombinedModel(module);
        List flowRegistryBeans = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)SpringModelSearchParameters.byClass((PsiClass)flowRegistryClass));
        List list = ContainerUtil.findAll((Collection)flowRegistryBeans, JamSpringBeanPointer.class);
        if (list == null) {
            WebflowConfigUtil.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private static <T extends DomElement> List<T> doGetFlowRegistries(@NotNull Module module, Class<T> domElementType, String flowRegistryClassName) {
        PsiClass flowRegistryClass;
        if (module == null) {
            WebflowConfigUtil.$$$reportNull$$$0(8);
        }
        if ((flowRegistryClass = SpringCommonUtils.findLibraryClass((Module)module, (String)flowRegistryClassName)) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                WebflowConfigUtil.$$$reportNull$$$0(9);
            }
            return list;
        }
        SpringModelSearchParameters.BeanClass searchParams = SpringModelSearchParameters.byClass((PsiClass)flowRegistryClass);
        SmartList flowRegistries = new SmartList();
        Set models = SpringManager.getInstance((Project)module.getProject()).getAllModels(module);
        for (SpringModel model : models) {
            if (!(model instanceof XmlSpringModel)) continue;
            for (SpringBeanPointer registry : SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParams)) {
                DomSpringBean bean;
                if (!(registry instanceof DomSpringBeanPointer) || !domElementType.isInstance(bean = (DomSpringBean)((DomSpringBeanPointer)registry).getSpringBean())) continue;
                flowRegistries.add(bean);
            }
        }
        SmartList smartList = flowRegistries;
        if (smartList == null) {
            WebflowConfigUtil.$$$reportNull$$$0(10);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/webflow/util/WebflowConfigUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/webflow/util/WebflowConfigUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalConfigProperties";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeFlowRegistries";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetFlowRegistries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFlowRegistries";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFlowRegistries10";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalConfigProperties";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCodeFlowRegistries";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doGetFlowRegistries";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

