/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.navigation;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.DomGotoRelatedItem;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.spring.gutter.DomElementListCellRenderer;
import com.intellij.spring.webflow.model.WebflowDomModelManager;
import com.intellij.spring.webflow.model.WebflowModel;
import com.intellij.spring.webflow.model.converters.BeanImportResourceConverter;
import com.intellij.spring.webflow.model.xml.BeanImport;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.spring.webflow.model.xml.SubflowState;
import com.intellij.spring.webflow.resources.WebflowBundle;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.xml.util.XmlTagUtil;
import icons.SpringApiIcons;
import icons.SpringWebflowIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebflowRelatedItemLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    private static final MyRelatedDomItemProvider DEFINITION_DOM_ITEM_PROVIDER = new MyRelatedDomItemProvider(WebflowBundle.message("navigation.related.flow.definition", new Object[0]));
    private static final MyRelatedDomItemProvider PARENT_RELATED_DOM_ITEM_PROVIDER = new MyRelatedDomItemProvider(WebflowBundle.message("navigation.related.flow.parent.flow", new Object[0]));
    private static final MyRelatedDomItemProvider INHERITING_RELATED_DOM_ITEM_PROVIDER = new MyRelatedDomItemProvider(WebflowBundle.message("navigation.related.flow.inheriting.flow", new Object[0]));
    private static final MyRelatedDomItemProvider SUBFLOW_RELATED_DOM_ITEM_PROVIDER = new MyRelatedDomItemProvider(WebflowBundle.message("navigation.related.subflow.flow", new Object[0]));

    public String getId() {
        return "WebflowRelatedItemLineMarkerProvider";
    }

    public String getName() {
        return WebflowBundle.message("spring.web.flow.xml", new Object[0]);
    }

    @Nullable
    public Icon getIcon() {
        return SpringWebflowIcons.SpringWebFlow;
    }

    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, boolean forNavigation) {
        PsiElement item;
        if (elements == null) {
            WebflowRelatedItemLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            WebflowRelatedItemLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if ((item = (PsiElement)ContainerUtil.getFirstItem(elements)) == null) {
            return;
        }
        PsiFile containingFile = item.getContainingFile();
        if (!JamCommonUtil.isPlainXmlFile((PsiElement)containingFile)) {
            return;
        }
        XmlFile file = (XmlFile)containingFile;
        if (!WebflowDomModelManager.isWebflow(file)) {
            return;
        }
        WebflowModel webflowModel = WebflowDomModelManager.getWebflowModel(file);
        if (webflowModel == null) {
            return;
        }
        Flow flow = webflowModel.getFlow();
        if (!flow.isValid()) {
            return;
        }
        DomManager domManager = DomManager.getDomManager((Project)file.getProject());
        for (PsiElement psiElement : elements) {
            if (!(psiElement instanceof XmlTag)) continue;
            DomElement domElement = domManager.getDomElement((XmlTag)psiElement);
            if (domElement instanceof Flow) {
                WebflowRelatedItemLineMarkerProvider.installFlowDefinition(result, psiElement.getProject(), flow, webflowModel);
                WebflowRelatedItemLineMarkerProvider.installFlowParent(result, flow);
                WebflowRelatedItemLineMarkerProvider.installFlowInheriting(result, flow);
                continue;
            }
            if (domElement instanceof SubflowState) {
                WebflowRelatedItemLineMarkerProvider.installSubflowState(result, (SubflowState)domElement);
                continue;
            }
            if (!(domElement instanceof BeanImport)) continue;
            WebflowRelatedItemLineMarkerProvider.installBeanImport(result, (BeanImport)domElement);
        }
    }

    private static void installFlowDefinition(Collection<? super RelatedItemLineMarkerInfo<?>> result, Project project, Flow flow, WebflowModel webflowModel) {
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)SpringApiIcons.SpringBean, dom -> ContainerUtil.createMaybeSingletonList((Object)PomService.convertToPsi((Project)project, (PomTarget)dom)), pomTarget -> {
            if (pomTarget instanceof DomTarget) {
                DomElement element = ((DomTarget)pomTarget).getDomElement();
                return DEFINITION_DOM_ITEM_PROVIDER.fun(element);
            }
            List psiElement = ContainerUtil.createMaybeSingletonList((Object)PomService.convertToPsi((Project)project, (PomTarget)pomTarget));
            return GotoRelatedItem.createItems((Collection)psiElement, (String)WebflowBundle.message("navigation.related.flow.definition", new Object[0]));
        }).setAlignment(GutterIconRenderer.Alignment.RIGHT).setTooltipText(WebflowBundle.message("navigation.related.flow.definition.tooltip", new Object[0])).setTarget((Object)webflowModel.getDefinition());
        WebflowRelatedItemLineMarkerProvider.addLineMarker(result, flow, builder);
    }

    private static void addLineMarker(Collection<? super RelatedItemLineMarkerInfo<?>> result, DomElement flow, NavigationGutterIconBuilder<?> builder) {
        XmlToken identifier;
        XmlTag tag = flow.getXmlTag();
        XmlToken xmlToken = identifier = tag == null ? null : XmlTagUtil.getStartTagNameElement((XmlTag)tag);
        if (identifier != null) {
            result.add(builder.createLineMarkerInfo((PsiElement)identifier));
        }
    }

    private static void installFlowParent(Collection<? super RelatedItemLineMarkerInfo<?>> result, Flow flow) {
        GenericAttributeValue<List<Flow>> parentFlow = flow.getParentFlow();
        if (!DomUtil.hasXml(parentFlow)) {
            return;
        }
        List<Flow> parentFlows = flow.getAllParentFlows();
        if (parentFlows.isEmpty()) {
            return;
        }
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)AllIcons.Gutter.OverridingMethod, (NotNullFunction)NavigationGutterIconBuilder.DEFAULT_DOM_CONVERTOR, (NotNullFunction)PARENT_RELATED_DOM_ITEM_PROVIDER).setAlignment(GutterIconRenderer.Alignment.LEFT).setPopupTitle(WebflowBundle.message("navigation.related.flow.parent.flow", new Object[0])).setTooltipText(WebflowBundle.message("navigation.related.flow.parent.flow.tooltip", new Object[0])).setCellRenderer((PsiElementListCellRenderer)new DomElementListCellRenderer("")).setTargets(parentFlows);
        WebflowRelatedItemLineMarkerProvider.addLineMarker(result, flow, builder);
    }

    private static void installFlowInheriting(Collection<? super RelatedItemLineMarkerInfo<?>> result, Flow flow) {
        List<Flow> inheritingFlows = flow.getInheritingFlows();
        if (inheritingFlows.isEmpty()) {
            return;
        }
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)AllIcons.Gutter.OverridenMethod, (NotNullFunction)NavigationGutterIconBuilder.DEFAULT_DOM_CONVERTOR, (NotNullFunction)INHERITING_RELATED_DOM_ITEM_PROVIDER).setAlignment(GutterIconRenderer.Alignment.CENTER).setPopupTitle(WebflowBundle.message("navigation.related.flow.inheriting.flow", new Object[0])).setTooltipText(WebflowBundle.message("navigation.related.flow.inheriting.flow.tooltip", new Object[0])).setCellRenderer((PsiElementListCellRenderer)new DomElementListCellRenderer("")).setTargets(inheritingFlows);
        WebflowRelatedItemLineMarkerProvider.addLineMarker(result, flow, builder);
    }

    private static void installSubflowState(Collection<? super RelatedItemLineMarkerInfo<?>> result, SubflowState subflowState) {
        GenericAttributeValue<Flow> subflow = subflowState.getSubflow();
        if (!DomUtil.hasXml(subflow) || subflow.getValue() == null) {
            return;
        }
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)SpringWebflowIcons.SpringWebFlow, (NotNullFunction)NavigationGutterIconBuilder.DEFAULT_DOM_CONVERTOR, (NotNullFunction)SUBFLOW_RELATED_DOM_ITEM_PROVIDER).setAlignment(GutterIconRenderer.Alignment.RIGHT).setTooltipText(WebflowBundle.message("navigation.related.subflow.flow.tooltip", new Object[0])).setTarget((Object)((DomElement)subflow.getValue()));
        WebflowRelatedItemLineMarkerProvider.addLineMarker(result, subflow, builder);
    }

    private static void installBeanImport(Collection<? super RelatedItemLineMarkerInfo<?>> result, BeanImport beanImport) {
        PsiFileSystemItem targetFile = (PsiFileSystemItem)beanImport.getResource().getValue();
        if (targetFile == null) {
            return;
        }
        if (!BeanImportResourceConverter.SPRING_XML_CONDITION.value((Object)targetFile)) {
            return;
        }
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)targetFile.getIcon(0)).setAlignment(GutterIconRenderer.Alignment.LEFT).setTooltipText(WebflowBundle.message("navigation.related.bean.import.tooltip", new Object[0])).setTarget((Object)targetFile);
        WebflowRelatedItemLineMarkerProvider.addLineMarker(result, beanImport, builder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/webflow/navigation/WebflowRelatedItemLineMarkerProvider";
        objectArray[2] = "collectNavigationMarkers";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyRelatedDomItemProvider
    implements NotNullFunction<DomElement, Collection<? extends GotoRelatedItem>> {
        private final @NlsContexts.Separator String myGroupName;

        private MyRelatedDomItemProvider(@NlsContexts.Separator String groupName) {
            this.myGroupName = groupName;
        }

        @NotNull
        public Collection<? extends GotoRelatedItem> fun(DomElement dom) {
            XmlElement element = dom.getXmlElement();
            if (element == null) {
                List list = Collections.emptyList();
                if (list == null) {
                    MyRelatedDomItemProvider.$$$reportNull$$$0(0);
                }
                return list;
            }
            Set<DomGotoRelatedItem> set = Collections.singleton(new DomGotoRelatedItem(dom, this.myGroupName));
            if (set == null) {
                MyRelatedDomItemProvider.$$$reportNull$$$0(1);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/navigation/WebflowRelatedItemLineMarkerProvider$MyRelatedDomItemProvider", "fun"));
        }
    }
}

