/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.navigation;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.webflow.model.WebflowDomModelManager;
import com.intellij.spring.webflow.model.WebflowModel;
import com.intellij.spring.webflow.model.xml.ViewState;
import com.intellij.spring.webflow.resources.WebflowBundle;
import com.intellij.spring.webflow.util.WebflowUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebflowJavaLineMarkerProvider
implements LineMarkerProvider {
    private static final String VALIDATE_METHOD_PREFIX = "validate";
    private static final String VALIDATOR_CLASS_SUFFIX = "Validator";

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            WebflowJavaLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        PsiElement firstItem;
        if (elements == null) {
            WebflowJavaLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            WebflowJavaLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if ((firstItem = (PsiElement)ContainerUtil.getFirstItem(elements)) == null) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)firstItem);
        if (!WebflowUtil.isWebFlowAvailable(module)) {
            return;
        }
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            PsiElement element = elements.get(i);
            WebflowJavaLineMarkerProvider.annotate(module, element, result);
        }
    }

    private static void annotate(@NotNull Module module, @NotNull PsiElement element, @NotNull Collection<? super LineMarkerInfo<?>> holder) {
        if (module == null) {
            WebflowJavaLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (element == null) {
            WebflowJavaLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            WebflowJavaLineMarkerProvider.$$$reportNull$$$0(5);
        }
        if (!(element instanceof PsiIdentifier)) {
            return;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiMethod)) {
            return;
        }
        PsiMethod method = (PsiMethod)parent;
        ViewState viewState = WebflowJavaLineMarkerProvider.findViewStateForValidationMethod(module, method);
        if (viewState == null || !viewState.isValid()) {
            return;
        }
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)Objects.requireNonNull(viewState.getPresentation().getIcon())).setTooltipText(WebflowBundle.message("navigation.code.validation.method.to.view.state", new Object[0])).setTarget((Object)viewState.getXmlTag());
        holder.add((LineMarkerInfo<?>)builder.createLineMarkerInfo(element));
    }

    @Nullable
    private static ViewState findViewStateForValidationMethod(Module module, PsiMethod method) {
        if (!WebflowJavaLineMarkerProvider.isValidationMethod(method)) {
            return null;
        }
        PsiClass modelClass = WebflowJavaLineMarkerProvider.findModelClass(method);
        if (modelClass == null) {
            return null;
        }
        String viewStateIdFromMethodName = StringUtil.decapitalize((String)StringUtil.notNullize((String)StringUtil.substringAfter((String)method.getName(), (String)VALIDATE_METHOD_PREFIX)));
        List<WebflowModel> webflowModels = WebflowDomModelManager.getAllModels(module);
        for (WebflowModel model : webflowModels) {
            for (ViewState state : model.getFlow().getViewStates()) {
                if (!Objects.equals(state.getId().getStringValue(), viewStateIdFromMethodName) || !modelClass.equals(state.getModelClass())) continue;
                if (modelClass.equals(method.getContainingClass())) {
                    return state;
                }
                String validatorBeanName = state.getModel().getStringValue() + VALIDATOR_CLASS_SUFFIX;
                for (SpringModel springModel : SpringManager.getInstance((Project)method.getProject()).getAllModels(module)) {
                    SpringBeanPointer springBeanPointer = SpringModelSearchers.findBean((CommonSpringModel)springModel, (String)validatorBeanName);
                    if (springBeanPointer == null) continue;
                    return state;
                }
            }
        }
        return null;
    }

    @Nullable
    private static PsiClass findModelClass(PsiMethod method) {
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.getParametersCount() == 1) {
            return containingClass;
        }
        PsiParameter modelParameter = parameterList.getParameters()[0];
        PsiType type = modelParameter.getType();
        if (type instanceof PsiClassType) {
            return ((PsiClassType)type).resolve();
        }
        return null;
    }

    private static boolean isValidationMethod(PsiMethod method) {
        if (!method.hasModifierProperty("public")) {
            return false;
        }
        if (method.hasModifierProperty("static")) {
            return false;
        }
        if (!PsiType.VOID.equals((Object)method.getReturnType())) {
            return false;
        }
        String methodName = method.getName();
        if (!StringUtil.startsWith((CharSequence)methodName, (CharSequence)VALIDATE_METHOD_PREFIX)) {
            return false;
        }
        PsiParameterList parameterList = method.getParameterList();
        int parametersCount = parameterList.getParametersCount();
        if (parametersCount == 0 || parametersCount > 2) {
            return false;
        }
        PsiParameter toCheck = parameterList.getParameters()[parametersCount - 1];
        PsiType psiType = toCheck.getType();
        return psiType instanceof PsiClassType && psiType.getCanonicalText().equals("org.springframework.binding.validation.ValidationContext");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/webflow/navigation/WebflowJavaLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectSlowLineMarkers";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

