/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.navigation;

import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.util.FindClassUtil;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.spring.webflow.model.xml.Identified;
import com.intellij.spring.webflow.util.WebflowUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.model.gotosymbol.GoToSymbolProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class WebflowIdentifiedGotoSymbolProvider
extends GoToSymbolProvider {
    private static final Function<Flow, Collection<? extends Identified>> IDENTIFIED_ELEMENTS_FUNCTION = flow -> ContainerUtil.concat((List[])new List[]{flow.getActionStates(), flow.getDecisionStates(), flow.getEndStates(), flow.getInlineFlows(), flow.getSubflowStates(), flow.getViewStates()});

    protected void addNames(@NotNull Module module, Set<String> result) {
        if (module == null) {
            WebflowIdentifiedGotoSymbolProvider.$$$reportNull$$$0(0);
        }
        ContainerUtil.process(WebflowIdentifiedGotoSymbolProvider.getIdentifiedElements(module), identified -> {
            result.add(identified.getId().getStringValue());
            return true;
        });
    }

    protected void addItems(@NotNull Module module, String name, List<NavigationItem> result) {
        if (module == null) {
            WebflowIdentifiedGotoSymbolProvider.$$$reportNull$$$0(1);
        }
        ContainerUtil.process(WebflowIdentifiedGotoSymbolProvider.getIdentifiedElements(module), identified -> {
            if (Comparing.strEqual((String)name, (String)identified.getId().getStringValue())) {
                result.add(WebflowIdentifiedGotoSymbolProvider.createNavigationItem((DomElement)identified));
            }
            return true;
        });
    }

    @NotNull
    protected Collection<Module> calcAcceptableModules(@NotNull Project project) {
        if (project == null) {
            WebflowIdentifiedGotoSymbolProvider.$$$reportNull$$$0(2);
        }
        Collection collection = FindClassUtil.findModulesWithClass((Project)project, (String)"org.springframework.webflow.execution.Action");
        if (collection == null) {
            WebflowIdentifiedGotoSymbolProvider.$$$reportNull$$$0(3);
        }
        return collection;
    }

    protected boolean acceptModule(Module module) {
        return WebflowUtil.isWebFlowAvailable(module);
    }

    private static List<Identified> getIdentifiedElements(Module module) {
        List<Flow> flows = WebflowUtil.getAllFlows(module, Collections.emptyList());
        return ContainerUtil.concat(flows, IDENTIFIED_ELEMENTS_FUNCTION);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/webflow/navigation/WebflowIdentifiedGotoSymbolProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/webflow/navigation/WebflowIdentifiedGotoSymbolProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "calcAcceptableModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addNames";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addItems";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calcAcceptableModules";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

