/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.model.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.webflow.model.WebflowModel;
import com.intellij.spring.webflow.model.impl.FlowDefinition;
import com.intellij.spring.webflow.model.impl.FlowDefinitionCollector;
import com.intellij.spring.webflow.model.impl.WebflowModelImpl;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebflowDomModelFactory {
    public static List<WebflowModel> getAllModels(@NotNull Module module) {
        if (module == null) {
            WebflowDomModelFactory.$$$reportNull$$$0(0);
        }
        List<FlowDefinition> definitions = FlowDefinitionCollector.forModule(module);
        ArrayList<WebflowModel> models = new ArrayList<WebflowModel>(definitions.size());
        for (FlowDefinition definition : definitions) {
            WebflowModel webflowModel = WebflowDomModelFactory.createSingleModel(definition, module);
            ContainerUtil.addIfNotNull(models, (Object)webflowModel);
        }
        return models;
    }

    @Nullable
    private static WebflowModel createSingleModel(FlowDefinition flowDefinition, @NotNull Module module) {
        PsiFile file;
        if (module == null) {
            WebflowDomModelFactory.$$$reportNull$$$0(1);
        }
        if (!((file = PsiManager.getInstance((Project)module.getProject()).findFile(flowDefinition.getFlowXml())) instanceof XmlFile)) {
            return null;
        }
        XmlFile flowXml = (XmlFile)file;
        DomFileElement flowDomFileElement = DomManager.getDomManager((Project)module.getProject()).getFileElement(flowXml, Flow.class);
        if (flowDomFileElement == null) {
            return null;
        }
        return new WebflowModelImpl((DomFileElement<Flow>)flowDomFileElement, Collections.singleton(flowXml), flowDefinition.getDefinition(), flowDefinition.getName());
    }

    @Nullable
    public static WebflowModel getModelByConfigFile(@NotNull XmlFile file) {
        XmlFile originalFile;
        Module module;
        if (file == null) {
            WebflowDomModelFactory.$$$reportNull$$$0(2);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)(originalFile = (XmlFile)file.getOriginalFile()))) == null) {
            return null;
        }
        for (WebflowModel model : WebflowDomModelFactory.getAllModels(module)) {
            if (!model.getConfigFiles().contains(originalFile)) continue;
            return model;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/webflow/model/impl/WebflowDomModelFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllModels";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createSingleModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getModelByConfigFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

