/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.model.converters;

import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.spring.webflow.config.model.xml.version2_0.FlowLocation;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

final class WebflowConverterUtil {
    private WebflowConverterUtil() {
    }

    static boolean isCustomFlowIdReference(@Nullable PsiElement psiElement) {
        if (psiElement instanceof XmlAttributeValue) {
            DomElement domElement = DomUtil.getDomElement((PsiElement)psiElement);
            if (domElement == null) {
                return false;
            }
            if (!Objects.equals("id", domElement.getXmlElementName())) {
                return false;
            }
            FlowLocation flowLocation = (FlowLocation)domElement.getParentOfType(FlowLocation.class, true);
            if (flowLocation != null && DomUtil.hasXml(flowLocation.getId())) {
                return true;
            }
        }
        return false;
    }
}

