/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.model.converters;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.spring.webflow.model.xml.ViewOwner;
import com.intellij.spring.webflow.util.WebflowUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NotNull;

public class ViewStateIdConverter
implements CustomReferenceConverter {
    public PsiReference @NotNull [] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
        String stringValue = genericDomValue.getStringValue();
        if (stringValue != null && WebflowUtil.isDynamicExpression(stringValue)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ViewStateIdConverter.$$$reportNull$$$0(0);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        ViewOwner viewOwner = (ViewOwner)genericDomValue.getParentOfType(ViewOwner.class, true);
        assert (viewOwner != null);
        if (DomUtil.hasXml(viewOwner.getView())) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ViewStateIdConverter.$$$reportNull$$$0(1);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new MyViewStateIdReference(element, genericDomValue)};
        if (psiReferenceArray == null) {
            ViewStateIdConverter.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/converters/ViewStateIdConverter", "createReferences"));
    }

    private static final class MyViewStateIdReference
    extends PsiReferenceBase<PsiElement> {
        private static final Function<PsiFile, LookupElement> FILE_VARIANT_MAPPER = psiFile -> LookupElementBuilder.create((Object)psiFile, (String)FileUtilRt.getNameWithoutExtension((String)psiFile.getName())).withIcon(psiFile.getIcon(0));
        private final GenericDomValue myGenericDomValue;

        private MyViewStateIdReference(PsiElement element, GenericDomValue genericDomValue) {
            super(element, true);
            this.myGenericDomValue = genericDomValue;
        }

        public PsiElement resolve() {
            PsiReference[] reference;
            String value = this.getValue();
            PsiFile file = (PsiFile)ContainerUtil.find((Object[])this.getFiles(), psiFile -> Comparing.strEqual((String)FileUtilRt.getNameWithoutExtension((String)psiFile.getName()), (String)value));
            if (file != null) {
                return file;
            }
            for (PsiReference psiReference : reference = PathReferenceManager.getInstance().createReferences(this.getElement(), true, new PathReferenceProvider[0])) {
                PsiElement resolve = psiReference.resolve();
                if (resolve == null) continue;
                return resolve;
            }
            return null;
        }

        public Object @NotNull [] getVariants() {
            Object[] objectArray = ContainerUtil.map2Array((Object[])this.getFiles(), LookupElement.class, FILE_VARIANT_MAPPER);
            if (objectArray == null) {
                MyViewStateIdReference.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                MyViewStateIdReference.$$$reportNull$$$0(1);
            }
            if (element instanceof PsiFile) {
                PsiFile psiFile = (PsiFile)element;
                this.myGenericDomValue.setStringValue(FileUtilRt.getNameWithoutExtension((String)psiFile.getName()));
                return this.myElement;
            }
            return super.bindToElement(element);
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                MyViewStateIdReference.$$$reportNull$$$0(2);
            }
            return super.handleElementRename(FileUtilRt.getNameWithoutExtension((String)newElementName));
        }

        private PsiFile[] getFiles() {
            PsiFile file = this.myElement.getContainingFile().getOriginalFile();
            PsiDirectory directory = file.getContainingDirectory();
            assert (directory != null);
            return (PsiFile[])ArrayUtil.remove((Object[])directory.getFiles(), (Object)file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/webflow/model/converters/ViewStateIdConverter$MyViewStateIdReference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/webflow/model/converters/ViewStateIdConverter$MyViewStateIdReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

