/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.model.converters;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.webflow.model.WebflowDomModelManager;
import com.intellij.spring.webflow.model.converters.WebflowConverterUtil;
import com.intellij.spring.webflow.model.converters.WebflowLookupUtil;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.spring.webflow.resources.WebflowBundle;
import com.intellij.spring.webflow.util.WebflowUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubflowFlowConverter
extends ResolvingConverter<Flow>
implements CustomReferenceConverter<Flow> {
    private static final Condition<Flow> NON_ABSTRACT_FLOW_CONDITION = flow -> Boolean.TRUE != flow.getAbstract().getValue();

    public Flow fromString(@Nullable @NonNls String s, ConvertContext context) {
        Module module = context.getModule();
        if (module == null) {
            return null;
        }
        Flow flow = WebflowDomModelManager.findFlowByName(module, s);
        if (flow == null) {
            return null;
        }
        return NON_ABSTRACT_FLOW_CONDITION.value((Object)flow) ? flow : null;
    }

    public String toString(@Nullable Flow flow, ConvertContext context) {
        return flow == null ? null : WebflowUtil.getFlowName(flow);
    }

    @NotNull
    public Collection<? extends Flow> getVariants(ConvertContext context) {
        Module module = context.getModule();
        if (module == null) {
            Set set = Collections.emptySet();
            if (set == null) {
                SubflowFlowConverter.$$$reportNull$$$0(0);
            }
            return set;
        }
        List<Flow> allFlows = WebflowUtil.getAllFlows(module, Collections.singletonList(context.getFile().getOriginalFile()));
        List list = ContainerUtil.filter(allFlows, NON_ABSTRACT_FLOW_CONDITION);
        if (list == null) {
            SubflowFlowConverter.$$$reportNull$$$0(1);
        }
        return list;
    }

    public LookupElement createLookupElement(Flow flow) {
        return WebflowLookupUtil.forFlow(flow);
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return WebflowBundle.message("parent.flows.converter.cannot.find.flow", s);
    }

    public PsiReference @NotNull [] createReferences(GenericDomValue<Flow> flowGenericDomValue, PsiElement element, ConvertContext context) {
        Flow flow = (Flow)flowGenericDomValue.getValue();
        if (flow == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SubflowFlowConverter.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{SubflowFlowConverter.createFlowNameReference(flow, element)};
        if (psiReferenceArray == null) {
            SubflowFlowConverter.$$$reportNull$$$0(3);
        }
        return psiReferenceArray;
    }

    private static PsiReference createFlowNameReference(final @NotNull Flow flow, PsiElement element) {
        if (flow == null) {
            SubflowFlowConverter.$$$reportNull$$$0(4);
        }
        return new PsiReferenceBase<PsiElement>(element, true){

            public PsiElement resolve() {
                return WebflowUtil.resolveFlow(flow);
            }

            public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                if (newElementName == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (this.resolve() instanceof XmlFile) {
                    String name = FileUtilRt.getNameWithoutExtension((String)newElementName);
                    return super.handleElementRename(name);
                }
                return super.handleElementRename(newElementName);
            }

            public boolean isReferenceTo(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(1);
                }
                return super.isReferenceTo(element) || WebflowConverterUtil.isCustomFlowIdReference(element);
            }

            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                VirtualFile file;
                if (element == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (element instanceof XmlFile && (file = ((XmlFile)element).getVirtualFile()) != null) {
                    return super.handleElementRename(file.getNameWithoutExtension());
                }
                return this.getElement();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newElementName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/spring/webflow/model/converters/SubflowFlowConverter$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleElementRename";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isReferenceTo";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "bindToElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/webflow/model/converters/SubflowFlowConverter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/webflow/model/converters/SubflowFlowConverter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFlowNameReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

