/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.model.converters;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiTarget;
import com.intellij.spring.webflow.model.converters.ParentStateFlowReference;
import com.intellij.spring.webflow.model.converters.WebflowLookupUtil;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.spring.webflow.model.xml.Identified;
import com.intellij.spring.webflow.resources.WebflowBundle;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParentStateReference
extends PsiReferenceBase<PsiElement>
implements EmptyResolveMessageProvider {
    private final List<Identified> myCandidates;

    ParentStateReference(@NotNull PsiElement element, TextRange textRange, GenericDomValue<String> value, @Nullable ParentStateFlowReference parentStateFlowReference) {
        if (element == null) {
            ParentStateReference.$$$reportNull$$$0(0);
        }
        super(element, textRange, true);
        this.myCandidates = ParentStateReference.findParentStates(value, parentStateFlowReference);
    }

    public PsiElement resolve() {
        Identified identified = this.getIdentified();
        if (identified == null) {
            return null;
        }
        DomTarget target = DomTarget.getTarget((DomElement)identified);
        return target != null ? PomService.convertToPsi((PsiTarget)target) : null;
    }

    public Object @NotNull [] getVariants() {
        Object[] objectArray = ContainerUtil.map2Array(this.myCandidates, WebflowLookupUtil::forIdentified);
        if (objectArray == null) {
            ParentStateReference.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = WebflowBundle.message("parent.state.converter.can.not.resolve", new Object[0]);
        if (string == null) {
            ParentStateReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public Identified getIdentified() {
        String value = this.getValue();
        return (Identified)ContainerUtil.find(this.myCandidates, identified -> value.equals(identified.getId().getStringValue()));
    }

    private static List<Identified> findParentStates(GenericDomValue<String> value, @Nullable ParentStateFlowReference parentStateFlowReference) {
        Flow flow;
        Identified type = (Identified)value.getParentOfType(Identified.class, true);
        if (type == null) {
            return Collections.emptyList();
        }
        Flow flow2 = flow = parentStateFlowReference != null ? parentStateFlowReference.getFlow() : (Flow)type.getParentOfType(Flow.class, true);
        if (flow == null) {
            return Collections.emptyList();
        }
        ArrayList<Identified> candidates = new ArrayList<Identified>(DomUtil.getChildrenOfType((DomElement)flow, type.getClass()));
        candidates.remove(type);
        return candidates;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/webflow/model/converters/ParentStateReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/webflow/model/converters/ParentStateReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

